package com.ejie.y42b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.AmbitoGeograficoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.AmbitoGeografico;

/**
 *  * AmbitoGeograficoServiceImpl  
 *  
 */

@Service(value = "ambitoGeograficoService")
public  class AmbitoGeograficoServiceImpl implements AmbitoGeograficoService {

	private static final  Logger logger = LoggerFactory.getLogger(AmbitoGeograficoServiceImpl.class);
	@Autowired
	private AmbitoGeograficoDao ambitoGeograficoDao;

	/**
	 * Inserts a single row in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @return AmbitoGeografico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AmbitoGeografico add(AmbitoGeografico ambitoGeografico) {
		return this.ambitoGeograficoDao.add(ambitoGeografico);
	}

	/**
	 * Updates a single row in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @return AmbitoGeografico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public AmbitoGeografico update(AmbitoGeografico ambitoGeografico) {
		return this.ambitoGeograficoDao.update(ambitoGeografico);
	 }

	/**
	 * Finds a single row in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @return AmbitoGeografico
	 */
	public AmbitoGeografico find(AmbitoGeografico ambitoGeografico) {
		return (AmbitoGeografico) this.ambitoGeograficoDao.find(ambitoGeografico);
	}

	/**
	 * Finds a List of rows in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @param pagination Pagination
	 * @return List
	 */
	public List<AmbitoGeografico> findAll(AmbitoGeografico ambitoGeografico, Pagination pagination) {
		return (List<AmbitoGeografico>) this.ambitoGeograficoDao.findAll(ambitoGeografico, pagination);
	}
    
	/**
	 * Counts rows in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @return Long
	 */
	public Long findAllCount(AmbitoGeografico ambitoGeografico) {        
		return  this.ambitoGeograficoDao.findAllCount(ambitoGeografico);
	}

	/**
	 * Finds rows in the AmbitoGeografico table using like.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<AmbitoGeografico> findAllLike(AmbitoGeografico ambitoGeografico, Pagination pagination, Boolean startsWith) {
		return (List<AmbitoGeografico>) this.ambitoGeograficoDao.findAllLike(ambitoGeografico, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the AmbitoGeografico table.
	 *
	 * @param ambitoGeografico AmbitoGeografico
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(AmbitoGeografico ambitoGeografico) {
		this.ambitoGeograficoDao.remove(ambitoGeografico);
	}
	
	/**
	 * Deletes multiple rows in the AmbitoGeografico table.
	 *
	 * @param ambitoGeograficoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<AmbitoGeografico> ambitoGeograficoList) {
		for (AmbitoGeografico  ambitoGeograficoAux:ambitoGeograficoList) {
			this.ambitoGeograficoDao.remove(ambitoGeograficoAux);
		}
	}


	/**
	 * Getter method for AmbitoGeograficoDao
	 *
	 * @return AmbitoGeograficoDao
	 */
	public AmbitoGeograficoDao getAmbitoGeograficoDao() {
		return this.ambitoGeograficoDao;
	}
    
	/**
	 * Setter method for AmbitoGeograficoDao.
	 *
	 * @param  ambitoGeograficoDao AmbitoGeograficoDao
	 * @return
	 */
	public void setAmbitoGeograficoDao(AmbitoGeograficoDao ambitoGeograficoDao) {
		logger.info("Setting Dependency "+ambitoGeograficoDao);
		this.ambitoGeograficoDao = ambitoGeograficoDao;
	}
}

