package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.dao.AdjuntoDao;
import com.ejie.y42b.model.Adjunto;

/**
 * * AdjuntoServiceImpl  
 * 
 *  
 */

@Service(value = "adjuntoService")
public class AdjuntoServiceImpl implements AdjuntoService {

	private static final Logger logger = LoggerFactory
			.getLogger(AdjuntoServiceImpl.class);
	@Autowired()
	private AdjuntoDao adjuntoDao;

	/**
	 * Inserts a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjunto add(Adjunto adjunto) {
		return this.adjuntoDao.add(adjunto);
	}

	/**
	 * Updates a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Adjunto update(Adjunto adjunto) {
		return this.adjuntoDao.update(adjunto);
	}

	/**
	 * Finds a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	public Adjunto find(Adjunto adjunto) {
		return (Adjunto) this.adjuntoDao.find(adjunto);
	}

	/**
	 * Finds a List of rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Adjunto> findAll(Adjunto adjunto, Pagination pagination) {
		return (List<Adjunto>) this.adjuntoDao.findAll(adjunto, pagination);
	}

	/**
	 * Counts rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Long
	 */
	public Long findAllCount(Adjunto adjunto) {
		return this.adjuntoDao.findAllCount(adjunto);
	}

	/**
	 * Finds rows in the Adjunto table using like.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Adjunto> findAllLike(Adjunto adjunto, Pagination pagination,
			Boolean startsWith) {
		return (List<Adjunto>) this.adjuntoDao.findAllLike(adjunto, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Adjunto adjunto) {
		this.adjuntoDao.remove(adjunto);
	}
	
	/**
	 * Deletes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAdjunto(Adjunto adjunto) {
		this.adjuntoDao.removeAdjunto(adjunto);
	}

	/**
	 * Deletes multiple rows in the Adjunto table.
	 * 
	 * @param adjuntoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Adjunto> adjuntoList) {
		for (Adjunto adjuntoAux : adjuntoList) {
			this.adjuntoDao.remove(adjuntoAux);
		}
	}

	/**
	 * Getter method for AdjuntoDao
	 * 
	 * @return AdjuntoDao
	 */
	public AdjuntoDao getAdjuntoDao() {
		return this.adjuntoDao;
	}

	/**
	 * Setter method for AdjuntoDao.
	 * 
	 * @param adjuntoDao
	 *            AdjuntoDao
	 * @return
	 */
	public void setAdjuntoDao(AdjuntoDao adjuntoDao) {
		AdjuntoServiceImpl.logger.info("Setting Dependency " + adjuntoDao);
		this.adjuntoDao = adjuntoDao;
	}
}
