package com.ejie.y42b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Adjunto;

/**
 * * AdjuntoService  
 * 
 *  
 */

public interface AdjuntoService {

	/**
	 * Inserts a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	Adjunto add(Adjunto adjunto);

	/**
	 * Updates a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	Adjunto update(Adjunto adjunto);

	/**
	 * Finds a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Adjunto
	 */
	Adjunto find(Adjunto adjunto);

	/**
	 * Finds a List of rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjunto> findAll(Adjunto adjunto, Pagination pagination);

	/**
	 * Counts rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Long
	 */
	Long findAllCount(Adjunto adjunto);

	/**
	 * Finds rows in the Adjunto table using like.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Adjunto> findAllLike(Adjunto adjunto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return
	 */
	void remove(Adjunto adjunto);

	/**
	 * Deletes multiple rows in the Adjunto table.
	 * 
	 * @param adjuntoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Adjunto> adjuntoList);
	/**
	 * Deletes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return
	 */
	void removeAdjunto(Adjunto adjunto);

}
