package com.ejie.y42b.security;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.access.AccessDeniedException;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.PerfilesXlnets;
import com.ejie.y42b.service.PerfilesXlnetsService;

public class PreAuthenticateProcessingFilter extends
		com.ejie.x38.security.PreAuthenticateProcessingFilter {

	@Resource
	private PerfilesXlnetsService perfilesXlnetsService;

	private static final Logger logger = LoggerFactory
			.getLogger(PreAuthenticateProcessingFilter.class);

	protected synchronized Object getPreAuthenticatedPrincipal(
			HttpServletRequest httpRequest) {
		Object object = super.getPreAuthenticatedPrincipal(httpRequest);
		if (object != null) {
			try {
				if (super.getPerimetralSecurityWrapper() != null) {
					if (httpRequest.getSession().getAttribute(
							Y42bAgendaConstantes.SESSIONTIPOACCESO) == null) {

						String username = super.getPerimetralSecurityWrapper()
								.getUserConnectedUserName(httpRequest);

						logger.info("######################################username["
								+ username + "]");

						boolean isCertificate = super
								.getPerimetralSecurityWrapper()
								.getIsCertificate(httpRequest);

						HashMap<String, String> userData = super
								.getPerimetralSecurityWrapper()
								.getUserDataInfo(httpRequest, isCertificate);
						String fullName = userData.get("fullName");

						httpRequest
								.getSession()
								.setAttribute(
										Y42bAgendaConstantes.SESSIONOMBREUSUARIOCONECTADO,
										fullName);

						Vector<String> perfiles = (Vector) super
								.getPerimetralSecurityWrapper()
								.getUserInstances(httpRequest);

						if (perfiles != null && perfiles.size() > 0) {
							for (int i = 0; i < perfiles.size(); i++) {
								logger.info("######################################perfil"
										+ i + "[" + perfiles.get(i) + "]");
							}
						}

						List<PerfilesXlnets> listPerfilesXlnets = perfilesXlnetsService
								.findAllPerfiles(perfiles, null);

						if (listPerfilesXlnets == null
								|| listPerfilesXlnets.size() == 0) {
							logger.info("######################################SIN PERFILES");
							throw new AccessDeniedException("");
						} else {
							logger.info("######################################TIPOACCESO["
									+ listPerfilesXlnets.get(0).getTipoacceso()
									+ "]");
							httpRequest.getSession().setAttribute(
									Y42bAgendaConstantes.SESSIONTIPOACCESO,
									listPerfilesXlnets.get(0).getTipoacceso());
						}
					}
				}
			} catch (EmptyResultDataAccessException e) {
				throw new AccessDeniedException("");
			} catch (Throwable ex) {
				throw new AccessDeniedException("");
			}
		}
		return object;
	}
}
