package com.ejie.y42b.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;

/**
 * 
 *  
 *
 */
public class Y42bGrupo {
	@Length(max = Y42bAgendaConstantes.NUM_40)
	private String grupoId;
	@Length(max = Y42bAgendaConstantes.NUM_40)
	private String padreId;
	private BigDecimal nivel;
	@Length(max = Y42bAgendaConstantes.NUM_255, message = "length.nombre")
	@NotEmpty(message = "required.grupo_nombreCast")
	@NotNull(message = "required.grupo_nombreCast")
	private String nombreEs;
	@Length(max =Y42bAgendaConstantes.NUM_255, message = "length.nombre")
	@NotEmpty(message = "required.grupo_nombreEusk")
	@NotNull(message = "required.grupo_nombreEusk")
	private String nombreEu;
	private String grupoPadreId;
	@Length(min = Y42bAgendaConstantes.NUM_1, max = Y42bAgendaConstantes.NUM_1)
	private String activa;
	@Length(max = Y42bAgendaConstantes.NUM_12, message = "length.usuultmod")
	private String usuultmod;
	private Date fecultmod;
	private List<?> lstChildren = new ArrayList();
	private List<Entidad> entidads = new ArrayList<Entidad>();

	/**
	 * Method 'Grupo'.
	 * 
	 */
	public Y42bGrupo() {
	}

	/**
	 * Method 'Grupo'.
	 * 
	 * @param grupoId
	 *            String
	 * @param nivel
	 *            BigDecimal
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param grupoPadreId
	 *            String
	 * @param activa
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 */
	public Y42bGrupo(String grupoId, BigDecimal nivel, String nombreEs, String nombreEu, String grupoPadreId, String activa, String usuultmod, Date fecultmod) {
		this.grupoId = grupoId;
		this.nivel = nivel;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.grupoPadreId = grupoPadreId;
		this.activa = activa;
		this.usuultmod = usuultmod;
		this.fecultmod = fecultmod;
	}

	/**
	 * Method 'Grupo'.
	 * 
	 * @param grupoId
	 *            String
	 * @param nivel
	 *            BigDecimal
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param grupoPadreId
	 *            String
	 * @param activa
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param entidads
	 *            List<Entidad>
	 */
	public Y42bGrupo(String grupoId, BigDecimal nivel, String nombreEs, String nombreEu, String grupoPadreId, String activa, String usuultmod, Date fecultmod, List<Entidad> entidads) {

		this.grupoId = grupoId;
		this.nivel = nivel;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.grupoPadreId = grupoPadreId;
		this.activa = activa;
		this.usuultmod = usuultmod;
		this.fecultmod = fecultmod;
		this.entidads = entidads;
	}

	/**
	 * @return the grupoId
	 */
	public String getGrupoId() {
		return this.grupoId;
	}

	/**
	 * @param grupoId
	 *            the grupoId to set
	 */
	public void setGrupoId(String grupoId) {
		this.grupoId = grupoId;
	}

	/**
	 * @return the padreId
	 */
	public String getPadreId() {
		return this.padreId;
	}

	/**
	 * @param padreId
	 *            the padreId to set
	 */
	public void setPadreId(String padreId) {
		this.padreId = padreId;
	}

	/**
	 * @return the lstChildren
	 */
	public List<?> getLstChildren() {
		return this.lstChildren;
	}

	/**
	 * @param lstChildren
	 *            the lstChildren to set
	 */
	public void setLstChildren(List<?> lstChildren) {
		this.lstChildren = lstChildren;
	}

	/**
	 * @return the nivel
	 */
	public BigDecimal getNivel() {
		return this.nivel;
	}

	/**
	 * @param nivel
	 *            the nivel to set
	 */
	public void setNivel(BigDecimal nivel) {
		this.nivel = nivel;
	}

	/**
	 * @return the nombreEs
	 */
	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * @param nombreEs
	 *            the nombreEs to set
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * @return the nombreEu
	 */
	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * @param nombreEu
	 *            the nombreEu to set
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the grupoPadreId
	 */
	public String getGrupoPadreId() {
		return this.grupoPadreId;
	}

	/**
	 * @param grupoPadreId
	 *            the grupoPadreId to set
	 */
	public void setGrupoPadreId(String grupoPadreId) {
		this.grupoPadreId = grupoPadreId;
	}

	/**
	 * @return the activa
	 */
	public String getActiva() {
		return this.activa;
	}

	/**
	 * @param activa
	 *            the activa to set
	 */
	public void setActiva(String activa) {
		this.activa = activa;
	}

	/**
	 * @return the usuultmod
	 */
	public String getUsuultmod() {
		return this.usuultmod;
	}

	/**
	 * @param usuultmod
	 *            the usuultmod to set
	 */
	public void setUsuultmod(String usuultmod) {
		this.usuultmod = usuultmod;
	}

	/**
	 * @return the fecultmod
	 */
	public Date getFecultmod() {
		return this.fecultmod;
	}

	/**
	 * @param fecultmod
	 *            the fecultmod to set
	 */
	public void setFecultmod(Date fecultmod) {
		this.fecultmod = fecultmod;
	}

	/**
	 * @return the y42b01t00s
	 */
	public List<Entidad> getEntidads() {
		return this.entidads;
	}

	/**
	 * @param entidads the y42b01t00s to set
	 */
	public void setEntidads(List<Entidad> entidads) {
		this.entidads = entidads;
	}

}
