package com.ejie.y42b.model;

import java.util.ArrayList;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * * Etiqueta  
 * 
 *  
 */

public class Etiqueta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String etiquetaId;
	private String nombre;
	private List<Entidad> entidads = new ArrayList<Entidad>();
	private List<Contacto> contactos = new ArrayList<Contacto>();

	/**
	 * Method 'Etiqueta'.
	 * 
	 */
	public Etiqueta() {
	}

	/**
	 * Method 'Etiqueta'.
	 * 
	 * @param etiquetaId
	 *            String
	 * @param nombre
	 *            String
	 */
	public Etiqueta(String etiquetaId, String nombre) {
		this.etiquetaId = etiquetaId;
		this.nombre = nombre;
	}

	/**
	 * Method 'Etiqueta'.
	 * 
	 * @param etiquetaId
	 *            String
	 * @param nombre
	 *            String
	 * @param entidad
	 *            List<Y42bEntidad>
	 * @param contacto
	 *            List<Y42bContacto>
	 */
	public Etiqueta(String etiquetaId, String nombre, List<Entidad> entidad,
			List<Contacto> contacto) {

		this.etiquetaId = etiquetaId;
		this.nombre = nombre;
		this.entidads = entidad;
		this.contactos = contacto;
	}

	/**
	 * Method 'getEtiquetaId'.
	 * 
	 * @return String
	 */

	public String getEtiquetaId() {
		return this.etiquetaId;
	}

	/**
	 * Method 'setEtiquetaId'.
	 * 
	 * @param etiquetaId
	 *            String
	 */

	public void setEtiquetaId(String etiquetaId) {
		this.etiquetaId = etiquetaId;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 * 
	 * @param nombre
	 *            String
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getY42b01t00s'.
	 * 
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Entidad> getEntidads() {
		return this.entidads;
	}

	/**
	 * Method 'entidads'.
	 * 
	 * @param entidads
	 *            List
	 */
	public void setEntidads(List<Entidad> entidads) {
		this.entidads = entidads;
	}

	/**
	 * Method 'getY42b02t00s'.
	 * 
	 * 
	 * @return List
	 */
	@JsonIgnore()
	public List<Contacto> getContactos() {
		return this.contactos;
	}

	/**
	 * Method 'contactos'.
	 * 
	 * @param contactos
	 *            List
	 */
	public void setContactos(List<Contacto> contactos) {
		this.contactos = contactos;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ etiquetaId: ").append(this.etiquetaId).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append("}");
		return result.toString();
	}

}
