package com.ejie.y42b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateTimeDeserializer;
import com.ejie.x38.control.JsonDateTimeSerializer;

;

/**
 * EnvioSeguimiento  
 * 
 *  
 * 
 */
public class EnvioSeguimiento implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String envioId;
	private String mailingAsunto;
	private Date fechaOperacion;
	private Long totalEnviosLeidos;
	private Long totalEnviosNoLeidos;
	private Long totalEnvios;
	private Long totalEnviadosOK;
	private Long seleccionadosConEmail;

	private Long totalContactos;
	private Long totalEntidades;
	private Long total;

	/**
	 * 
	 * @param envioId
	 *            String
	 * @param mailingAsunto
	 *            String
	 * @param fechaOperacion
	 *            Date
	 * @param totalEnviosLeidos
	 *            Long
	 * @param totalEnviosNoLeidos
	 *            Long
	 * @param totalEnvios
	 *            Long
	 */
	public EnvioSeguimiento(String envioId, String mailingAsunto,
			Date fechaOperacion, Long totalEnviosLeidos,
			Long totalEnviosNoLeidos, Long totalEnvios, Long totalEnviadosOK,
			Long seleccionadosConEmail, Long totalContactos,
			Long totalEntidades, Long total) {
		super();
		this.envioId = envioId;
		this.mailingAsunto = mailingAsunto;
		this.fechaOperacion = fechaOperacion;
		this.totalEnviosLeidos = totalEnviosLeidos;
		this.totalEnviosNoLeidos = totalEnviosNoLeidos;
		this.totalEnvios = totalEnvios;
		this.totalEnviadosOK = totalEnviadosOK;
		this.seleccionadosConEmail = seleccionadosConEmail;
		this.totalContactos = totalContactos;
		this.totalEntidades = totalEntidades;
		this.total = total;
	}

	/**
	 * @return the envioId
	 */
	public String getEnvioId() {
		return this.envioId;
	}

	/**
	 * @param envioId
	 *            the envioId to set
	 */
	public void setEnvioId(String envioId) {
		this.envioId = envioId;
	}

	/**
	 * @return the mailingAsunto
	 */
	public String getMailingAsunto() {
		return this.mailingAsunto;
	}

	/**
	 * @param mailingAsunto
	 *            the mailingAsunto to set
	 */
	public void setMailingAsunto(String mailingAsunto) {
		this.mailingAsunto = mailingAsunto;
	}

	/**
	 * @return the fechaOperacion
	 */
	@JsonSerialize(using = JsonDateTimeSerializer.class)
	public Date getFechaOperacion() {
		return this.fechaOperacion;
	}

	/**
	 * @param fechaOperacion
	 *            the fechaOperacion to set
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setFechaOperacion(Date fechaOperacion) {
		this.fechaOperacion = fechaOperacion;
	}

	/**
	 * @return the totalEnviosLeidos
	 */
	public Long getTotalEnviosLeidos() {
		return this.totalEnviosLeidos;
	}

	/**
	 * @param totalEnviosLeidos
	 *            the totalEnviosLeidos to set
	 */
	public void setTotalEnviosLeidos(Long totalEnviosLeidos) {
		this.totalEnviosLeidos = totalEnviosLeidos;
	}

	/**
	 * @return the totalEnviosNoLeidos
	 */
	public Long getTotalEnviosNoLeidos() {
		return this.totalEnviosNoLeidos;
	}

	/**
	 * @param totalEnviosNoLeidos
	 *            the totalEnviosNoLeidos to set
	 */
	public void setTotalEnviosNoLeidos(Long totalEnviosNoLeidos) {
		this.totalEnviosNoLeidos = totalEnviosNoLeidos;
	}

	/**
	 * @return the totalEnvios
	 */
	public Long getTotalEnvios() {
		return this.totalEnvios;
	}

	/**
	 * @param totalEnvios
	 *            the totalEnvios to set
	 */
	public void setTotalEnvios(Long totalEnvios) {
		this.totalEnvios = totalEnvios;
	}

	/**
	 * @return the seleccionadosConEmail
	 */
	public Long getSeleccionadosConEmail() {
		return this.seleccionadosConEmail;
	}

	/**
	 * @param seleccionadosConEmail
	 *            the seleccionadosConEmail to set
	 */
	public void setSeleccionadosConEmail(Long seleccionadosConEmail) {
		this.seleccionadosConEmail = seleccionadosConEmail;
	}

	public Long getTotalEnviadosOK() {
		return totalEnviadosOK;
	}

	public void setTotalEnviadosOK(Long totalEnviadosOK) {
		this.totalEnviadosOK = totalEnviadosOK;
	}

	/**
	 * @return the totalContactos
	 */
	public Long getTotalContactos() {
		return totalContactos;
	}

	/**
	 * @param totalContactos
	 *            the totalContactos to set
	 */
	public void setTotalContactos(Long totalContactos) {
		this.totalContactos = totalContactos;
	}

	/**
	 * @return the totalEntidades
	 */
	public Long getTotalEntidades() {
		return totalEntidades;
	}

	/**
	 * @param totalEntidades
	 *            the totalEntidades to set
	 */
	public void setTotalEntidades(Long totalEntidades) {
		this.totalEntidades = totalEntidades;
	}

	/**
	 * @return the total
	 */
	public Long getTotal() {
		return total;
	}

	/**
	 * @param total
	 *            the total to set
	 */
	public void setTotal(Long total) {
		this.total = total;
	}

	/**
	 * @return return
	 */
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ envioId: ").append(this.envioId).append(" ]");
		result.append(", [ mailingAsunto: ").append(this.mailingAsunto)
				.append(" ]");
		result.append(", [ fechaOperacion: ").append(this.fechaOperacion)
				.append(" ]");
		result.append(", [ totalEnviosLeidos: ").append(this.totalEnviosLeidos)
				.append(" ]");
		result.append(", [ totalEnviosNoLeidos: ")
				.append(this.totalEnviosNoLeidos).append(" ]");
		result.append(", [ totalEnvios: ").append(this.totalEnvios)
				.append(" ]");
		result.append(", [ totalEnviadosOK: ").append(this.totalEnviadosOK)
				.append(" ]");
		result.append(", [ seleccionadosConEmail: ")
				.append(this.seleccionadosConEmail).append(" ]");

		result.append(", [ totalContactos: ").append(this.totalContactos)
				.append(" ]");
		result.append(", [ totalEntidades: ").append(this.totalEntidades)
				.append(" ]");
		result.append(", [ total: ").append(this.total).append(" ]");
		result.append("}");
		return result.toString();
	}

}
