package com.ejie.y42b.log;

import java.util.Hashtable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger.Level;

import com.ejie.x38.log.LoggingManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.TableManager;

public class Y42bIncidenceLoggingAdviceImpl implements
	Y42bIncidenceLoggingAdvice {
	private static final Logger logger = LoggerFactory
			.getLogger(Y42bIncidenceLoggingAdviceImpl.class);

	private LoggingManager loggingManager;

	public void logIncidence(Object target, Exception exception) {
		Hashtable<String, String> table = TableManager.initTable();
		table.put(Y42bLogConstants.CRITICALITY, Level.ERROR.toString());
		table.put(Y42bLogConstants.FUNCTIONALSUBSYSTEM,
				Y42bLogConstants.INCIDENCESUBSYSTEM);
		table.put(Y42bLogConstants.ADITIONALINFO,
				StackTraceManager.getStackTrace(exception));
		if (exception.getMessage() != null) {
			table.put(Y42bLogConstants.MESSAGE, exception.getMessage());
		}
		loggingManager
				.logIncidences(target.getClass().getName(), logger, table);
	}

	// Getters & Setters
	public LoggingManager getLoggingManager() {
		return loggingManager;
	}

	public void setLoggingManager(LoggingManager loggingManager) {
		this.loggingManager = loggingManager;
	}
}
