package com.ejie.y42b.junittest;

import javax.sql.DataSource;

import junit.framework.TestCase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.ejie.y42b.dao.ContactoDaoImpl;
import com.ejie.y42b.junittest.support.Y42bSupportContactos;
import com.ejie.y42b.model.Contacto;

/**
 * 
 *  
 *
 */
public class Y42bTestContactos extends TestCase {

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bTestContactos.class);

	private ApplicationContext context = new ClassPathXmlApplicationContext(
			"META-INF/spring/myjunit.xml");
	private BeanFactory factory = this.context;
	private DataSource dataSource = (DataSource) this.factory
			.getBean("dataSourceOracle");


	//private OracleLobHandler oracleLobHandler = (OracleLobHandler) factory
	//	.getBean("oracleLobHandler");
	private ContactoDaoImpl aImpl = (ContactoDaoImpl) this.factory
			.getBean("contactosDAO");

	/**
	 * 
	 */
	public void testContactosNueva() {
	    	Y42bSupportContactos s = new Y42bSupportContactos();
	    	
		Contacto contactos = s.getContactosNuevosDatos();
		this.aImpl.setDataSource(this.dataSource);

		// Borra padre
		// this.aImpl.remove(contactos);

		Y42bTestContactos.logger.debug("Consulta " + contactos.getContactoId()
				+ " eliminada satisfactoriamente");
		Y42bTestContactos.logger.debug("Respuesta asociada eliminada satisfactoriamente");

		// contactos = aImpl.add(contactos);
		this.assertNotNull(contactos);
		Y42bTestContactos.logger.debug("Contacto " + contactos.getContactoId()
				+ " dado de alta satisfactoriamente");

	}

	/**
	 * 
	 */
	public void testContactosSelect() {

		this.aImpl.setDataSource(this.dataSource);
		//Contacto contactos = new Contacto();
		// List<Y42bContacto> list = aImpl.findAll(contactos, null);
		// assertEquals(list.size(), 8);
		Y42bTestContactos.logger.debug("Contactos listadas satisfactoriamente");
		// this.logger.debug("Contactos: " + list.size());
	}

}
