package com.ejie.y42b.jmx.mbeans;

import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;

/**
 * MBean que gestiona el Acceso a los Componentes de Negocio
 * 
 *  
 * 
 */

@ManagedResource(objectName = "spring:name=AccessControlMBean", description = "MBean que gestiona el Acceso a los Componentes de Negocio", persistPolicy = "OnUpdate", persistPeriod = Y42bAgendaConstantes.NUM_200)
public class AccessControlMBean {

	private static String lastDate = "15/09/2011";

	// private static Map<String, Map<String, String>> serviceTable = new
	// HashMap<String, Map<String, String>>();

	/**
	 * @return the lastDate
	 */
	@ManagedAttribute(description = "Fecha Ultimo Uso de AccessControlMBean", defaultValue = "", persistPeriod = Y42bAgendaConstantes.NUM_300)
	public String getLastDate() {
		return AccessControlMBean.lastDate;
	}

	/**
	 * @param lastDate
	 *            the lastDate to set
	 */
	@ManagedOperation(description = "Modifica Fecha Ultimo Uso de AccessControlMBean")
	@ManagedOperationParameters({@ManagedOperationParameter(name = "lastDate", description = "Nueva Fecha") })
	public void setLastDate(String lastDate) {
		AccessControlMBean.lastDate = lastDate;
	}

}
