package com.ejie.y42b.jms;

import javax.jms.Message;
import javax.jms.TextMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.y42b.service.EnvioService;

/**
 * Y42bEnvioMailJMSServiceImpl Clase encargada del tratamiento de los mensajes
 * recibidos en la cola JMS
 * 
 *  
 * 
 */
@Service(value = "y42bEnvioMailJMSService")
public class Y42bEnvioMailJMSServiceImpl implements Y42bEnvioMailJMSService {
	private static final Logger logger = LoggerFactory
			.getLogger(Y42bEnvioMailJMSServiceImpl.class);

	@Autowired
	private EnvioService envioMailService;

	/**
	 * Constructor privado
	 */
	private Y42bEnvioMailJMSServiceImpl() {
		super();
	}

	/**
	 * onMessage
	 * 
	 * @param inMessage
	 *            mensaje de entrada
	 * @throws Throwable
	 *             Throwable
	 */
	public synchronized void onMessage(Message inMessage) throws Throwable {
		Y42bEnvioMailJMSServiceImpl.logger
				.info("Y42bEnvioMailJMSServiceImpl.onMessage - Inicio");
		TextMessage msg = null;
		try {
			if (inMessage instanceof TextMessage) {
				msg = (TextMessage) inMessage;
				Y42bEnvioMailJMSServiceImpl.logger.debug("TEXTMESSAGE beans: "
						+ msg.getText());
				envioMailService.procesoEnviosMail(msg.getText());
			}
		} catch (Throwable e_onMessage) {
			Y42bEnvioMailJMSServiceImpl.logger.error(
					"Y42bEnvioMailJMSServiceImpl.onMessage - Error",
					e_onMessage);
		} finally {
			Y42bEnvioMailJMSServiceImpl.logger
					.info("Y42bEnvioMailJMSServiceImpl.onMessage - Fin");
		}
	}
}
