package com.ejie.y42b.dao.sql;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbEntidades;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbGrupos;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbGruposEntidades;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbLocalizacionDAO;
import com.ejie.y42b.model.Y42bGrupo;

/**
 * 
 *  
 * 
 */
public class Y42bDAOGrupos {

	/**
	 * Constructor privado
	 */
	private Y42bDAOGrupos() {

	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @param consulta
	 *            GruposCT
	 * @return StringBuilder con la SQL construida
	 */

	public static final StringBuilder crearSQLObtenerListaGrupos(
			Y42bGrupo consulta) {
		StringBuilder sqlListaC = new StringBuilder(
				Y42bAgendaConstantes.BUFFER_300);

		sqlListaC.append(" SELECT ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" , ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(" , ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" , ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" , ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.USUULTMOD).append(" , ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.FECULTMOD);
		sqlListaC.append(" FROM ");
		sqlListaC.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sqlListaC.append(" WHERE 1 = 1 ");

		return sqlListaC;
	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @return StringBuilder con la SQL construida
	 */

	public static final StringBuilder crearSQLObtenerEntidadesActivas() {
		StringBuilder sql = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		// SELECT entidad_Id_001,grupo_id_001 from Y42B00S00, Y42B01S00 where
		// y42b01s00.grupo_id_001 = y42b00s00.GRUPO_ID

		sql.append(" SELECT ");
		sql.append(" COUNT( ");
		sql.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.ENTIDAD_ID);
		sql.append(" ) ");
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES);
		sql.append(" , ");
		sql.append(Y42bConstantesTbEntidades.TABLA_ENTIDADES);
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.ENTIDAD_ID);
		sql.append(" = ");
		sql.append(Y42bConstantesTbEntidades.TABLA_ENTIDADES).append(".")
				.append(Y42bConstantesTbEntidades.ENTIDAD_ID);
		sql.append(" AND ");
		sql.append(Y42bConstantesTbEntidades.TABLA_ENTIDADES).append(".")
				.append(Y42bConstantesTbEntidades.ACTIVA).append(" = 'S' ");
		return sql;
	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el numero de entidades
	 * totales por grupo
	 * 
	 * @return StringBuilder con la SQL construida
	 */

	public static final StringBuilder crearSQLObtenerEntidadesTotales() {
		StringBuilder sql = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		// SELECT entidad_Id_001,grupo_id_001 from Y42B00S00, Y42B01S00 where
		// y42b01s00.grupo_id_001 = y42b00s00.GRUPO_ID

		sql.append(" SELECT ");
		sql.append(" COUNT( ");
		sql.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.ENTIDAD_ID);
		sql.append(" ) ");
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES);
		sql.append(" WHERE 1=1 ");

		return sql;
	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @return StringBuilder con la SQL construida
	 */

	public static final StringBuilder crearSQLObtenerPrimerGrupoActivo() {
		StringBuilder sql = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);

		sql.append(" SELECT ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" , ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" , ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.USUULTMOD).append(" , ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.FECULTMOD);
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.ACTIVA).append(" = 'S'");

		return sql;
	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @return StringBuffer con la SQL construida
	 */
	public static final StringBuffer crearSQLObtenerDetalleGrupo() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_200);

		sql.append(" SELECT ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" , ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" , ");
		sql.append(Y42bConstantesTbGrupos.USUULTMOD).append(" , ");
		sql.append(Y42bConstantesTbGrupos.FECULTMOD);
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sql.append(" WHERE 1=1 ");

		return sql;
	}

	/**
	 * Construye un StringBuffer con la SQL para modificar una consulta en
	 * particular
	 * 
	 * @return StringBuffer con la SQL construida
	 */
	public static final StringBuffer crearSQLModificarGrupo() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_200);
		sql.append("UPDATE ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sql.append(" SET ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(" = ?, ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" = ?, ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" = ?, ");
		sql.append(Y42bConstantesTbGrupos.USUULTMOD).append(" = ?, ");
		sql.append(Y42bConstantesTbGrupos.FECULTMOD).append(" = SYSDATE");
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" = ? ");

		return sql;
	}

	/**
	 * 
	 * @return StringBuffer
	 */
	public static final StringBuffer obtenerLocalizacion() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_250);

		sql.append(" SELECT ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_LOCALIZACION_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PAIS_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_PAIS_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DIR_EXTRANJERO_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PROVINCIA_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_PROVINCIA_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_MUNICIPIO_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_MUNICIPIO_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_LOCALIDAD_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_LOCALIDAD_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_CALLE_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_CALLE_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_SECUNDARIA_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_PROVISIONAL_CALLE_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_TIPO_VIA_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_TIPO_VIA_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PORTAL_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_NUM_PORTAL_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_BLOQUE_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_BIS_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_TRANSLATEDBIS_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ACEPCION_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXED50_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYED50_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXETRS89_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYETRS89_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXVGS84_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYVGS84_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_PROVISIONAL_PORTAL_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_POSTAL_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_USUULTMOD_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_FECULTMOD_044).append(
				" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_OBSERVACIONES_044)
				.append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_RESTO_DIRECCION_044);
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbLocalizacionDAO.TABLA_LOCALIZACION);
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_LOCALIZACION_044);
		sql.append(" = ?");

		return sql;
	}
}
