package com.ejie.y42b.dao.sql;

import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbContactos;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbEntidadesContactos;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbLocalizacionDAO;

/**
 * 
 *  
 * 
 */
public class Y42bDAOContactos {

	/**
	 * Constructor privado
	 */
	private Y42bDAOContactos() {

	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @return StringBuffer con la SQL construida
	 */

	public static final StringBuffer crearSQLObtenerListaContactos() {
		StringBuffer sqlListaC = new StringBuffer(Y42bAgendaConstantes.BUFFER_300);

		sqlListaC.append(" SELECT ");
		sqlListaC.append(Y42bConstantesTbEntidadesContactos.TABLA_ENTIDADES_CONTACTOS).append(".").append(Y42bConstantesTbEntidadesContactos.ENTIDAD_ID).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.CONTACTO_ID).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.NOMBRE).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.CARGO).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.EMAIL).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.TELEFONO).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.FAX).append(" , ");
		// sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.CODLOCALIZ).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.USUULTMOD).append(" , ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.FECULTMOD);
		sqlListaC.append(" FROM ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS);
		sqlListaC.append(" , ");
		sqlListaC.append(Y42bConstantesTbEntidadesContactos.TABLA_ENTIDADES_CONTACTOS);
		sqlListaC.append(" WHERE ");
		sqlListaC.append(Y42bConstantesTbEntidadesContactos.TABLA_ENTIDADES_CONTACTOS).append(".").append(Y42bConstantesTbEntidadesContactos.CONTACTO_ID).append(" = ");
		sqlListaC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS).append(".").append(Y42bConstantesTbContactos.CONTACTO_ID);

		return sqlListaC;
	}

	/**
	 * Construye un StringBuffer con la SQL para obtener el detalle de un
	 * registro en concreto con los idiomas correspondientes
	 * 
	 * @return StringBuffer con la SQL construida
	 */
	public static final StringBuffer crearSQLObtenerDetalleContacto() {
		StringBuffer sqlDetalleC = new StringBuffer(Y42bAgendaConstantes.BUFFER_200);

		sqlDetalleC.append(" SELECT ");
		sqlDetalleC.append(Y42bConstantesTbContactos.CONTACTO_ID).append(" , ");
		// sqlDetalleC.append(Y42bConstantesTbContactos.CODLOCALIZ).append(" , ");
		sqlDetalleC.append(Y42bConstantesTbContactos.USUULTMOD).append(" , ");
		sqlDetalleC.append(Y42bConstantesTbContactos.FECULTMOD);
		sqlDetalleC.append(" FROM ");
		sqlDetalleC.append(Y42bConstantesTbContactos.TABLA_CONTACTOS);

		sqlDetalleC.append(" WHERE ");

		sqlDetalleC.append(Y42bConstantesTbContactos.CONTACTO_ID).append(" = ?");

		return sqlDetalleC;
	}

	/**
	 * Construye un StringBuffer con la SQL para modificar una consulta en
	 * particular
	 * 
	 * @return StringBuffer con la SQL construida
	 */
	public static final StringBuffer crearSQLModificarContacto() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_200);
		sql.append("UPDATE ");
		sql.append(Y42bConstantesTbContactos.TABLA_CONTACTOS);
		sql.append(" SET ");
		// sql.append(Y42bConstantesTbContactos.CODLOCALIZ).append(" = ?, ");
		sql.append(Y42bConstantesTbContactos.USUULTMOD).append(" = ?, ");
		sql.append(Y42bConstantesTbContactos.FECULTMOD).append(" = SYSDATE");
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbContactos.CONTACTO_ID).append(" = ? ");

		return sql;
	}

	/**
	 * 
	 * @return StringBuffer
	 */
	public static final StringBuffer altaSQLNuevaContacto() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_300);

		sql.append("INSERT INTO ");
		sql.append(Y42bConstantesTbContactos.TABLA_CONTACTOS);
		sql.append(" ( ");
		// sql.append(Y42bConstantesTbContactos.CODLOCALIZ).append(" , ");
		sql.append(Y42bConstantesTbContactos.USUULTMOD).append(" , ");
		sql.append(Y42bConstantesTbContactos.FECULTMOD).append(")");

		sql.append(" VALUES (?, ?, SYSDATE)");

		return sql;
	}

	/**
	 * 
	 * @return StringBuffer
	 */
	public static final StringBuffer obtenerLocalizacion() {
		StringBuffer sql = new StringBuffer(Y42bAgendaConstantes.BUFFER_250);

		sql.append(" SELECT ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_LOCALIZACION_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PAIS_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_PAIS_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DIR_EXTRANJERO_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PROVINCIA_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_PROVINCIA_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_MUNICIPIO_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_MUNICIPIO_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_LOCALIDAD_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_LOCALIDAD_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_CALLE_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_CALLE_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DESC_SECUNDARIA_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_PROVISIONAL_CALLE_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_TIPO_VIA_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_TIPO_VIA_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_PORTAL_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_NUM_PORTAL_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_BLOQUE_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_BIS_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_TRANSLATEDBIS_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ACEPCION_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXED50_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYED50_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXETRS89_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYETRS89_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DXVGS84_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_DYVGS84_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_PROVISIONAL_PORTAL_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_COD_POSTAL_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_USUULTMOD_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_FECULTMOD_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_OBSERVACIONES_044).append(" , ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_RESTO_DIRECCION_044);
		sql.append(" FROM ");
		sql.append(Y42bConstantesTbLocalizacionDAO.TABLA_LOCALIZACION);
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbLocalizacionDAO.NAME_ID_LOCALIZACION_044);
		sql.append(" = ?");

		return sql;
	}
}
