package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbEntidades;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbGrupos;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbGruposEntidades;
import com.ejie.y42b.dao.sql.Y42bDAOGrupos;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Y42bGrupo;
import com.ejie.y42b.utils.Y42bUtils;

/**
 * * GruposDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class Y42bGruposDaoImpl implements Y42bGruposDao {
	private SimpleJdbcTemplate jdbcTemplate;
	// private JdbcTemplate myjdbcTemplate;
	private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	// private DataSource _dt;

	private static final Logger logger = LoggerFactory
			.getLogger(Y42bGruposDaoImpl.class);

	private RowMapper<Y42bGrupo> rwMap = new RowMapper<Y42bGrupo>() {

		public Y42bGrupo mapRow(ResultSet rs, int rowNum) throws SQLException {

			Y42bGrupo c = new Y42bGrupo();

			c.setGrupoId(rs.getString(Y42bConstantesTbGrupos.GRUPO_ID));
			c.setNombreEs(rs.getString(Y42bConstantesTbGrupos.NOMBRE_ES));
			c.setNombreEu(rs.getString(Y42bConstantesTbGrupos.NOMBRE_EU));
			c.setPadreId(rs.getString(Y42bConstantesTbGrupos.GRUPO_PADRE_ID));
			c.setFecultmod(rs.getDate(Y42bConstantesTbGrupos.FECULTMOD));
			c.setUsuultmod(rs.getString(Y42bConstantesTbGrupos.USUULTMOD));

			return c;

		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		// this._dt = dataSource;
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
		// this.myjdbcTemplate = new JdbcTemplate(dataSource);
		this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(
				dataSource);
	}

	/**
	 * Metodo para añadir un nuevo grupo
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return grupo
	 */
	public Y42bGrupo add(Y42bGrupo grupo) {

		StringBuilder sql = new StringBuilder(Y42bAgendaConstantes.BUFFER_100);
		sql.append("INSERT INTO ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sql.append(" ( ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.NIVEL).append(" , ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(" , ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" , ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" , ");
		sql.append(Y42bConstantesTbGrupos.ACTIVA).append(" , ");
		sql.append(Y42bConstantesTbGrupos.USUULTMOD).append(" , ");
		sql.append(Y42bConstantesTbGrupos.FECULTMOD).append(" ) ");

		sql.append(" VALUES ");
		sql.append(" ( ");
		sql.append(" :grupoId, ");
		sql.append(" :nivel, ");
		sql.append(" :padreId, ");
		sql.append(" :nombreEs, ");
		sql.append(" :nombreEu, ");
		sql.append(" 'S', ");
		sql.append(" :usuultmod, ");
		sql.append(" SYSDATE");
		sql.append(" ) ");

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		this.namedParameterJdbcTemplate.update(sql.toString(), namedParameters);

		return grupo;
	}

	/**
	 * Updates a single row in the Grupos table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * 
	 * @return Grupos
	 */
	public Y42bGrupo update(Y42bGrupo grupo) {

		StringBuilder sql = new StringBuilder(Y42bAgendaConstantes.BUFFER_100);
		sql.append("UPDATE ");
		sql.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		sql.append(" SET ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID).append(
				" = :padreId, ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_ES).append(" = :nombreEs, ");
		sql.append(Y42bConstantesTbGrupos.NOMBRE_EU).append(" = :nombreEu, ");
		sql.append(Y42bConstantesTbGrupos.USUULTMOD).append(" = :usuultmod, ");
		sql.append(Y42bConstantesTbGrupos.FECULTMOD).append(" = SYSDATE");
		sql.append(" WHERE ");
		sql.append(Y42bConstantesTbGrupos.GRUPO_ID).append(" = :grupoId ");

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		this.namedParameterJdbcTemplate.update(sql.toString(), namedParameters);

		return grupo;

	}

	/**
	 * Finds a single row in the Grupos table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Grupo
	 */
	@Transactional(readOnly = true)
	public Y42bGrupo find(Y42bGrupo grupo) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);

		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerListaGrupos(grupo);

		if (grupo != null && !"".equals(grupo.getGrupoId())) {
			where.append(" AND ");
			where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_ID);
			where.append(" = :grupoId");
		}

		query.append(where);

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		return (Y42bGrupo) this.namedParameterJdbcTemplate.queryForObject(
				query.toString(), namedParameters, this.rwMap);

	}

	/**
	 * Removes a single row in the Grupos table (logica -> ACTIVA='N')
	 * 
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * 
	 */
	public void remove(Y42bGrupo grupo) {
		StringBuilder query = new StringBuilder(Y42bAgendaConstantes.BUFFER_50);
		query.append(" UPDATE ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS);
		query.append(" SET ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.ACTIVA);
		query.append(" = 'N' ");
		query.append(" , ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.USUULTMOD);
		query.append(" = :usuultmod");
		query.append(" , ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.FECULTMOD);
		query.append(" = SYSDATE");
		query.append(" WHERE ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID);
		query.append(" = :grupoId");

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		this.namedParameterJdbcTemplate.update(query.toString(),
				namedParameters);

	}

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<Y42bGrupo> findAll(Y42bGrupo grupo, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerListaGrupos(grupo);
		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);
		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND ");
			where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_ID);
			where.append(" = :grupoId");
		}

		/**
		 * Busca padres raiz
		 */

		if (grupo != null && grupo.getPadreId() == null) {
			where.append(" AND (");
			where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID);
			where.append(" IS NULL");
			where.append(" OR ");
			where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID);
			where.append(" = '0')");
		}
		where.append(" AND ");
		where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.ACTIVA).append(" = 'S' ");

		where.append(" AND ");
		where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID);
		where.append(" <> '" + Y42bAgendaConstantes.GRUPO_RAIZ_ID + "'");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		Y42bGruposDaoImpl.logger.debug("*****************************");
		Y42bGruposDaoImpl.logger.debug("Query: " + query.toString());
		Y42bGruposDaoImpl.logger.debug("*****************************");

		return (List<Y42bGrupo>) this.namedParameterJdbcTemplate.query(
				query.toString(), namedParameters, this.rwMap);

	}

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Grupos
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Y42bGrupo> findGruposPadreAll(Y42bGrupo grupo) {
		// StringBuilder where = new
		// StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerListaGrupos(grupo);

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		/**
		 * Busca padres raiz
		 */

		query.append(" AND ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.ACTIVA).append(" = 'S' ");

		query.append(" AND ");
		if (grupo != null && grupo.getGrupoId() != null) {
			query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_ID);
			query.append(" <> :grupoId");
		}
		// query.append(" AND ");
		// if (grupo != null && grupo.getGrupoId() != null) {
		// query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
		// .append(Y42bConstantesTbGrupos.GRUPO_ID);
		// query.append(" in ('G_00','G_0001') ");
		// }
		query.append(" AND ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID);
		query.append(" <> '" + Y42bAgendaConstantes.GRUPO_RAIZ_ID + "'");

		query.append(" ORDER BY  NOMBRE_ES, NOMBRE_EU ");

		return (List<Y42bGrupo>) this.namedParameterJdbcTemplate.query(
				query.toString(), namedParameters, this.rwMap);

	}

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<Y42bGrupo> findAllChildren(Y42bGrupo grupo,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerListaGrupos(grupo);
		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		/**
		 * Busca hijos
		 */

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND ");
			where.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.GRUPO_PADRE_ID);
			where.append(" = :grupoId");

		}

		if (grupo != null && grupo.getActiva() != null) {
			query.append(" AND ");
			query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
					.append(Y42bConstantesTbGrupos.ACTIVA).append(" = 'S' ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Y42bGrupo>) this.namedParameterJdbcTemplate.query(
				query.toString(), namedParameters, this.rwMap);

	}

	/**
	 * Counts rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Y42bGrupo grupo) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  GRUPO t1  ");
		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the Grupos table using like.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Y42bGrupo> findAllLike(Y42bGrupo grupo, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_300);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.GRUPO_ID GRUPOID,t1.NIVEL NIVEL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.GRUPO_PADRE_ID GRUPOPADREID,t1.ACTIVA ACTIVA,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD "
						+ "FROM GRUPO t1 ");

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND UPPER(t1.GRUPO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getGrupoId().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getGrupoId().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO_ID IS NOT NULL");
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNivel() + "%");
			} else {
				params.add("%" + grupo.getNivel() + "%");
			}
			where.append(" AND t1.NIVEL IS NOT NULL");
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND UPPER(t1.GRUPO_PADRE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getGrupoPadreId().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getGrupoPadreId().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO_PADRE_ID IS NOT NULL");
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getFecultmod() + "%");
			} else {
				params.add("%" + grupo.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Y42bGrupo>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds Numero de entidades activas
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public int findEntidadesActivas(Y42bGrupo grupo) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerEntidadesActivas();
		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		/**
		 * Busca hijos y entidades activas
		 */
		/**
		 * Hierarchical query
		 */
		// SELECT grupo_id_000,NOMBRE_ES, LEVEL,
		// SYS_CONNECT_BY_PATH(grupo_id_000, '/') "Path" from Y42B00S00
		// START WITH grupo_id_000 = '01'
		// CONNECT BY NOCYCLE PRIOR grupo_id_000 = GRUPO_PADRE_ID;

		where.append(" AND ");
		where.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.GRUPO_ID);
		where.append(" = :grupoId");

		where.append(" AND ");
		where.append(Y42bConstantesTbEntidades.TABLA_ENTIDADES).append(".")
				.append(Y42bConstantesTbEntidades.ACTIVA);
		where.append(" = 'S'");

		query.append(where);

		return this.namedParameterJdbcTemplate.queryForInt(query.toString(),
				namedParameters);

	}

	/**
	 * Finds Numero de entidades activas
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public int findEntidades(Y42bGrupo grupo) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerEntidadesActivas();
		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		where.append(" AND ");
		where.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.GRUPO_ID);
		where.append(" = :grupoId");

		query.append(where);

		return this.namedParameterJdbcTemplate.queryForInt(query.toString(),
				namedParameters);

	}

	/**
	 * Finds Numero total de entidades por grupo
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public int findEntidadesTotales(Y42bGrupo grupo) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.BUFFER_300);
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerEntidadesTotales();
		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		where.append(" AND ");
		where.append(Y42bConstantesTbGruposEntidades.TABLA_GRUPOS_ENTIDADES)
				.append(".").append(Y42bConstantesTbGruposEntidades.GRUPO_ID);
		where.append(" = :grupoId");

		query.append(where);

		return this.namedParameterJdbcTemplate.queryForInt(query.toString(),
				namedParameters);

	}

	/**
	 * Counts rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findGruposActivos(Y42bGrupo grupo) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  GRUPO t1  ");

		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(grupo.getActiva());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds primer grupo activo para seleccionar por defecto
	 * 
	 * @return String
	 */
	public Y42bGrupo findPrimerGrupoActivo() {
		StringBuilder query = Y42bDAOGrupos.crearSQLObtenerPrimerGrupoActivo();

		query.append(" AND ");
		query.append(Y42bConstantesTbGrupos.TABLA_GRUPOS).append(".")
				.append(Y42bConstantesTbGrupos.GRUPO_ID);
		query.append(" = :grupoId");

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				null);

		return (Y42bGrupo) this.namedParameterJdbcTemplate.queryForObject(
				query.toString(), namedParameters, this.rwMap);

	}

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	public Y42bGrupo addGrupoEntidad(Y42bGrupo grupo) {
		String query = "INSERT INTO Y42B03T00 " + "( GRUPO_ID,ENTIDAD_ID) "
				+ " values (?, ?)";

		List<Entidad> auxiliarEntidad = grupo.getEntidads();
		Iterator<Entidad> it = auxiliarEntidad.iterator();
		while (it.hasNext()) {
			Entidad entidad = (Entidad) it.next();
			this.jdbcTemplate.update(query, grupo.getGrupoId(),
					entidad.getEntidadId());
		}
		return grupo;
	}

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	public void removeGrupoEntidad(Y42bGrupo grupo) {
		String query = "DELETE  FROM Y42B03T00 "
				+ " WHERE GRUPO_ID=? AND ENTIDAD_ID=?";
		List<Entidad> auxiliarEntidad = grupo.getEntidads();
		Iterator<Entidad> it = auxiliarEntidad.iterator();
		while (it.hasNext()) {
			Entidad entidad = (Entidad) it.next();
			this.jdbcTemplate.update(query, grupo.getGrupoId(),
					entidad.getEntidadId());
		}
	}

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	@Transactional(readOnly = true)
	public Y42bGrupo findGrupoEntidad(Y42bGrupo grupo, Entidad entidad,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.GRUPO_ID=?");

		params.add(grupo.getGrupoId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Entidad_id entidadId, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.ACTIVA ACTIVA, t2.ISKONTSUMOGEST ISKONTSUMOGEST, "
						+ "t2.ISKONTSUMONET ISKONTSUMONET, t2.ISOFERTAFORM ISOFERTAFORM, t2.ISCONSULTASWEB ISCONSULTASWEB, t2.COD_ORG CODORG, "
						+ "t2.ISNACIONAL ISNACIONAL, t2.OBSERVACIONES OBSERVACIONES, t2.TELEFONO TELEFONO, t2.FAX FAX, t2.EMAIL EMAIL, t2.URL URL, "
						+ "t2.USUARIO USUARIO, t2.PASSWORD PASSWORD, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD, t2.nora_Pais_Id NORAPAISID, "
						+ "t2.nombre_Pais NOMBREPAIS, t2.nora_Provincia_Id NORAPROVINCIAID, t2.nombre_Provincia NOMBREPROVINCIA, t2.nora_Municipio_Id NORAMUNICIPIOID, "
						+ "t2.nombre_Municipio NOMBREMUNICIPIO, t2.nora_Localidad_Id NORALOCALIDADID, t2.nombre_Localidad NOMBRELOCALIDAD, "
						+ "t2.nora_Calle_Id NORACALLEID, t2.nombre_Calle NOMBRECALLE, t2.nora_Cp_Id NORACPID, t2.nombre_Cp NOMBRECP, "
						+ "t2.nora_Portal_Id NORAPORTALID, t2.nombre_Portal NOMBREPORTAL, t2.comple_Direc COMPLE_DIREC "
						+ "FROM Y42b03t00 t1,Y42B01T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Entidad> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Entidad>() {
					public Entidad mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Entidad(resultSet.getString("ENTIDADID"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("ACTIVA"), resultSet
										.getString("ISKONTSUMOGEST"), resultSet
										.getString("ISKONTSUMONET"), resultSet
										.getString("ISOFERTAFORM"), resultSet
										.getString("ISCONSULTASWEB"), resultSet
										.getString("ISNACIONAL"), resultSet
										.getString("OBSERVACIONES"), resultSet
										.getString("TELEFONO"), resultSet
										.getString("FAX"), resultSet
										.getString("EMAIL"), resultSet
										.getString("URL"), resultSet
										.getString("USUARIO"), resultSet
										.getString("PASSWORD"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), resultSet
										.getString("NORAPAISID"), resultSet
										.getString("NOMBREPAIS"), resultSet
										.getString("NORAPROVINCIAID"),
								resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"),
								resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"),
								resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet
										.getString("NOMBRECALLE"), resultSet
										.getString("NORACPID"), resultSet
										.getString("NOMBRECP"), resultSet
										.getString("NORAPORTALID"), resultSet
										.getString("NOMBREPORTAL"), resultSet
										.getString("CODORG"), resultSet
										.getString("COMPLE_DIREC"), null, null,
								null);
					}
				}, params.toArray());
		grupo.setEntidads(listaHijo);
		return grupo;
	}

	/**
	 * Counts rows in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findGrupoEntidadCount(Y42bGrupo grupo, Entidad entidad) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.GRUPO_ID=?");

		params.add(grupo.getGrupoId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b03t00 t1,Y42B01T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Override()
	public Y42bGrupo findJerarquia(Y42bGrupo grupo) {

		List<Y42bGrupo> gList = new ArrayList<Y42bGrupo>();
		// List params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(Y42bAgendaConstantes.BUFFER_200);
		query.append(" SELECT grupo_id, NOMBRE_ES, NOMBRE_EU, LEVEL, ");
		query.append(" SYS_CONNECT_BY_PATH(nombre_es, ' >> ') AS \"PathEs\", ");
		query.append(" SYS_CONNECT_BY_PATH(nombre_eu, ' >> ') AS \"PathEu\" ");
		query.append(" FROM GRUPO ");
		query.append(" START WITH grupo_id = :grupoId ");
		query.append(" CONNECT BY NOCYCLE PRIOR grupo_id = GRUPO_PADRE_ID");
		query.append(" ORDER BY LEVEL DESC");

		// System.out.println("query: " + query.toString());
		// prueba(query.toString());

		SqlParameterSource namedParameters = new BeanPropertySqlParameterSource(
				grupo);

		gList = this.namedParameterJdbcTemplate.query(query.toString(),
				namedParameters, rwHMap);

		/*
		 * gList=this.myjdbcTemplate.query(query.toString(), new
		 * RowMapper<Y42bGrupo>() { public Y42bGrupo mapRow(ResultSet resultSet,
		 * int rowNum) throws SQLException { String pathEs=""; String pathEu="";
		 * Y42bGrupo gr = new Y42bGrupo();
		 * 
		 * pathEs = Y42bUtils.normalizarVacio(resultSet.getString(5)); pathEu =
		 * Y42bUtils.normalizarVacio(resultSet.getString(6));
		 * 
		 * if (pathEs.startsWith(" >> ")){ pathEs =
		 * pathEs.substring(Y42bAgendaConstantes.NUM_3); } if
		 * (pathEu.startsWith(" >> ")){ pathEu =
		 * pathEu.substring(Y42bAgendaConstantes.NUM_3); }
		 * gr.setNombreEs(pathEs); gr.setNombreEu(pathEu); return gr; } },
		 * params); //
		 */

		Y42bGrupo g = null;
		if (gList.size() > 0) {
			g = gList.get(0);
		}

		return g;
	}

	/*
	 * private void prueba(String sql){
	 * 
	 * Connection cn=null; Statement st; ResultSet r;
	 * 
	 * try { cn = _dt.getConnection(); st=cn.createStatement();
	 * r=st.executeQuery(sql); if (r.next()){ logger.debug("*****************");
	 * logger.debug("1: " + r.getString(1)); logger.debug("2: " +
	 * r.getString(2)); logger.debug("3: " + r.getString(3)); logger.debug("4: "
	 * + r.getString(4)); logger.debug("5: " + r.getString(5));
	 * logger.debug("6: " + r.getString(6)); logger.debug("*****************");
	 * }else{ logger.debug("**KKKKKKKKKKKKKK*"); }
	 * 
	 * r.close(); st.close();
	 * 
	 * 
	 * } catch (SQLException e) { // TODO Auto-generated catch block
	 * e.printStackTrace(); }finally{ try { cn.close(); } catch (SQLException e)
	 * { // TODO Auto-generated catch block e.printStackTrace(); } }
	 * 
	 * }
	 */
	private RowMapper<Y42bGrupo> rwHMap = new RowMapper<Y42bGrupo>() {

		public Y42bGrupo mapRow(ResultSet rs, int rowNum) throws SQLException {

			String pathEs = "";
			String pathEu = "";
			Y42bGrupo gr = new Y42bGrupo();

			pathEs = Y42bUtils.normalizarVacio(rs.getString("PathEs"));
			pathEu = Y42bUtils.normalizarVacio(rs.getString("PathEu"));

			gr.setNombreEs(pathEs);
			gr.setNombreEu(pathEu);

			return gr;

		}
	};

	/**
	 * Finds a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Y42bGrupo
	 */
	@Transactional(readOnly = true)
	public Y42bGrupo findGrupo(Y42bGrupo grupo) {
		String query = "SELECT GRUPO_ID, NOMBRE_ES, NOMBRE_EU, GRUPO_PADRE_ID, FECULTMOD, USUULTMOD "
				+ "FROM GRUPO  " + "WHERE GRUPO_ID = ?  ";
		return (Y42bGrupo) this.jdbcTemplate.queryForObject(query, rwMap,
				grupo.getGrupoId());
	}

	/**
	 * Counts rows in the GrupoEntidad table with that entityId.
	 * 
	 * @param entidadId
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countByEntidadId(String entidadId) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ENTIDAD_ID=?");

		params.add(entidadId);

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b03t00 t1 ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the GrupoEntidad table with that entityId.
	 * 
	 * @param grupoId
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countByGrupoId(String grupoId) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.GRUPO_ID=?");

		params.add(grupoId);

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b03t00 t1 ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the GrupoEntidad table with that entityId and groupID.
	 * 
	 * @param grupoId
	 *            String
	 * @param entidadId
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countByGrupoEntidadIds(String grupoId, String entidadId) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.GRUPO_ID=?");
		where.append("and t1.ENTIDAD_ID=?");

		params.add(grupoId);
		params.add(entidadId);

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b03t00 t1 ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	// /**
	// * Finds id of entities belonging to that groupId
	// *
	// * @param grupoId
	// * String
	// * @return String
	// */
	// @Transactional(readOnly = true)
	// public String findEntitiesIdByGrupoId(String grupoId) {
	// String query = "SELECT ENTIDAD_ID "
	// + "FROM Y42b03t00  "
	// + "WHERE GRUPO_ID = ?  ";
	// return (Y42bGrupo) this.jdbcTemplate.queryForObject(query, rwMap,
	// grupo.getGrupoId());
	// }

}
