package com.ejie.y42b.dao;

/**
 * Grupos  
 */

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Y42bGrupo;

/**
 * GruposDao  
 * 
 *  
 */
public interface Y42bGruposDao {
	/**
	 * Inserts a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo add(Y42bGrupo grupos);

	/**
	 * Updates a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo update(Y42bGrupo grupos);

	/**
	 * Finds a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return Grupos
	 */
	Y42bGrupo find(Y42bGrupo grupos);

	/**
	 * Deletes a single row in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * 
	 */
	void remove(Y42bGrupo grupos);

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Y42bGrupo> findAll(Y42bGrupo grupos, Pagination pagination);

	/**
	 * Finds a List of rows in the Grupos table.Padres
	 * 
	 * @param grupos Grupos
	 * @return List
	 */
	List<Y42bGrupo> findGruposPadreAll(Y42bGrupo grupos);

	 /**
     * Finds a List of rows in the Grupos table.
     * 
     * @param grupo
     *            Grupos
   	 * @param pagination Pagination            
     * @return List
     */
    List<Y42bGrupo> findAllChildren(Y42bGrupo grupo, Pagination pagination);

	/**
	 * Counts rows in the Grupos table.
	 * 
	 * @param grupos
	 *            Grupos
	 * @return List
	 */
	Long findAllCount(Y42bGrupo grupos);

	/**
	 * Finds rows in the Grupos table using like.
	 * 
	 * @param grupos Grupos
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	List<Y42bGrupo> findAllLike(Y42bGrupo grupos, Pagination pagination, Boolean startsWith);

	/**
	 * Finds Numero de entidades activas
	 * 
	 * @param grupos
	 *            Grupos
	 * @return int
	 */
	int findEntidadesActivas(Y42bGrupo grupos);

	 /**
     * Counts rows in the Grupos table.
     * 
     * @param grupo Y42bGrupo
     * @return Long
     */
    Long findGruposActivos(Y42bGrupo grupo);
    
	/**
     * Finds Numero de entidades activas
     * 
     * @param grupo
     *            Y42bGrupo
     * @return Long
     */
    int findEntidades(Y42bGrupo grupo);
    
    /**
     * Finds Numero total de entidades por grupo
     * 
     * @param grupo
     *            Y42bGrupo
     * @return Long
     */
    @Transactional(readOnly = true)
    public int findEntidadesTotales(Y42bGrupo grupo);
    
	/**
	 * Finds primer grupo activo para seleccionar por defecto
	 * 
	 * @return Y42bGrupo
	 */
	Y42bGrupo findPrimerGrupoActivo();

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Y42bGrupo addGrupoEntidad(Y42bGrupo grupo);

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	void removeGrupoEntidad(Y42bGrupo grupo);

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	Y42bGrupo findGrupoEntidad(Y42bGrupo grupo, Entidad entidad, Pagination pagination);

	/**
	 * Counts rows rows in the GrupoEntidad table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findGrupoEntidadCount(Y42bGrupo grupo, Entidad entidad);
	
	/**
	 * 
	 * @param grupo Y42bGrupo
	 * @return Y42bGrupo
	 */
	Y42bGrupo findJerarquia(Y42bGrupo grupo);
	
	/**
	 * Buscar grupo por su id
	 *
	 * @param grupo Y42Grupo
	 * @return y42bGrupo
	 */
    Y42bGrupo findGrupo(Y42bGrupo grupo);

    
	/**
	 * Counts rows in the GrupoEntidad table with that entityId.
	 *
	 * @param entidadId String
	 * @return Long
	 */
    Long countByEntidadId(String entidadId);

	/**
	 * Counts rows in the GrupoEntidad table with that grupoID.
	 *
	 * @param grupoId String
	 * @return Long
	 */
    Long countByGrupoId(String grupoId);

	/**
	 * Counts rows in the GrupoEntidad table with that entityId.
	 * 
	 * @param grupoId String
	 * @param entidadId String
	 * @return Long
	 */
    Long countByGrupoEntidadIds(String grupoId, String entidadId);

    
}
