package com.ejie.y42b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.TipoOrganismo;

/**
 * * TipoOrganismoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoOrganismoDaoImpl implements TipoOrganismoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<TipoOrganismo> rwMap = new RowMapper<TipoOrganismo>() {
		public TipoOrganismo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipoOrganismo(resultSet.getString("TORCODIGO"),
					resultSet.getString("TORNOMBRE"),
					resultSet.getString("TORNOMBREE"),
					resultSet.getString("TORNOMBREI"),
					resultSet.getString("TORNOMBREF"),
					resultSet.getString("TORNOMBREA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            Pagination
	 * @return TipoOrganismo
	 */
	public TipoOrganismo add(TipoOrganismo tipoorganismo) {

		String query = "INSERT INTO TIPO_ORGANISMO( TORCODIGO,TORNOMBRE,TORNOMBREE,TORNOMBREI,TORNOMBREF,TORNOMBREA)"
				+ "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, tipoorganismo.getTorcodigo(),
				tipoorganismo.getTornombre(), tipoorganismo.getTornombree(),
				tipoorganismo.getTornombrei(), tipoorganismo.getTornombref(),
				tipoorganismo.getTornombrea());
		return tipoorganismo;
	}

	/**
	 * Updates a single row in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            Pagination
	 * @return TipoOrganismo
	 */
	public TipoOrganismo update(TipoOrganismo tipoorganismo) {
		String query = "UPDATE TIPO_ORGANISMO SET TORNOMBRE=?,TORNOMBREE=?,TORNOMBREI=?,TORNOMBREF=?,TORNOMBREA=? WHERE TORCODIGO=?";
		this.jdbcTemplate.update(query, tipoorganismo.getTornombre(),
				tipoorganismo.getTornombree(), tipoorganismo.getTornombrei(),
				tipoorganismo.getTornombref(), tipoorganismo.getTornombrea(),
				tipoorganismo.getTorcodigo());
		return tipoorganismo;
	}

	/**
	 * Finds a single row in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            Pagination
	 * @return TipoOrganismo
	 */
	@Transactional(readOnly = true)
	public TipoOrganismo find(TipoOrganismo tipoorganismo) {
		String query = "SELECT t1.TORCODIGO TORCODIGO, t1.TORNOMBRE TORNOMBRE, t1.TORNOMBREE TORNOMBREE, t1.TORNOMBREI TORNOMBREI, t1.TORNOMBREF TORNOMBREF, t1.TORNOMBREA TORNOMBREA "
				+ "FROM TIPO_ORGANISMO t1  " + "WHERE t1.TORCODIGO = ?    ";
		return (TipoOrganismo) this.jdbcTemplate.queryForObject(query, rwMap,
				tipoorganismo.getTorcodigo());
	}

	/**
	 * Removes a single row in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            Pagination
	 * @return
	 */
	public void remove(TipoOrganismo tipoorganismo) {
		String query = "DELETE  FROM TIPO_ORGANISMO WHERE TORCODIGO=?";
		this.jdbcTemplate.update(query, tipoorganismo.getTorcodigo());
	}

	/**
	 * Finds a List of rows in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            TipoOrganismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoOrganismo> findAll(TipoOrganismo tipoorganismo,
			Pagination pagination) {
		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TORCODIGO TORCODIGO,t1.TORNOMBRE TORNOMBRE,t1.TORNOMBREE TORNOMBREE,t1.TORNOMBREI TORNOMBREI,t1.TORNOMBREF TORNOMBREF,t1.TORNOMBREA TORNOMBREA "
						+ "FROM TIPO_ORGANISMO t1 ");

		if (tipoorganismo != null && tipoorganismo.getTorcodigo() != null) {
			where.append(" AND t1.TORCODIGO = ?");
			params.add(tipoorganismo.getTorcodigo());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombre() != null) {
			where.append(" AND t1.TORNOMBRE = ?");
			params.add(tipoorganismo.getTornombre());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombree() != null) {
			where.append(" AND t1.TORNOMBREE = ?");
			params.add(tipoorganismo.getTornombree());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrei() != null) {
			where.append(" AND t1.TORNOMBREI = ?");
			params.add(tipoorganismo.getTornombrei());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombref() != null) {
			where.append(" AND t1.TORNOMBREF = ?");
			params.add(tipoorganismo.getTornombref());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrea() != null) {
			where.append(" AND t1.TORNOMBREA = ?");
			params.add(tipoorganismo.getTornombrea());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<TipoOrganismo>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipoOrganismo table.
	 * 
	 * @param tipoorganismo
	 *            TipoOrganismo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoOrganismo tipoorganismo) {

		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  TIPO_ORGANISMO t1  ");
		if (tipoorganismo != null && tipoorganismo.getTorcodigo() != null) {
			where.append(" AND t1.TORCODIGO = ?");
			params.add(tipoorganismo.getTorcodigo());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombre() != null) {
			where.append(" AND t1.TORNOMBRE = ?");
			params.add(tipoorganismo.getTornombre());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombree() != null) {
			where.append(" AND t1.TORNOMBREE = ?");
			params.add(tipoorganismo.getTornombree());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrei() != null) {
			where.append(" AND t1.TORNOMBREI = ?");
			params.add(tipoorganismo.getTornombrei());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombref() != null) {
			where.append(" AND t1.TORNOMBREF = ?");
			params.add(tipoorganismo.getTornombref());
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrea() != null) {
			where.append(" AND t1.TORNOMBREA = ?");
			params.add(tipoorganismo.getTornombrea());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the TipoOrganismo table using like.
	 * 
	 * @param tipoorganismo
	 *            TipoOrganismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipoOrganismo> findAllLike(TipoOrganismo tipoorganismo,
			Pagination pagination, Boolean startsWith) {
		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TORCODIGO TORCODIGO,t1.TORNOMBRE TORNOMBRE,t1.TORNOMBREE TORNOMBREE,t1.TORNOMBREI TORNOMBREI,t1.TORNOMBREF TORNOMBREF,t1.TORNOMBREA TORNOMBREA "
						+ "FROM TIPO_ORGANISMO t1 ");

		if (tipoorganismo != null && tipoorganismo.getTorcodigo() != null) {
			where.append(" AND UPPER(t1.TORCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTorcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTorcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORCODIGO IS NOT NULL");
		}
		if (tipoorganismo != null && tipoorganismo.getTornombre() != null) {
			where.append(" AND UPPER(t1.TORNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTornombre().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTornombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORNOMBRE IS NOT NULL");
		}
		if (tipoorganismo != null && tipoorganismo.getTornombree() != null) {
			where.append(" AND UPPER(t1.TORNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTornombree().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTornombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORNOMBREE IS NOT NULL");
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrei() != null) {
			where.append(" AND UPPER(t1.TORNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTornombrei().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTornombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORNOMBREI IS NOT NULL");
		}
		if (tipoorganismo != null && tipoorganismo.getTornombref() != null) {
			where.append(" AND UPPER(t1.TORNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTornombref().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTornombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORNOMBREF IS NOT NULL");
		}
		if (tipoorganismo != null && tipoorganismo.getTornombrea() != null) {
			where.append(" AND UPPER(t1.TORNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoorganismo.getTornombrea().toUpperCase() + "%");
			} else {
				params.add("%" + tipoorganismo.getTornombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TORNOMBREA IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<TipoOrganismo>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
