package com.ejie.y42b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y42b.model.TipoOrganismo;

/**
 *  * TipoOrganismoDao  
 *  
 */

public interface TipoOrganismoDao {
    
    /**
     * Inserts a single row in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @return TipoOrganismo
     */
    TipoOrganismo add(TipoOrganismo tipoorganismo);

    /**
     * Updates a single row in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @return TipoOrganismo
     */
    TipoOrganismo update(TipoOrganismo tipoorganismo);

    /**
     * Finds a single row in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @return TipoOrganismo
     */
    TipoOrganismo find(TipoOrganismo tipoorganismo);

    /**
     * Deletes a single row in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @return 
     */
    void remove(TipoOrganismo tipoorganismo);

    /**
     * Finds a List of rows in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @param pagination Pagination
     * @return List
     */
    List<TipoOrganismo> findAll(TipoOrganismo tipoorganismo, Pagination pagination);

    /**
     * Counts rows in the TipoOrganismo table.
     *
     * @param tipoorganismo TipoOrganismo
     * @return List
     */
    Long findAllCount(TipoOrganismo tipoorganismo);
	
	/**
     * Finds rows in the TipoOrganismo table using like.
     *
     * @param tipoorganismo TipoOrganismo
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<TipoOrganismo> findAllLike(TipoOrganismo tipoorganismo, Pagination pagination, Boolean startsWith);
}

