package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.T17Pais;

/**
 * * T17PaisDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class T17PaisDaoImpl implements T17PaisDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Pais> rwMap = new RowMapper<T17Pais>() {
		public T17Pais mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new T17Pais(resultSet.getString("ID"),
					resultSet.getString("DSO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            Pagination
	 * @return T17Pais
	 */
	public T17Pais add(T17Pais t17pais) {

		String query = "INSERT INTO S17PAIS( ID,DS_O)" + "VALUES (?,?)";

		this.jdbcTemplate.update(query, t17pais.getId(), t17pais.getDsO());
		return t17pais;
	}

	/**
	 * Updates a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            Pagination
	 * @return T17Pais
	 */
	public T17Pais update(T17Pais t17pais) {
		String query = "UPDATE S17PAIS SET DS_O=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17pais.getDsO(), t17pais.getId());
		return t17pais;

	}

	/**
	 * Finds a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            Pagination
	 * @return T17Pais
	 */
	@Transactional(readOnly = true)
	public T17Pais find(T17Pais t17pais) {
		try {
			String query = "SELECT t1.ID ID, t1.DS_O DSO "
					+ "FROM S17PAIS t1  " + "WHERE t1.ID = ?    ";
			return (T17Pais) this.jdbcTemplate.queryForObject(query,
					this.rwMap, t17pais.getId());
		} catch (EmptyResultDataAccessException e) {
			T17Pais t17PaisResul = new T17Pais();
			t17PaisResul.setDsO("");
			return t17PaisResul;
		}
	}

	/**
	 * Removes a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            Pagination
	 * 
	 */
	public void remove(T17Pais t17pais) {
		String query = "DELETE  FROM S17PAIS WHERE ID=?";
		this.jdbcTemplate.update(query, t17pais.getId());

	}

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Pais> findAll(T17Pais t17pais, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM S17PAIS t1 ");
		if (t17pais != null && t17pais.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17pais.getId());
		}
		if (t17pais != null && t17pais.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17pais.getDsO());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Pais>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Pais t17pais) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  S17PAIS t1  ");
		if (t17pais != null && t17pais.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17pais.getId());
		}
		if (t17pais != null && t17pais.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17pais.getDsO());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Pais> findAllExtranjeros(T17Pais t17pais,
			Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM S17PAIS t1 ");
		if (t17pais != null && t17pais.getId() != null) {
			where.append(" AND t1.ID <> ?");
			params.add(t17pais.getId());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Pais>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllExtranjerosCount(T17Pais t17pais) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  S17PAIS t1  ");
		if (t17pais != null && t17pais.getId() != null) {
			where.append(" AND t1.ID <> ?");
			params.add(t17pais.getId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Pais table using like.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Pais> findAllLike(T17Pais t17pais, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM S17PAIS t1 ");
		if (t17pais != null && t17pais.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17pais.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17pais.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17pais != null && t17pais.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17pais.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17pais.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Pais>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

}
