package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.T17Localidad;

/**
 * * T17LocalidadDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class T17LocalidadDaoImpl implements T17LocalidadDao {

	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Localidad> rwMap = new RowMapper<T17Localidad>() {
		public T17Localidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new T17Localidad(resultSet.getString("ID"),
					resultSet.getString("DSO"),
					resultSet.getString("MUNICIPIOID"),
					resultSet.getString("PROVINCIAID"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	public T17Localidad add(T17Localidad t17localidad) {

		String query = "INSERT INTO S17LOCALIDAD( ID,DS_O,MUNICIPIO_ID,PROVINCIA_ID,ENTIDAD_ID)"
				+ "VALUES (?,?,?,?,?)";

		this.jdbcTemplate.update(query, t17localidad.getId(),
				t17localidad.getDsO(), t17localidad.getMunicipioId(),
				t17localidad.getProvinciaId(), t17localidad.getEntidadId());
		return t17localidad;
	}

	/**
	 * Updates a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	public T17Localidad update(T17Localidad t17localidad) {
		String query = "UPDATE S17LOCALIDAD SET DS_O=?,MUNICIPIO_ID=?,PROVINCIA_ID=?,ENTIDAD_ID=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17localidad.getDsO(),
				t17localidad.getMunicipioId(), t17localidad.getProvinciaId(),
				t17localidad.getEntidadId(), t17localidad.getId());
		return t17localidad;

	}

	/**
	 * Finds a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	@Transactional(readOnly = true)
	public T17Localidad find(T17Localidad t17localidad) {
		try {
			String query = "SELECT t1.ID ID, t1.DS_O DSO, t1.MUNICIPIO_ID MUNICIPIOID, t1.PROVINCIA_ID PROVINCIAID, t1.ENTIDAD_ID ENTIDADID "
					+ "FROM S17LOCALIDAD t1  " + "WHERE t1.ID = ?    ";
			return (T17Localidad) this.jdbcTemplate.queryForObject(query,
					this.rwMap, t17localidad.getId());
		} catch (EmptyResultDataAccessException e) {
			T17Localidad t17LocalidadResul = new T17Localidad();
			t17LocalidadResul.setDsO("");
			return t17LocalidadResul;
		}
	}

	/**
	 * Removes a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * 
	 */
	public void remove(T17Localidad t17localidad) {
		String query = "DELETE  FROM T17_LOCALIDAD WHERE ID=?";
		this.jdbcTemplate.update(query, t17localidad.getId());

	}

	/**
	 * Finds a List of rows in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Localidad> findAll(T17Localidad t17localidad,
			Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.MUNICIPIO_ID MUNICIPIOID,t1.PROVINCIA_ID PROVINCIAID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM S17LOCALIDAD t1 ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17localidad.getId());
		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17localidad.getDsO());
		}
		if (t17localidad != null && t17localidad.getMunicipioId() != null) {
			where.append(" AND t1.MUNICIPIO_ID = ?");
			params.add(t17localidad.getMunicipioId());
		}
		if (t17localidad != null && t17localidad.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17localidad.getProvinciaId());
		}
		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(t17localidad.getEntidadId());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Localidad>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Localidad t17localidad) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM S17LOCALIDAD t1  ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17localidad.getId());
		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17localidad.getDsO());
		}
		if (t17localidad != null && t17localidad.getMunicipioId() != null) {
			where.append(" AND t1.MUNICIPIO_ID = ?");
			params.add(t17localidad.getMunicipioId());
		}
		if (t17localidad != null && t17localidad.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17localidad.getProvinciaId());
		}
		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(t17localidad.getEntidadId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Localidad table using like.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Localidad> findAllLike(T17Localidad t17localidad,
			Pagination pagination, Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.MUNICIPIO_ID MUNICIPIOID,t1.PROVINCIA_ID PROVINCIAID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM S17LOCALIDAD t1 ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getId() + "%");
			} else {
				params.add("%" + t17localidad.getId() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getMunicipioId() != null) {
			where.append(" AND UPPER(t1.MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIO_ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getProvinciaId() != null) {
			where.append(" AND UPPER(t1.PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIA_ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getEntidadId() + "%");
			} else {
				params.add("%" + t17localidad.getEntidadId() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");

		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Localidad>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

}
