package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.T17Comarca;

/**
 * * T17ComarcaDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class T17ComarcaDaoImpl implements T17ComarcaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Comarca> rwMap = new RowMapper<T17Comarca>() {
		public T17Comarca mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new T17Comarca(resultSet.getString("ID"),
					resultSet.getString("PROVINCIAID"),
					resultSet.getString("DSO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	public T17Comarca add(T17Comarca t17comarca) {

		String query = "INSERT INTO T17_COMARCA( ID,PROVINCIA_ID,DS_O)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, t17comarca.getId(),
				t17comarca.getProvinciaId(), t17comarca.getDsO());
		return t17comarca;
	}

	/**
	 * Updates a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	public T17Comarca update(T17Comarca t17comarca) {
		String query = "UPDATE T17_COMARCA SET DS_O=? WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17comarca.getDsO(),
				t17comarca.getId(), t17comarca.getProvinciaId());
		return t17comarca;

	}

	/**
	 * Finds a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	@Transactional(readOnly = true)
	public T17Comarca find(T17Comarca t17comarca) {
		String query = "SELECT t1.ID ID, t1.PROVINCIA_ID PROVINCIAID, t1.DS_O DSO "
				+ "FROM T17_COMARCA t1  "
				+ "WHERE t1.ID = ?   AND t1.PROVINCIA_ID = ?    ";
		return (T17Comarca) this.jdbcTemplate.queryForObject(query, this.rwMap,
				t17comarca.getId(), t17comarca.getProvinciaId());
	}

	/**
	 * Removes a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * 
	 */
	public void remove(T17Comarca t17comarca) {
		String query = "DELETE  FROM T17_COMARCA WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17comarca.getId(),
				t17comarca.getProvinciaId());

	}

	/**
	 * Finds a List of rows in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Comarca> findAll(T17Comarca t17comarca, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO "
						+ "FROM T17_COMARCA t1 ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17comarca.getId());
		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17comarca.getProvinciaId());
		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17comarca.getDsO());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Comarca>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Comarca t17comarca) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  T17_COMARCA t1  ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17comarca.getId());
		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17comarca.getProvinciaId());
		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17comarca.getDsO());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Comarca table using like.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Comarca> findAllLike(T17Comarca t17comarca,
			Pagination pagination, Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO "
						+ "FROM T17_COMARCA t1 ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND UPPER(t1.PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIA_ID IS NOT NULL");

		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<T17Comarca>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

}
