package com.ejie.y42b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.PerfilesXlnets;

/**
 * PerfilesXlnetsDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PerfilesXlnetsDaoImpl implements PerfilesXlnetsDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<PerfilesXlnets> rwMap = new RowMapper<PerfilesXlnets>() {
		public PerfilesXlnets mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PerfilesXlnets(resultSet.getString("IDPERFILXLNET"),
					resultSet.getString("PERFILXLNET"),
					resultSet.getString("TIPOACCESO"));
		}
	};

	private RowMapper<PerfilesXlnets> rwMapPK = new RowMapper<PerfilesXlnets>() {
		public PerfilesXlnets mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new PerfilesXlnets(resultSet.getString("IDPERFILXLNET"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<PerfilesXlnets>> rwMapJerarquia = new RowMapper<JerarquiaDto<PerfilesXlnets>>() {
		public JerarquiaDto<PerfilesXlnets> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			PerfilesXlnets perfilesxlnets = new PerfilesXlnets(
					resultSet.getString("IDPERFILXLNET"),
					resultSet.getString("PERFILXLNET"),
					resultSet.getString("TIPOACCESO"));

			JerarquiaDto<PerfilesXlnets> jerarquia = new JerarquiaDto<PerfilesXlnets>();
			jerarquia.setModel(perfilesxlnets);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	public PerfilesXlnets add(PerfilesXlnets perfilesxlnets) {
		String query = "INSERT INTO PERFILES_XLNETS (ID_PERFILXLNET, PERFILXLNET, TIPOACCESO) VALUES (?,?,?)";
		this.jdbcTemplate
				.update(query, perfilesxlnets.getIdPerfilxlnet(),
						perfilesxlnets.getPerfilxlnet(),
						perfilesxlnets.getTipoacceso());
		return perfilesxlnets;
	}

	/**
	 * Updates a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	public PerfilesXlnets update(PerfilesXlnets perfilesxlnets) {
		String query = "UPDATE PERFILES_XLNETS SET PERFILXLNET=?, TIPOACCESO=? WHERE ID_PERFILXLNET=?";
		this.jdbcTemplate.update(query, perfilesxlnets.getPerfilxlnet(),
				perfilesxlnets.getTipoacceso(),
				perfilesxlnets.getIdPerfilxlnet());
		return perfilesxlnets;
	}

	/**
	 * Finds a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	@Transactional(readOnly = true)
	public PerfilesXlnets find(PerfilesXlnets perfilesxlnets) {
		String query = "SELECT t1.ID_PERFILXLNET IDPERFILXLNET, t1.PERFILXLNET PERFILXLNET, t1.TIPOACCESO TIPOACCESO FROM PERFILES_XLNETS t1  WHERE t1.ID_PERFILXLNET = ?  ";

		List<PerfilesXlnets> perfilesxlnetsList = this.jdbcTemplate.query(
				query, this.rwMap, perfilesxlnets.getIdPerfilxlnet());
		return (PerfilesXlnets) DataAccessUtils
				.uniqueResult(perfilesxlnetsList);
	}

	/**
	 * Removes a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return
	 */
	public void remove(PerfilesXlnets perfilesxlnets) {
		String query = "DELETE FROM PERFILES_XLNETS WHERE ID_PERFILXLNET=?";
		this.jdbcTemplate.update(query, perfilesxlnets.getIdPerfilxlnet());
	}

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	@Transactional(readOnly = true)
	public List<PerfilesXlnets> findAll(PerfilesXlnets perfilesxlnets,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		query.append("FROM PERFILES_XLNETS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(perfilesxlnets);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<PerfilesXlnets>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfiles
	 *            Vector<String>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	@Transactional(readOnly = true)
	public List<PerfilesXlnets> findAllPerfiles(Vector<String> perfiles,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		query.append("FROM PERFILES_XLNETS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapPerfiles(perfiles);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY TIPOACCESO DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<PerfilesXlnets>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<PerfilesXlnets>
	 */
	@Transactional(readOnly = true)
	public List<PerfilesXlnets> findAllLike(PerfilesXlnets perfilesxlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		query.append("FROM PERFILES_XLNETS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(perfilesxlnets,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<PerfilesXlnets>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(PerfilesXlnets perfilesxlnets) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PERFILES_XLNETS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(perfilesxlnets);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(PerfilesXlnets perfilesxlnets,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM PERFILES_XLNETS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(perfilesxlnets,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of PerfilesXlnets selected for rup_table
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	@Override
	public List<TableRowDto<PerfilesXlnets>> reorderSelection(
			PerfilesXlnets perfilesxlnets, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		// FROM
		query.append("FROM PERFILES_XLNETS t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(perfilesxlnets,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, PerfilesXlnets.class, filterParamList,
				"ID_PERFILXLNET");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<PerfilesXlnets>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            PerfilesXlnets
	 * @param searchParams
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	@Override
	public List<TableRowDto<PerfilesXlnets>> search(
			PerfilesXlnets filterParams, PerfilesXlnets searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		// FROM
		query.append("FROM PERFILES_XLNETS t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, PerfilesXlnets.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_PERFILXLNET");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<PerfilesXlnets>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterperfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(PerfilesXlnets filterperfilesxlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		// FROM
		query.append("FROM PERFILES_XLNETS t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filterperfilesxlnets, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, PerfilesXlnets.class,
						query, params, "ID_PERFILXLNET");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<PerfilesXlnets>>
	 */
	@Override
	public List<JerarquiaDto<PerfilesXlnets>> findAllLikeJerarquia(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PERFILXLNET IDPERFILXLNET,t1.PERFILXLNET PERFILXLNET,t1.TIPOACCESO TIPOACCESO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM PERFILES_XLNETS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("PERFILES_XLNETS");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPerfilesXlnets,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "ID_PERFILXLNET", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM PERFILES_XLNETS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("PERFILES_XLNETS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPerfilesXlnets,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "ID_PERFILXLNET", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	@Override
	public List<TableRowDto<PerfilesXlnets>> findAllChild(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM PERFILES_XLNETS t1 ");
		List<String> from = new ArrayList<String>();
		from.add("PERFILES_XLNETS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPerfilesXlnets,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "ID_PERFILXLNET", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<PerfilesXlnets>(this.rwMapPK,
						"ID_PERFILXLNET"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PerfilesXlnets entity
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(PerfilesXlnets perfilesxlnets) {

		StringBuilder where = new StringBuilder(
				PerfilesXlnetsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfilesxlnets != null && perfilesxlnets.getIdPerfilxlnet() != null) {
			where.append(" AND t1.ID_PERFILXLNET = ?");
			params.add(perfilesxlnets.getIdPerfilxlnet());
		}
		if (perfilesxlnets != null && perfilesxlnets.getPerfilxlnet() != null) {
			where.append(" AND t1.PERFILXLNET = ?");
			params.add(perfilesxlnets.getPerfilxlnet());
		}
		if (perfilesxlnets != null && perfilesxlnets.getTipoacceso() != null) {
			where.append(" AND t1.TIPOACCESO = ?");
			params.add(perfilesxlnets.getTipoacceso());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PerfilesXlnets entity
	 * 
	 * @param perfiles
	 *            Vector<String>
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapPerfiles(Vector<String> perfiles) {

		StringBuilder where = new StringBuilder(
				PerfilesXlnetsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfiles != null && perfiles.size() > 0) {
			for (int i = 0; i < perfiles.size(); i++) {
				if (i == 0) {
					where.append(" AND (t1.PERFILXLNET = ?");
					params.add(perfiles.get(i));
				} else {
					where.append(" OR t1.PERFILXLNET = ?");
					params.add(perfiles.get(i));
				}
			}
			where.append(" )");
		} else {
			where.append(" AND t1.PERFILXLNET = ''");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the PerfilesXlnets entity
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(PerfilesXlnets perfilesxlnets,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				PerfilesXlnetsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (perfilesxlnets != null && perfilesxlnets.getIdPerfilxlnet() != null) {
			where.append(" AND UPPER(t1.ID_PERFILXLNET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfilesxlnets.getIdPerfilxlnet().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ perfilesxlnets.getIdPerfilxlnet().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_PERFILXLNET IS NOT NULL");
		}
		if (perfilesxlnets != null && perfilesxlnets.getPerfilxlnet() != null) {
			where.append(" AND UPPER(t1.PERFILXLNET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfilesxlnets.getPerfilxlnet().toUpperCase() + "%");
			} else {
				params.add("%" + perfilesxlnets.getPerfilxlnet().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PERFILXLNET IS NOT NULL");
		}
		if (perfilesxlnets != null && perfilesxlnets.getTipoacceso() != null) {
			where.append(" AND UPPER(t1.TIPOACCESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfilesxlnets.getTipoacceso().toUpperCase() + "%");
			} else {
				params.add("%" + perfilesxlnets.getTipoacceso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPOACCESO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
