package com.ejie.y42b.dao;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.y42b.model.PerfilesXlnets;

/**
 * PerfilesXlnetsDao  
 * 
 *  
 */

public interface PerfilesXlnetsDao {

	/**
	 * Inserts a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets add(PerfilesXlnets perfilesxlnets);

	/**
	 * Updates a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets update(PerfilesXlnets perfilesxlnets);

	/**
	 * Finds a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return PerfilesXlnets
	 */
	PerfilesXlnets find(PerfilesXlnets perfilesxlnets);

	/**
	 * Removes a single row in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 */
	void remove(PerfilesXlnets perfilesxlnets);

	/**
	 * Finds a List of rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<PerfilesXlnets> findAll(PerfilesXlnets perfilesxlnets,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the PerfilesXlnets table.
	 * 
	 * @param perfiles
	 *            Vector<String>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<PerfilesXlnets>
	 */
	public List<PerfilesXlnets> findAllPerfiles(Vector<String> perfiles,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PerfilesXlnets> findAllLike(PerfilesXlnets perfilesxlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the PerfilesXlnets table using like.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(PerfilesXlnets perfilesxlnets, Boolean startsWith);

	/**
	 * Counts rows in the PerfilesXlnets table.
	 * 
	 * @param perfilesxlnets
	 *            PerfilesXlnets
	 * @return Long
	 */
	Long findAllCount(PerfilesXlnets perfilesxlnets);

	/**
	 * Reorder selection.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	List<TableRowDto<PerfilesXlnets>> reorderSelection(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param searchPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	List<TableRowDto<PerfilesXlnets>> search(
			PerfilesXlnets filterPerfilesXlnets,
			PerfilesXlnets searchPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical PerfilesXlnets table.
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<PerfilesXlnets>>
	 */
	List<JerarquiaDto<PerfilesXlnets>> findAllLikeJerarquia(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterPerfilesXlnets
	 *            PerfilesXlnets
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<PerfilesXlnets>>
	 */
	List<TableRowDto<PerfilesXlnets>> findAllChild(
			PerfilesXlnets filterPerfilesXlnets,
			JQGridRequestDto jqGridRequestDto);

}
