package com.ejie.y42b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Item;

/**
 * * ItemDao  
 * 
 *  
 */

public interface ItemDao {

	/**
	 * Inserts a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item add(Item item);

	/**
	 * Updates a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item update(Item item);

	/**
	 * Finds a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Item
	 */
	Item find(Item item);

	/**
	 * Deletes a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return
	 */
	void remove(Item item);

	/**
	 * Deletes a single row in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return
	 */
	void removeItemsEnvio(Item item);

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Item> findAll(Item item, Pagination pagination);

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Item> findAllMailsPendientes(Item item, Pagination pagination);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return List
	 */
	Long findAllCount(Item item);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return List
	 */
	Long findAllCountMail(Item item);

	/**
	 * Finds rows in the Item table using like.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Item> findAllLike(Item item, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return List
	 */
	Long findAllCountSeguimiento(Item item);

	/**
	 * Finds rows in the Item table using like.
	 * 
	 * @param item
	 *            Item
	 * @return List
	 */
	List<Item> findLimpiarItems(Item item);

	/**
	 * Updates the selected ones
	 * 
	 * @param item
	 *            Item
	 * 
	 */
	void updateSeleccion(Item item);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param envioId
	 *            String
	 * @return Long
	 */
	Long countItemsNotMailedYetFromEnvio(String envioId);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param envioId
	 *            String
	 * @param resultadoEnvio
	 *            boolean
	 * @return Long
	 */

	Long countItemsMailedFromEnvio(String envioId, boolean resultadoEnvio);

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param envioId
	 *            String
	 * @return Long
	 */
	Long countTipoFromEnvio(String envioId, String tipo);

}
