package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;

/**
 * * EtiquetaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EtiquetaDaoImpl implements EtiquetaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Etiqueta> rwMap = new RowMapper<Etiqueta>() {
		public Etiqueta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Etiqueta(resultSet.getString("ETIQUETAID"),
					resultSet.getString("NOMBRE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta add(Etiqueta etiqueta) {

		String query = "INSERT INTO ETIQUETA( ETIQUETA_ID,NOMBRE)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, etiqueta.getEtiquetaId(),
				etiqueta.getNombre());
		return etiqueta;
	}

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta update(Etiqueta etiqueta) {
		String query = "UPDATE ETIQUETA SET NOMBRE=? WHERE ETIQUETA_ID=?";
		this.jdbcTemplate.update(query, etiqueta.getNombre(),
				etiqueta.getEtiquetaId());
		return etiqueta;
	}

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	@Transactional(readOnly = true)
	public Etiqueta find(Etiqueta etiqueta) {
		String query = "SELECT t1.ETIQUETA_ID ETIQUETAID, t1.NOMBRE NOMBRE "
				+ "FROM ETIQUETA t1  " + "WHERE t1.ETIQUETA_ID = ?    ";
		return (Etiqueta) this.jdbcTemplate.queryForObject(query, this.rwMap,
				etiqueta.getEtiquetaId());
	}

	/**
	 * Removes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return
	 */
	public void remove(Etiqueta etiqueta) {
		String query = "DELETE  FROM ETIQUETA WHERE ETIQUETA_ID=?";
		this.jdbcTemplate.update(query, etiqueta.getEtiquetaId());
	}

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ETIQUETA_ID ETIQUETAID,t1.NOMBRE NOMBRE "
						+ "FROM ETIQUETA t1 ");

		if (etiqueta != null && etiqueta.getEtiquetaId() != null) {
			where.append(" AND t1.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Etiqueta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Etiqueta etiqueta) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ETIQUETA t1  ");
		if (etiqueta != null && etiqueta.getEtiquetaId() != null) {
			where.append(" AND t1.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ETIQUETA_ID ETIQUETAID,t1.NOMBRE NOMBRE "
						+ "FROM ETIQUETA t1 ");

		if (etiqueta != null && etiqueta.getEtiquetaId() != null) {
			where.append(" AND UPPER(t1.ETIQUETA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(etiqueta.getEtiquetaId().toUpperCase() + "%");
			} else {
				params.add("%" + etiqueta.getEtiquetaId().toUpperCase() + "%");
			}
			where.append(" AND t1.ETIQUETA_ID IS NOT NULL");
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(etiqueta.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Etiqueta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta addEtiquetaEntidad(Etiqueta etiqueta) {
		String query = "INSERT INTO Y42B06T00 " + "( ETIQUETA_ID,ENTIDAD_ID) "
				+ " values (?, ?)";

		List<Entidad> auxiliarEntidad = etiqueta.getEntidads();
		Iterator<Entidad> it = auxiliarEntidad.iterator();
		while (it.hasNext()) {
			Entidad entidad = (Entidad) it.next();
			this.jdbcTemplate.update(query, etiqueta.getEtiquetaId(),
					entidad.getEntidadId());
		}
		return etiqueta;
	}

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	public void removeEtiquetaEntidad(Etiqueta etiqueta) {
		String query = "DELETE  FROM Y42B06T00 "
				+ " WHERE ETIQUETA_ID=? AND ENTIDAD_ID=?";
		List<Entidad> auxiliarEntidad = etiqueta.getEntidads();
		Iterator<Entidad> it = auxiliarEntidad.iterator();
		while (it.hasNext()) {
			Entidad entidad = (Entidad) it.next();
			this.jdbcTemplate.update(query, etiqueta.getEtiquetaId(),
					entidad.getEntidadId());
		}
	}

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Y42bEntidad
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	@Transactional(readOnly = true)
	public Etiqueta findEtiquetaEntidad(Etiqueta etiqueta, Entidad entidad,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.ETIQUETA_ID=?");

		params.add(etiqueta.getEtiquetaId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Entidad_id entidadId, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.ACTIVA ACTIVA, t2.ISKONTSUMOGEST ISKONTSUMOGEST, t2.ISKONTSUMONET ISKONTSUMONET, t2.ISOFERTAFORM ISOFERTAFORM, t2.ISCONSULTASWEB ISCONSULTASWEB, t2.COD_ORG CODORG, t2.ISNACIONAL ISNACIONAL, t2.OBSERVACIONES OBSERVACIONES, t2.TELEFONO TELEFONO, t2.FAX FAX, t2.EMAIL EMAIL, t2.URL URL, t2.USUARIO USUARIO, t2.PASSWORD PASSWORD, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD, t2.nora_Pais_Id NORAPAISID, t2.nombre_Pais NOMBREPAIS, t2.nora_Provincia_Id NORAPROVINCIAID, t2.nombre_Provincia NOMBREPROVINCIA, t2.nora_Municipio_Id NORAMUNICIPIOID, t2.nombre_Municipio NOMBREMUNICIPIO, t2.nora_Localidad_Id NORALOCALIDADID, t2.nombre_Localidad NOMBRELOCALIDAD, t2.nora_Calle_Id NORACALLEID, t2.nombre_Calle NOMBRECALLE, t2.nora_Cp_Id NORACPID, t2.nombre_Cp NOMBRECP, t2.nora_Portal_Id NORAPORTALID, t2.nombre_Portal NOMBREPORTAL FROM Y42b06t00 t1,Y42B01T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Entidad> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Entidad>() {
					public Entidad mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Entidad(resultSet.getString("ENTIDADID"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("ACTIVA"), resultSet
										.getString("ISKONTSUMOGEST"), resultSet
										.getString("ISKONTSUMONET"), resultSet
										.getString("ISOFERTAFORM"), resultSet
										.getString("ISCONSULTASWEB"), resultSet
										.getString("ISNACIONAL"), resultSet
										.getString("OBSERVACIONES"), resultSet
										.getString("TELEFONO"), resultSet
										.getString("FAX"), resultSet
										.getString("EMAIL"), resultSet
										.getString("URL"), resultSet
										.getString("USUARIO"), resultSet
										.getString("PASSWORD"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), resultSet
										.getString("NORAPAISID"), resultSet
										.getString("NOMBREPAIS"), resultSet
										.getString("NORAPROVINCIAID"),
								resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"),
								resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"),
								resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet
										.getString("NOMBRECALLE"), resultSet
										.getString("NORACPID"), resultSet
										.getString("NOMBRECP"), resultSet
										.getString("NORAPORTALID"), resultSet
										.getString("NOMBREPORTAL"), resultSet
										.getString("CODORG"), resultSet
										.getString("COMPLE_DIREC"), null, null,
								null);
					}
				}, params.toArray());
		etiqueta.setEntidads(listaHijo);
		return etiqueta;
	}

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Y42bEntidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findEtiquetaEntidadCount(Etiqueta etiqueta, Entidad entidad) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.ETIQUETA_ID=?");

		params.add(etiqueta.getEtiquetaId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b06t00 t1,Y42B01T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta addEtiquetaContacto(Etiqueta etiqueta) {
		String query = "INSERT INTO Y42B10T00 " + "( ETIQUETA_ID,CONTACTO_ID) "
				+ " values (?, ?)";

		List<Contacto> auxiliarContacto = etiqueta.getContactos();
		Iterator<Contacto> it = auxiliarContacto.iterator();
		while (it.hasNext()) {
			Contacto contacto = (Contacto) it.next();
			this.jdbcTemplate.update(query, etiqueta.getEtiquetaId(),
					contacto.getContactoId());
		}
		return etiqueta;
	}

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	public void removeEtiquetaContacto(Etiqueta etiqueta) {
		String query = "DELETE  FROM Y42B10T00 "
				+ " WHERE ETIQUETA_ID=? AND CONTACTO_ID=?";
		List<Contacto> auxiliarContacto = etiqueta.getContactos();
		Iterator<Contacto> it = auxiliarContacto.iterator();
		while (it.hasNext()) {
			Contacto contacto = (Contacto) it.next();
			this.jdbcTemplate.update(query, etiqueta.getEtiquetaId(),
					contacto.getContactoId());
		}
	}

}
