package com.ejie.y42b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;

/**
 * * EtiquetaDao  
 * 
 *  
 */

public interface EtiquetaDao {

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta add(Etiqueta etiqueta);

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta update(Etiqueta etiqueta);

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta find(Etiqueta etiqueta);

	/**
	 * Deletes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	void remove(Etiqueta etiqueta);

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination);

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return List
	 */
	Long findAllCount(Etiqueta etiqueta);

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta addEtiquetaEntidad(Etiqueta etiqueta);

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	void removeEtiquetaEntidad(Etiqueta etiqueta);

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	Etiqueta findEtiquetaEntidad(Etiqueta etiqueta, Entidad entidad,
			Pagination pagination);

	/**
	 * Counts rows rows in the EtiquetaEntidad table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findEtiquetaEntidadCount(Etiqueta etiqueta, Entidad entidad);

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	Etiqueta addEtiquetaContacto(Etiqueta etiqueta);

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	void removeEtiquetaContacto(Etiqueta etiqueta);

}
