package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Envio;
import com.ejie.y42b.model.Item;

/**
 * * EnvioDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EnvioDaoImpl implements EnvioDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Envio> rwMap = new RowMapper<Envio>() {
		public Envio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Envio(resultSet.getString("ENVIOID"),
					resultSet.getString("SESSIONOID"),
					resultSet.getString("TIPO"),
					resultSet.getString("XMLIMPORTADO"),
					resultSet.getString("MAILINGTEMPLATE"),
					resultSet.getString("MAILINGASUNTO"),
					resultSet.getTimestamp("FECHAOPERACION"),
					resultSet.getString("TIPOOPERACION"),
					resultSet.getString("XMLNOMBRECAMPO1"),
					resultSet.getString("XMLNOMBRECAMPO2"),
					resultSet.getString("XMLNOMBRECAMPO3"),
					resultSet.getString("XMLNOMBRECAMPO4"),
					resultSet.getString("XMLNOMBRECAMPO5"),
					resultSet.getString("XMLNOMBRECAMPO6"),
					resultSet.getString("XMLNOMBRECAMPO7"),
					resultSet.getString("XMLNOMBRECAMPO8"),
					resultSet.getString("XMLNOMBRECAMPO9"),
					resultSet.getString("XMLNOMBRECAMPO10"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"),
					resultSet.getString("DESTINATARIOINFORME"),
					resultSet.getString("DIRECCIONORIGEN"),
					resultSet.getString("ENVIOKONTSUMONET"),
					resultSet.getString("ENVIOACONTACTOS"),
					resultSet.getString("REMITENTEENVIO"),
					resultSet.getString("CONFIRMACION"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Envio table.
	 * 
	 * @param envio
	 *            Pagination
	 * @return Envio
	 */
	public Envio add(Envio envio) {

		String query = "INSERT INTO ENVIO( ENVIO_ID,SESSION_OID,TIPO,XMLIMPORTADO,MAILING_TEMPLATE,MAILING_ASUNTO,FECHA_OPERACION,TIPO_OPERACION,XMLNOMBRECAMPO1,XMLNOMBRECAMPO2,XMLNOMBRECAMPO3,XMLNOMBRECAMPO4,XMLNOMBRECAMPO5,XMLNOMBRECAMPO6,XMLNOMBRECAMPO7,XMLNOMBRECAMPO8,XMLNOMBRECAMPO9,XMLNOMBRECAMPO10,USUULTMOD,FECULTMOD,DESTINATARIOINFORME,ENVIOKONTSUMONET,ENVIOACONTACTOS,REMITENTEENVIO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, envio.getEnvioId(),
				envio.getSessionOid(), envio.getTipo(),
				envio.getXmlimportado(), envio.getMailingTemplate(),
				envio.getMailingAsunto(), envio.getFechaOperacion(),
				envio.getTipoOperacion(), envio.getXmlnombrecampo1(),
				envio.getXmlnombrecampo2(), envio.getXmlnombrecampo3(),
				envio.getXmlnombrecampo4(), envio.getXmlnombrecampo5(),
				envio.getXmlnombrecampo6(), envio.getXmlnombrecampo7(),
				envio.getXmlnombrecampo8(), envio.getXmlnombrecampo9(),
				envio.getXmlnombrecampo10(), envio.getUsuultmod(),
				envio.getFecultmod(), envio.getDestinatarioInforme(),
				envio.getEnvioKontsumonet(), envio.getEnvioAContactos(),
				envio.getRemitenteEnvio());
		return envio;
	}

	/**
	 * Updates a single row in the Envio table.
	 * 
	 * @param envio
	 *            Pagination
	 * @return Envio
	 */
	public Envio update(Envio envio) {
		StringBuilder query = new StringBuilder(Y42bAgendaConstantes.NUM_128);
		query.append("UPDATE ENVIO SET SESSION_OID=?,TIPO=?,XMLIMPORTADO=?,MAILING_TEMPLATE=?,MAILING_ASUNTO=?,");
		query.append("FECHA_OPERACION=?,TIPO_OPERACION=?,XMLNOMBRECAMPO1=?,XMLNOMBRECAMPO2=?,XMLNOMBRECAMPO3=?,");
		query.append("XMLNOMBRECAMPO4=?,XMLNOMBRECAMPO5=?,XMLNOMBRECAMPO6=?,XMLNOMBRECAMPO7=?,XMLNOMBRECAMPO8=?,");
		query.append("XMLNOMBRECAMPO9=?,XMLNOMBRECAMPO10=?,USUULTMOD=?,FECULTMOD=?,DESTINATARIOINFORME=?,DIRECCIONORIGEN=?, ENVIOKONTSUMONET=?, ENVIOACONTACTOS = ?,REMITENTEENVIO=?, CONFIRMACION=? WHERE ENVIO_ID=?");

		this.jdbcTemplate
				.update(query.toString(), envio.getSessionOid(),
						envio.getTipo(), envio.getXmlimportado(),
						envio.getMailingTemplate(), envio.getMailingAsunto(),
						envio.getFechaOperacion(), envio.getTipoOperacion(),
						envio.getXmlnombrecampo1(), envio.getXmlnombrecampo2(),
						envio.getXmlnombrecampo3(), envio.getXmlnombrecampo4(),
						envio.getXmlnombrecampo5(), envio.getXmlnombrecampo6(),
						envio.getXmlnombrecampo7(), envio.getXmlnombrecampo8(),
						envio.getXmlnombrecampo9(),
						envio.getXmlnombrecampo10(), envio.getUsuultmod(),
						envio.getFecultmod(), envio.getDestinatarioInforme(),
						envio.getDireccionOrigen(),
						envio.getEnvioKontsumonet(),
						envio.getEnvioAContactos(), envio.getRemitenteEnvio(),
						envio.getAcuse(), envio.getEnvioId());
		return envio;
	}

	/**
	 * Finds a single row in the Envio table.
	 * 
	 * @param envio
	 *            Pagination
	 * @return Envio
	 */
	@Transactional(readOnly = true)
	public Envio find(Envio envio) {
		String query = "SELECT t1.ENVIO_ID ENVIOID, t1.SESSION_OID SESSIONOID, t1.TIPO TIPO, t1.XMLIMPORTADO XMLIMPORTADO, t1.MAILING_TEMPLATE MAILINGTEMPLATE, t1.MAILING_ASUNTO MAILINGASUNTO, t1.FECHA_OPERACION FECHAOPERACION, t1.TIPO_OPERACION TIPOOPERACION, t1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1, t1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2, t1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3, t1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4, t1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5, t1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6, t1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7, t1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8, t1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9, t1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.DESTINATARIOINFORME, t1.DIRECCIONORIGEN, t1.ENVIOKONTSUMONET,t1.ENVIOACONTACTOS, t1.REMITENTEENVIO, t1.CONFIRMACION "
				+ "FROM ENVIO t1  " + "WHERE t1.ENVIO_ID = ?    ";
		return (Envio) this.jdbcTemplate.queryForObject(query, this.rwMap,
				envio.getEnvioId());
	}

	/**
	 * Removes a single row in the Envio table.
	 * 
	 * @param envio
	 *            Pagination
	 * @return
	 */
	public void remove(Envio envio) {
		String query = "DELETE  FROM ENVIO WHERE ENVIO_ID=?";
		this.jdbcTemplate.update(query, envio.getEnvioId());
	}

	/**
	 * Finds a List of rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAll(Envio envio, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENVIO_ID ENVIOID,t1.SESSION_OID SESSIONOID,t1.TIPO TIPO,t1.XMLIMPORTADO XMLIMPORTADO,t1.MAILING_TEMPLATE MAILINGTEMPLATE,t1.MAILING_ASUNTO MAILINGASUNTO,t1.FECHA_OPERACION FECHAOPERACION,t1.TIPO_OPERACION TIPOOPERACION,t1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1,t1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2,t1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3,t1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4,t1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5,t1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6,t1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7,t1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8,t1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9,t1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.DESTINATARIOINFORME DESTINATARIOINFORME,t1.DIRECCIONORIGEN, t1.ENVIOKONTSUMONET,t1.ENVIOACONTACTOS, t1.REMITENTEENVIO,t1.CONFIRMACION "
						+ "FROM ENVIO t1 ");

		if (envio != null && envio.getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(envio.getEnvioId());
		}
		if (envio != null && envio.getSessionOid() != null) {
			where.append(" AND t1.SESSION_OID = ?");
			params.add(envio.getSessionOid());
		}
		if (envio != null && envio.getTipo() != null) {
			where.append(" AND t1.TIPO = ?");
			params.add(envio.getTipo());
		}
		if (envio != null && envio.getXmlimportado() != null) {
			where.append(" AND t1.XMLIMPORTADO = ?");
			params.add(envio.getXmlimportado());
		}
		if (envio != null && envio.getMailingTemplate() != null) {
			where.append(" AND t1.MAILING_TEMPLATE = ?");
			params.add(envio.getMailingTemplate());
		}
		if (envio != null && envio.getMailingAsunto() != null) {
			where.append(" AND t1.MAILING_ASUNTO = ?");
			params.add(envio.getMailingAsunto());
		}
		if (envio != null && envio.getFechaOperacion() != null) {
			where.append(" AND t1.FECHA_OPERACION = ?");
			params.add(envio.getFechaOperacion());
		}
		if (envio != null && envio.getTipoOperacion() != null) {
			where.append(" AND t1.TIPO_OPERACION = ?");
			params.add(envio.getTipoOperacion());
		}
		if (envio != null && envio.getXmlnombrecampo1() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO1 = ?");
			params.add(envio.getXmlnombrecampo1());
		}
		if (envio != null && envio.getXmlnombrecampo2() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO2 = ?");
			params.add(envio.getXmlnombrecampo2());
		}
		if (envio != null && envio.getXmlnombrecampo3() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO3 = ?");
			params.add(envio.getXmlnombrecampo3());
		}
		if (envio != null && envio.getXmlnombrecampo4() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO4 = ?");
			params.add(envio.getXmlnombrecampo4());
		}
		if (envio != null && envio.getXmlnombrecampo5() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO5 = ?");
			params.add(envio.getXmlnombrecampo5());
		}
		if (envio != null && envio.getXmlnombrecampo6() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO6 = ?");
			params.add(envio.getXmlnombrecampo6());
		}
		if (envio != null && envio.getXmlnombrecampo7() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO7 = ?");
			params.add(envio.getXmlnombrecampo7());
		}
		if (envio != null && envio.getXmlnombrecampo8() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO8 = ?");
			params.add(envio.getXmlnombrecampo8());
		}
		if (envio != null && envio.getXmlnombrecampo9() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO9 = ?");
			params.add(envio.getXmlnombrecampo9());
		}
		if (envio != null && envio.getXmlnombrecampo10() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO10 = ?");
			params.add(envio.getXmlnombrecampo10());
		}
		if (envio != null && envio.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(envio.getUsuultmod());
		}
		if (envio != null && envio.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(envio.getFecultmod());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Envio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Envio envio) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ENVIO t1  ");
		if (envio != null && envio.getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(envio.getEnvioId());
		}
		if (envio != null && envio.getSessionOid() != null) {
			where.append(" AND t1.SESSION_OID = ?");
			params.add(envio.getSessionOid());
		}
		if (envio != null && envio.getTipo() != null) {
			where.append(" AND t1.TIPO = ?");
			params.add(envio.getTipo());
		}
		if (envio != null && envio.getXmlimportado() != null) {
			where.append(" AND t1.XMLIMPORTADO = ?");
			params.add(envio.getXmlimportado());
		}
		if (envio != null && envio.getMailingTemplate() != null) {
			where.append(" AND t1.MAILING_TEMPLATE = ?");
			params.add(envio.getMailingTemplate());
		}
		if (envio != null && envio.getMailingAsunto() != null) {
			where.append(" AND t1.MAILING_ASUNTO = ?");
			params.add(envio.getMailingAsunto());
		}
		if (envio != null && envio.getFechaOperacion() != null) {
			where.append(" AND t1.FECHA_OPERACION = ?");
			params.add(envio.getFechaOperacion());
		}
		if (envio != null && envio.getTipoOperacion() != null) {
			where.append(" AND t1.TIPO_OPERACION = ?");
			params.add(envio.getTipoOperacion());
		}
		if (envio != null && envio.getXmlnombrecampo1() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO1 = ?");
			params.add(envio.getXmlnombrecampo1());
		}
		if (envio != null && envio.getXmlnombrecampo2() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO2 = ?");
			params.add(envio.getXmlnombrecampo2());
		}
		if (envio != null && envio.getXmlnombrecampo3() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO3 = ?");
			params.add(envio.getXmlnombrecampo3());
		}
		if (envio != null && envio.getXmlnombrecampo4() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO4 = ?");
			params.add(envio.getXmlnombrecampo4());
		}
		if (envio != null && envio.getXmlnombrecampo5() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO5 = ?");
			params.add(envio.getXmlnombrecampo5());
		}
		if (envio != null && envio.getXmlnombrecampo6() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO6 = ?");
			params.add(envio.getXmlnombrecampo6());
		}
		if (envio != null && envio.getXmlnombrecampo7() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO7 = ?");
			params.add(envio.getXmlnombrecampo7());
		}
		if (envio != null && envio.getXmlnombrecampo8() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO8 = ?");
			params.add(envio.getXmlnombrecampo8());
		}
		if (envio != null && envio.getXmlnombrecampo9() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO9 = ?");
			params.add(envio.getXmlnombrecampo9());
		}
		if (envio != null && envio.getXmlnombrecampo10() != null) {
			where.append(" AND t1.XMLNOMBRECAMPO10 = ?");
			params.add(envio.getXmlnombrecampo10());
		}
		if (envio != null && envio.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(envio.getUsuultmod());
		}
		if (envio != null && envio.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(envio.getFecultmod());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllLike(Envio envio, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENVIO_ID ENVIOID,t1.SESSION_OID SESSIONOID,t1.TIPO TIPO,t1.XMLIMPORTADO XMLIMPORTADO,t1.MAILING_TEMPLATE MAILINGTEMPLATE,t1.MAILING_ASUNTO MAILINGASUNTO,t1.FECHA_OPERACION FECHAOPERACION,t1.TIPO_OPERACION TIPOOPERACION,t1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1,t1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2,t1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3,t1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4,t1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5,t1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6,t1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7,t1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8,t1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9,t1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.DESTINATARIOINFORME,t1.DIRECCIONORIGEN, t1.ENVIOKONTSUMONET, t1.REMITENTEENVIO "
						+ "FROM ENVIO t1 ");

		if (envio != null && envio.getEnvioId() != null) {
			where.append(" AND UPPER(t1.ENVIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getEnvioId().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getEnvioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENVIO_ID IS NOT NULL");
		}
		if (envio != null && envio.getSessionOid() != null) {
			where.append(" AND UPPER(t1.SESSION_OID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getSessionOid().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getSessionOid().toUpperCase() + "%");
			}
			where.append(" AND t1.SESSION_OID IS NOT NULL");
		}
		if (envio != null && envio.getTipo() != null) {
			where.append(" AND UPPER(t1.TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getTipo().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getTipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO IS NOT NULL");
		}
		if (envio != null && envio.getXmlimportado() != null) {
			where.append(" AND UPPER(t1.XMLIMPORTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlimportado().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlimportado().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLIMPORTADO IS NOT NULL");
		}
		if (envio != null && envio.getMailingTemplate() != null) {
			where.append(" AND UPPER(t1.MAILING_TEMPLATE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingTemplate().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingTemplate().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_TEMPLATE IS NOT NULL");
		}
		if (envio != null && envio.getMailingAsunto() != null) {
			where.append(" AND UPPER(t1.MAILING_ASUNTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingAsunto().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingAsunto().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_ASUNTO IS NOT NULL");
		}
		if (envio != null && envio.getFechaOperacion() != null) {
			where.append(" AND t1.FECHA_OPERACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getFechaOperacion() + "%");
			} else {
				params.add("%" + envio.getFechaOperacion() + "%");
			}
			where.append(" AND t1.FECHA_OPERACION IS NOT NULL");
		}
		if (envio != null && envio.getTipoOperacion() != null) {
			where.append(" AND UPPER(t1.TIPO_OPERACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getTipoOperacion().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getTipoOperacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO_OPERACION IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo1() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo1().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo1().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO1 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo2() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo2().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo2().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO2 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo3() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo3().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo3().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO3 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo4() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo4().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo4().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO4 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo5() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo5().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo5().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO5 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo6() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO6) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo6().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo6().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO6 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo7() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo7().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo7().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO7 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo8() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo8().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo8().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO8 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo9() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO9) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo9().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo9().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO9 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo10() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo10().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo10().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO10 IS NOT NULL");
		}
		if (envio != null && envio.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (envio != null && envio.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getFecultmod() + "%");
			} else {
				params.add("%" + envio.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Envio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllLikeSeguimiento(Envio envio,
			Pagination pagination, Boolean startsWith, Date fechaDesde,
			Date fechaHasta) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.FECHA_OPERACION IS NOT NULL AND (t1.TIPO_OPERACION='M' OR t1.TIPO_OPERACION='D') ");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENVIO_ID ENVIOID,t1.SESSION_OID SESSIONOID,t1.TIPO TIPO,t1.XMLIMPORTADO XMLIMPORTADO,t1.MAILING_TEMPLATE MAILINGTEMPLATE,t1.MAILING_ASUNTO MAILINGASUNTO,t1.FECHA_OPERACION FECHAOPERACION,t1.TIPO_OPERACION TIPOOPERACION,t1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1,t1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2,t1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3,t1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4,t1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5,t1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6,t1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7,t1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8,t1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9,t1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.DESTINATARIOINFORME,t1.DIRECCIONORIGEN, t1.ENVIOKONTSUMONET, t1.ENVIOACONTACTOS,t1.REMITENTEENVIO ,t1.CONFIRMACION "
						+ " FROM ENVIO t1 ");

		if (envio != null && envio.getEnvioId() != null) {
			where.append(" AND UPPER(t1.ENVIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getEnvioId().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getEnvioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENVIO_ID IS NOT NULL");
		}
		if (envio != null && envio.getSessionOid() != null) {
			where.append(" AND UPPER(t1.SESSION_OID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getSessionOid().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getSessionOid().toUpperCase() + "%");
			}
			where.append(" AND t1.SESSION_OID IS NOT NULL");
		}
		if (envio != null && envio.getTipo() != null) {
			where.append(" AND UPPER(t1.TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getTipo().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getTipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO IS NOT NULL");
		}
		if (envio != null && envio.getXmlimportado() != null) {
			where.append(" AND UPPER(t1.XMLIMPORTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlimportado().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlimportado().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLIMPORTADO IS NOT NULL");
		}
		if (envio != null && envio.getMailingTemplate() != null) {
			where.append(" AND UPPER(t1.MAILING_TEMPLATE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingTemplate().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingTemplate().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_TEMPLATE IS NOT NULL");
		}
		if (envio != null && envio.getMailingAsunto() != null
				&& (envio.getMailingAsunto()).length() > 0) {
			where.append(" AND UPPER(t1.MAILING_ASUNTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingAsunto().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingAsunto().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_ASUNTO IS NOT NULL");
		}
		/*
		 * if (envio != null && envio.getFechaOperacion() != null ) {
		 * where.append(" AND t1.FECHA_OPERACION like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(envio.getFechaOperacion() +"%"); }else{
		 * params.add("%"+envio.getFechaOperacion() +"%"); }
		 * where.append(" AND t1.FECHA_OPERACION IS NOT NULL"); } if (envio !=
		 * null && envio.getTipoOperacion() != null ) {
		 * where.append(" AND UPPER(t1.TIPO_OPERACION) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(envio.getTipoOperacion().toUpperCase()
		 * +"%"); }else{ params.add("%"+envio.getTipoOperacion().toUpperCase()
		 * +"%"); } where.append(" AND t1.TIPO_OPERACION IS NOT NULL"); }
		 */
		if (envio != null && envio.getXmlnombrecampo1() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo1().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo1().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO1 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo2() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo2().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo2().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO2 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo3() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo3().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo3().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO3 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo4() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo4().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo4().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO4 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo5() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo5().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo5().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO5 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo6() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO6) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo6().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo6().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO6 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo7() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo7().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo7().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO7 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo8() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo8().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo8().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO8 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo9() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO9) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo9().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo9().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO9 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo10() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo10().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo10().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO10 IS NOT NULL");
		}
		if (envio != null && envio.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (envio != null && envio.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getFecultmod() + "%");
			} else {
				params.add("%" + envio.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null) {
			where.append(" AND t1.FECHA_OPERACION >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null) {
			where.append(" AND t1.FECHA_OPERACION <= ?");
			params.add(fechaHasta);
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Envio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeSeguimientoCount(Envio envio, Pagination pagination,
			Boolean startsWith, Date fechaDesde, Date fechaHasta) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.FECHA_OPERACION IS NOT NULL AND (t1.TIPO_OPERACION='M' OR t1.TIPO_OPERACION='D') ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ENVIO t1  ");

		if (envio != null && envio.getEnvioId() != null) {
			where.append(" AND UPPER(t1.ENVIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getEnvioId().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getEnvioId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENVIO_ID IS NOT NULL");
		}
		if (envio != null && envio.getSessionOid() != null) {
			where.append(" AND UPPER(t1.SESSION_OID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getSessionOid().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getSessionOid().toUpperCase() + "%");
			}
			where.append(" AND t1.SESSION_OID IS NOT NULL");
		}
		if (envio != null && envio.getTipo() != null) {
			where.append(" AND UPPER(t1.TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getTipo().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getTipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO IS NOT NULL");
		}
		if (envio != null && envio.getXmlimportado() != null) {
			where.append(" AND UPPER(t1.XMLIMPORTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlimportado().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlimportado().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLIMPORTADO IS NOT NULL");
		}
		if (envio != null && envio.getMailingTemplate() != null) {
			where.append(" AND UPPER(t1.MAILING_TEMPLATE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingTemplate().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingTemplate().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_TEMPLATE IS NOT NULL");
		}
		if (envio != null && envio.getMailingAsunto() != null
				&& (envio.getMailingAsunto()).length() > 0) {
			where.append(" AND UPPER(t1.MAILING_ASUNTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getMailingAsunto().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getMailingAsunto().toUpperCase() + "%");
			}
			where.append(" AND t1.MAILING_ASUNTO IS NOT NULL");
		}
		/*
		 * if (envio != null && envio.getFechaOperacion() != null ) {
		 * where.append(" AND t1.FECHA_OPERACION like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(envio.getFechaOperacion() +"%"); }else{
		 * params.add("%"+envio.getFechaOperacion() +"%"); }
		 * where.append(" AND t1.FECHA_OPERACION IS NOT NULL"); } if (envio !=
		 * null && envio.getTipoOperacion() != null ) {
		 * where.append(" AND UPPER(t1.TIPO_OPERACION) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(envio.getTipoOperacion().toUpperCase()
		 * +"%"); }else{ params.add("%"+envio.getTipoOperacion().toUpperCase()
		 * +"%"); } where.append(" AND t1.TIPO_OPERACION IS NOT NULL"); }
		 */
		if (envio != null && envio.getXmlnombrecampo1() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo1().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo1().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO1 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo2() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo2().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo2().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO2 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo3() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo3().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo3().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO3 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo4() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo4().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo4().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO4 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo5() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo5().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo5().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO5 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo6() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO6) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo6().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo6().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO6 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo7() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo7().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo7().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO7 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo8() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo8().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo8().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO8 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo9() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO9) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo9().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo9().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO9 IS NOT NULL");
		}
		if (envio != null && envio.getXmlnombrecampo10() != null) {
			where.append(" AND UPPER(t1.XMLNOMBRECAMPO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getXmlnombrecampo10().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getXmlnombrecampo10().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMLNOMBRECAMPO10 IS NOT NULL");
		}
		if (envio != null && envio.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + envio.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (envio != null && envio.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(envio.getFecultmod() + "%");
			} else {
				params.add("%" + envio.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null) {
			where.append(" AND t1.FECHA_OPERACION >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null) {
			where.append(" AND t1.FECHA_OPERACION <= ?");
			params.add(fechaHasta);
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * JavaMail filtered Finds a List of rows in the Envio table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllPrepararEnviosMail() {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		query.append("SELECT  T1.ENVIO_ID ENVIOID,T1.SESSION_OID SESSIONOID,T1.TIPO TIPO,T1.XMLIMPORTADO XMLIMPORTADO,T1.MAILING_TEMPLATE MAILINGTEMPLATE,T1.MAILING_ASUNTO MAILINGASUNTO,T1.FECHA_OPERACION FECHAOPERACION,T1.TIPO_OPERACION TIPOOPERACION,T1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1,T1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2,T1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3,T1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4,T1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5,T1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6,T1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7,T1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8,T1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9,T1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10,T1.USUULTMOD USUULTMOD,T1.FECULTMOD FECULTMOD,T1.DESTINATARIOINFORME DESTINATARIOINFORME, T1.ENVIOKONTSUMONET ENVIOKONTSUMONET, T1.REMITENTEENVIO REMITENTEENVIO ");
		query.append(", T2.ITEM_REF ITEMREF");
		query.append(" FROM ENVIO T1, ITEM T2 ");

		/*
		 * SELECT T1.*, T2.ITEM_REF FROM ENVIO T1, ITEM T2 WHERE T1.ENVIO_ID =
		 * T2.ENVIO_ID and NOT T1.FECHA_OPERACION IS NULL and
		 * (T1.TIPO_OPERACION='D' OR T1.TIPO_OPERACION='M') and
		 * T2.FECHA_MAILING_ENVIO IS NULL and T2.SELECCIONADO = 'S' ORDER BY
		 * T1.FECHA_OPERACION ASC;
		 */
		where.append(" WHERE 1 = 1 ");
		where.append(" AND T1.ENVIO_ID = T2.ENVIO_ID ");
		where.append(" AND NOT T1.FECHA_OPERACION IS NULL");
		where.append(" AND ( T1.TIPO_OPERACION = 'D' OR T1.TIPO_OPERACION = 'M' )");
		where.append(" AND T2.FECHA_MAILING_ENVIO IS NULL");
		where.append(" and T2.MAILING_RESPONSE_CODE IS NULL");
		where.append(" AND T2.SELECCIONADO = 'S'");
		where.append(" ORDER BY T1.FECHA_OPERACION ASC");

		query.append(where);

		RowMapper<Envio> rwMap = new RowMapper<Envio>() {
			public Envio mapRow(ResultSet resultSet, int rowNum)
					throws SQLException {

				List<Item> lstItems = new ArrayList<Item>();
				Item item = new Item();
				item.setItemRef(resultSet.getString("ITEMREF"));
				lstItems.add(item);
				return new Envio(resultSet.getString("ENVIOID"),
						resultSet.getString("SESSIONOID"),
						resultSet.getString("TIPO"),
						resultSet.getString("XMLIMPORTADO"),
						resultSet.getString("MAILINGTEMPLATE"),
						resultSet.getString("MAILINGASUNTO"),
						resultSet.getDate("FECHAOPERACION"),
						resultSet.getString("TIPOOPERACION"),
						resultSet.getString("XMLNOMBRECAMPO1"),
						resultSet.getString("XMLNOMBRECAMPO2"),
						resultSet.getString("XMLNOMBRECAMPO3"),
						resultSet.getString("XMLNOMBRECAMPO4"),
						resultSet.getString("XMLNOMBRECAMPO5"),
						resultSet.getString("XMLNOMBRECAMPO6"),
						resultSet.getString("XMLNOMBRECAMPO7"),
						resultSet.getString("XMLNOMBRECAMPO8"),
						resultSet.getString("XMLNOMBRECAMPO9"),
						resultSet.getString("XMLNOMBRECAMPO10"),
						resultSet.getString("USUULTMOD"),
						resultSet.getDate("FECULTMOD"),
						resultSet.getString("DESTINATARIOINFORME"),
						resultSet.getString("ENVIOKONTSUMONET"),
						resultSet.getString("ENVIOACONTACTOS"),
						resultSet.getString("REMITENTEENVIO"),
						resultSet.getString("CONFIRMACION"), null, lstItems);

			}
		};

		return (List<Envio>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());

	}

	/**
	 * JavaMail filtered Finds a List of rows in the Envio table.
	 * 
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllLimpiarEnviosMail() {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		query.append("SELECT  T1.ENVIO_ID ENVIOID,T1.SESSION_OID SESSIONOID,T1.TIPO TIPO,T1.XMLIMPORTADO XMLIMPORTADO,T1.MAILING_TEMPLATE MAILINGTEMPLATE,T1.MAILING_ASUNTO MAILINGASUNTO,T1.FECHA_OPERACION FECHAOPERACION,T1.TIPO_OPERACION TIPOOPERACION,T1.XMLNOMBRECAMPO1 XMLNOMBRECAMPO1,T1.XMLNOMBRECAMPO2 XMLNOMBRECAMPO2,T1.XMLNOMBRECAMPO3 XMLNOMBRECAMPO3,T1.XMLNOMBRECAMPO4 XMLNOMBRECAMPO4,T1.XMLNOMBRECAMPO5 XMLNOMBRECAMPO5,T1.XMLNOMBRECAMPO6 XMLNOMBRECAMPO6,T1.XMLNOMBRECAMPO7 XMLNOMBRECAMPO7,T1.XMLNOMBRECAMPO8 XMLNOMBRECAMPO8,T1.XMLNOMBRECAMPO9 XMLNOMBRECAMPO9,T1.XMLNOMBRECAMPO10 XMLNOMBRECAMPO10,T1.USUULTMOD USUULTMOD,T1.FECULTMOD FECULTMOD, T1.DESTINATARIOINFORME DESTINATARIOINFORME, T1.ENVIOKONTSUMONET ENVIOKONTSUMONET, T1.REMITENTEENVIO REMITENTEENVIO ");
		query.append(" FROM ENVIO T1 ");

		/*
		 * SELECT t1.* FROM ENVIO T1 WHERE NOT T1.FECHA_OPERACION IS NULL AND
		 * (sysdate-T1.FECHA_OPERACION)>7 ORDER BY T1.FECHA_OPERACION ASC;
		 */
		where.append(" WHERE 1 = 1 ");
		where.append(" AND NOT T1.FECHA_OPERACION IS NULL ");
		where.append(" AND (sysdate-T1.FECHA_OPERACION)>7");
		where.append(" ORDER BY T1.FECHA_OPERACION ASC");
		query.append(where);

		RowMapper<Envio> rwMap = new RowMapper<Envio>() {
			public Envio mapRow(ResultSet resultSet, int rowNum)
					throws SQLException {

				return new Envio(resultSet.getString("ENVIOID"),
						resultSet.getString("SESSIONOID"),
						resultSet.getString("TIPO"),
						resultSet.getString("XMLIMPORTADO"),
						resultSet.getString("MAILINGTEMPLATE"),
						resultSet.getString("MAILINGASUNTO"),
						resultSet.getDate("FECHAOPERACION"),
						resultSet.getString("TIPOOPERACION"),
						resultSet.getString("XMLNOMBRECAMPO1"),
						resultSet.getString("XMLNOMBRECAMPO2"),
						resultSet.getString("XMLNOMBRECAMPO3"),
						resultSet.getString("XMLNOMBRECAMPO4"),
						resultSet.getString("XMLNOMBRECAMPO5"),
						resultSet.getString("XMLNOMBRECAMPO6"),
						resultSet.getString("XMLNOMBRECAMPO7"),
						resultSet.getString("XMLNOMBRECAMPO8"),
						resultSet.getString("XMLNOMBRECAMPO9"),
						resultSet.getString("XMLNOMBRECAMPO10"),
						resultSet.getString("USUULTMOD"),
						resultSet.getDate("FECULTMOD"),
						resultSet.getString("DESTINATARIOINFORME"),
						resultSet.getString("ENVIOKONTSUMONET"),
						resultSet.getString("REMITENTEENVIO"),
						resultSet.getString("CONFIRMACION"), null, null);

			}
		};

		return (List<Envio>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());

	}

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountKontsumonet(String envioId) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");
		where.append(" AND t1.ENVIO_ID = t2.ENVIO_ID ");
		where.append(" AND t2.ITEM_REF = t3.ENTIDAD_ID ");
		where.append(" AND t3.ISKONTSUMONET='S' ");
		where.append(" AND t2.SELECCIONADO='S' ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ENVIO t1, ITEM t2, ENTIDAD t3 ");

		if (envioId != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(envioId);
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
