package com.ejie.y42b.dao;

import java.util.Date;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Envio;

/**
 * * EnvioDao  
 * 
 *  
 */

public interface EnvioDao {

	/**
	 * Inserts a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	Envio add(Envio envio);

	/**
	 * Updates a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	Envio update(Envio envio);

	/**
	 * Finds a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return Envio
	 */
	Envio find(Envio envio);

	/**
	 * Deletes a single row in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return
	 */
	void remove(Envio envio);

	/**
	 * Finds a List of rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Envio> findAll(Envio envio, Pagination pagination);

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return List
	 */
	Long findAllCount(Envio envio);

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Envio> findAllLike(Envio envio, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Envio table using like.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<Envio> findAllLikeSeguimiento(Envio envio, Pagination pagination,
			Boolean startsWith, Date fechaDesde, Date fechaHasta);

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeSeguimientoCount(Envio envio, Pagination pagination,
			Boolean startsWith, Date fechaDesde, Date fechaHasta);

	/**
	 * JavaMail filtered Finds a List of rows in the Envio table con criterios
	 * de envio de correos fijo.
	 * 
	 * @return List<Envio>
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllPrepararEnviosMail();

	/**
	 * JavaMail filtered Finds a List of rows in the Envio table con criterios
	 * de envio de correos fijo.
	 * 
	 * @return List<Envio>
	 */
	@Transactional(readOnly = true)
	public List<Envio> findAllLimpiarEnviosMail();

	/**
	 * Counts rows in the Envio table.
	 * 
	 * @param envio
	 *            Envio
	 * @return List
	 */
	Long findAllCountKontsumonet(String envioId);

}
