package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.dao.constantes.Y42bConstantesTbEntidades;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;

/**
 * * EntidadDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class EntidadDaoImpl implements EntidadDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Entidad> rwMap = new RowMapper<Entidad>() {
		public Entidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Entidad(resultSet.getString("ENTIDADID"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("ACTIVA"),
					resultSet.getString("ISKONTSUMOGEST"),
					resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("ISOFERTAFORM"),
					resultSet.getString("ISCONSULTASWEB"),
					resultSet.getString("ISNACIONAL"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getString("TELEFONO"),
					resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"), resultSet.getString("USUARIO"),
					resultSet.getString("PASSWORD"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("CODORG"),
					resultSet.getString("COMPLE_DIREC"),
					resultSet.getString("TIPOORGANISMO"),
					resultSet.getString("AMBITOGEOGRAFICO"),
					resultSet.getString("CIF"));
		}
	};
	private RowMapper<Entidad> rwMapCodOrg = new RowMapper<Entidad>() {
		public Entidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Entidad(resultSet.getString("COD_ORG"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	public Entidad add(Entidad entidad) {

		String query = "INSERT INTO ENTIDAD( ENTIDAD_ID,NOMBRE_ES,NOMBRE_EU,ACTIVA,ISKONTSUMOGEST,ISKONTSUMONET,ISOFERTAFORM,ISCONSULTASWEB,ISNACIONAL,OBSERVACIONES,TELEFONO,FAX,EMAIL,URL,USUARIO,PASSWORD,USUULTMOD,FECULTMOD,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,COD_ORG,TIPOORGANISMO,AMBITOGEOGRAFICO,CIF,COMPLE_DIREC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, entidad.getEntidadId(),
				entidad.getNombreEs(), entidad.getNombreEu(),
				entidad.getActiva(), entidad.getIskontsumogest(),
				entidad.getIskontsumonet(), entidad.getIsofertaform(),
				entidad.getIsconsultasweb(), entidad.getIsnacional(),
				entidad.getObservaciones(), entidad.getTelefono(),
				entidad.getFax(), entidad.getEmail(), entidad.getUrl(),
				entidad.getUsuario(), entidad.getPassword(),
				entidad.getUsuultmod(), entidad.getFecultmod(),
				entidad.getNoraPaisId(), entidad.getNombrePais(),
				entidad.getNoraProvinciaId(), entidad.getNombreProvincia(),
				entidad.getNoraMunicipioId(), entidad.getNombreMunicipio(),
				entidad.getNoraLocalidadId(), entidad.getNombreLocalidad(),
				entidad.getNoraCalleId(), entidad.getNombreCalle(),
				entidad.getNoraCpId(), entidad.getNombreCp(),
				entidad.getNoraPortalId(), entidad.getNombrePortal(),
				entidad.getCodOrg(), entidad.getTipoOrganismo(),
				entidad.getAmbitoGeografico(), entidad.getCif(),
				entidad.getCompleDirec());
		return entidad;
	}

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	public Entidad update(Entidad entidad) {
		String query = "UPDATE ENTIDAD SET NOMBRE_ES=?,NOMBRE_EU=?,ACTIVA=?,ISKONTSUMOGEST=?,ISKONTSUMONET=?,ISOFERTAFORM=?,ISCONSULTASWEB=?,ISNACIONAL=?,OBSERVACIONES=?,TELEFONO=?,FAX=?,EMAIL=?,URL=?,USUARIO=?,PASSWORD=?,USUULTMOD=?,FECULTMOD=?,NORA_PAIS_ID=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,COD_ORG=?,TIPOORGANISMO=?,AMBITOGEOGRAFICO=?,CIF=?,COMPLE_DIREC=? WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getNombreEs(),
				entidad.getNombreEu(), entidad.getActiva(),
				entidad.getIskontsumogest(), entidad.getIskontsumonet(),
				entidad.getIsofertaform(), entidad.getIsconsultasweb(),
				entidad.getIsnacional(), entidad.getObservaciones(),
				entidad.getTelefono(), entidad.getFax(), entidad.getEmail(),
				entidad.getUrl(), entidad.getUsuario(), entidad.getPassword(),
				entidad.getUsuultmod(), entidad.getFecultmod(),
				entidad.getNoraPaisId(), entidad.getNombrePais(),
				entidad.getNoraProvinciaId(), entidad.getNombreProvincia(),
				entidad.getNoraMunicipioId(), entidad.getNombreMunicipio(),
				entidad.getNoraLocalidadId(), entidad.getNombreLocalidad(),
				entidad.getNoraCalleId(), entidad.getNombreCalle(),
				entidad.getNoraCpId(), entidad.getNombreCp(),
				entidad.getNoraPortalId(), entidad.getNombrePortal(),
				entidad.getCodOrg(), entidad.getTipoOrganismo(),
				entidad.getAmbitoGeografico(), entidad.getCif(),
				entidad.getCompleDirec(), entidad.getEntidadId());
		return entidad;
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad find(Entidad entidad) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.ISNACIONAL ISNACIONAL, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.COD_ORG CODORG, t1.COMPLE_DIREC,t1.TIPOORGANISMO,t1.AMBITOGEOGRAFICO,t1.CIF "
				+ "FROM ENTIDAD t1  " + "WHERE t1.ENTIDAD_ID = ?    ";
		return (Entidad) this.jdbcTemplate.queryForObject(query, this.rwMap,
				entidad.getEntidadId());
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad findSiguienteCodigoOrganismo(Entidad entidad) {
		String query = "select DECODE(max(cod_org),null,?,((substr(max(cod_org),1,3) || lpad((substr(max(cod_org),4,6)+1),3,'0')))) as COD_ORG from ENTIDAD where cod_org like ? and length(COD_ORG)=6";
		return (Entidad) this.jdbcTemplate.queryForObject(query,
				this.rwMapCodOrg, entidad.getCodOrg() + "001",
				entidad.getCodOrg() + "%");
	}

	/**
	 * Removes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return
	 */
	public void remove(Entidad entidad) {
		String query = "DELETE  FROM ENTIDAD WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getEntidadId());
	}

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Entidad> findAll(Entidad entidad, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.COD_ORG CODORG,t1.COMPLE_DIREC, t1.TIPOORGANISMO,t1.AMBITOGEOGRAFICO,t1.CIF "
						+ "FROM ENTIDAD t1 ");

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		where.append(" AND (");
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" t1.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" OR t1.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" OR t1.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" t1.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		where.append(" )");

		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(entidad.getCodOrg());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findByNombreCount(Entidad entidad) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ENTIDAD t1 ");
		if (entidad != null && entidad.getNombreEs() != null
				&& !"".equals(entidad.getNombreEs().trim())
				&& entidad.getNombreEu() != null
				&& !"".equals(entidad.getNombreEu().trim())) {
			where.append(" AND (UPPER(t1.NOMBRE_ES) = ? OR UPPER(t1.NOMBRE_EU) = ?)");
			params.add(entidad.getNombreEs().toUpperCase());
			params.add(entidad.getNombreEu().toUpperCase());
		}
		if (entidad != null && entidad.getIsnacional().equalsIgnoreCase("S")) {
			where.append(" AND ISNACIONAL = 'S'");
			if (entidad != null && entidad.getNoraProvinciaId() != null) {
				where.append(" AND t1.NORA_PROVINCIA_ID = ?");
				params.add(entidad.getNoraProvinciaId());
			}
			if (entidad != null && entidad.getNoraMunicipioId() != null) {
				where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
				params.add(entidad.getNoraMunicipioId());
			}
		} else if (entidad != null
				&& entidad.getIsnacional().equalsIgnoreCase("N")) {
			where.append(" AND ISNACIONAL = 'N'");
			if (entidad != null && entidad.getNoraPaisId() != null) {
				where.append(" AND t1.NORA_PAIS_ID = ?");
				params.add(entidad.getNoraPaisId());
			}

		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Entidad entidad) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ENTIDAD t1  ");
		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND t1.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" AND t1.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" AND t1.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(entidad.getCodOrg());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.ISNACIONAL ISNACIONAL,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.COD_ORG CODORG,t1.COMPLE_DIREC, t1.TIPOORGANISMO,t1.AMBITOGEOGRAFICO,t1.CIF "
						+ "FROM ENTIDAD t1 ");

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		where.append(" AND (");
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumogest().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumogest().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISKONTSUMOGEST IS NOT NULL");
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" UPPER(t1.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" t1.ISKONTSUMONET IS NOT NULL");
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" OR UPPER(t1.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsofertaform().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsofertaform().toUpperCase() + "%");
			}
			where.append(" OR t1.ISOFERTAFORM IS NOT NULL");
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" OR UPPER(t1.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsconsultasweb().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsconsultasweb().toUpperCase()
						+ "%");
			}
			where.append(" OR t1.ISCONSULTASWEB IS NOT NULL");
		}
		where.append(" )");

		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND UPPER(t1.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getPassword().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getPassword().toUpperCase() + "%");
			}
			where.append(" AND t1.PASSWORD IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFecultmod() + "%");
			} else {
				params.add("%" + entidad.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_ORG IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	public Entidad addEtiquetaEntidad(Entidad entidad) {
		String query = "INSERT INTO Y42B06T00 " + "( ENTIDAD_ID,ETIQUETA_ID) "
				+ " values (?, ?)";

		List<Etiqueta> auxiliarEtiqueta = entidad.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					etiqueta.getEtiquetaId());
		}
		return entidad;
	}

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeEtiquetaEntidad(Entidad entidad) {
		String query = "DELETE  FROM Y42B06T00 "
				+ " WHERE ENTIDAD_ID=? AND ETIQUETA_ID=?";
		List<Etiqueta> auxiliarEtiqueta = entidad.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					etiqueta.getEtiquetaId());
		}
	}

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad findEtiquetaEntidad(Entidad entidad, Etiqueta etiqueta,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ETIQUETA_ID = t2.ETIQUETA_ID AND t1.ENTIDAD_ID=?");

		params.add(entidad.getEntidadId());

		if (etiqueta.getEtiquetaId() != null) {
			where.append(" AND t2.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Etiqueta_id etiquetaId, t2.NOMBRE NOMBRE FROM Y42b06t00 t1,Y42B05T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Etiqueta> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Etiqueta>() {
					public Etiqueta mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Etiqueta(resultSet.getString("ETIQUETAID"),
								resultSet.getString("NOMBRE"), null, null);
					}
				}, params.toArray());
		entidad.setEtiquetas(listaHijo);
		return entidad;
	}

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findEtiquetaEntidadCount(Entidad entidad, Etiqueta etiqueta) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ETIQUETA_ID = t2.ETIQUETA_ID AND t1.ENTIDAD_ID=?");

		params.add(entidad.getEntidadId());

		if (etiqueta.getEtiquetaId() != null) {
			where.append(" AND t2.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b06t00 t1,Y42B05T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	public Entidad addGrupoEntidad(Entidad entidad) {
		String query = "INSERT INTO Y42B03T00 " + "( ENTIDAD_ID,GRUPO_ID) "
				+ " values (?, ?)";

		List<Grupo> auxiliarGrupo = entidad.getGrupos();
		Iterator<Grupo> it = auxiliarGrupo.iterator();
		while (it.hasNext()) {
			Grupo grupo = (Grupo) it.next();
			this.jdbcTemplate
					.update(query, entidad.getEntidadId(), grupo.getGrupoId()
							.equals(0) ? Y42bAgendaConstantes.GRUPO_RAIZ_ID
							: grupo.getGrupoId());
		}
		return entidad;
	}

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeGrupoEntidad(Entidad entidad) {
		String query = "DELETE  FROM Y42B03T00 "
				+ " WHERE ENTIDAD_ID=? AND GRUPO_ID=?";
		List<Grupo> auxiliarGrupo = entidad.getGrupos();
		Iterator<Grupo> it = auxiliarGrupo.iterator();
		while (it.hasNext()) {
			Grupo grupo = (Grupo) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					grupo.getGrupoId());
		}
	}

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad findGrupoEntidad(Entidad entidad, Grupo grupo,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.GRUPO_ID = t2.GRUPO_ID AND t1.ENTIDAD_ID=?");

		params.add(entidad.getEntidadId());

		if (grupo.getGrupoId() != null) {
			where.append(" AND t2.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo.getNivel() != null) {
			where.append(" AND t2.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo.getGrupoPadreId() != null) {
			where.append(" AND t2.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Grupo_id grupoId, t2.NIVEL NIVEL, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.grupo_Padre_Id GRUPOPADREID, t2.ACTIVA ACTIVA, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD FROM Y42b03t00 t1,Y42B00T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Grupo> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Grupo>() {
					public Grupo mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Grupo(resultSet.getString("GRUPOID"),
								resultSet.getBigDecimal("NIVEL"), resultSet
										.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("GRUPOPADREID"), resultSet
										.getString("ACTIVA"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), null);
					}
				}, params.toArray());
		entidad.setGrupos(listaHijo);
		return entidad;
	}

	/**
	 * Counts rows in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findGrupoEntidadCount(Entidad entidad, Grupo grupo) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.GRUPO_ID = t2.GRUPO_ID AND t1.ENTIDAD_ID=?");

		params.add(entidad.getEntidadId());

		if (grupo.getGrupoId() != null) {
			where.append(" AND t2.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo.getNivel() != null) {
			where.append(" AND t2.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo.getGrupoPadreId() != null) {
			where.append(" AND t2.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b03t00 t1,Y42B00T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	public Entidad addEntidadContacto(Entidad entidad) {
		String query = "INSERT INTO Y42B04T00 " + "( ENTIDAD_ID,CONTACTO_ID) "
				+ " values (?, ?)";

		List<Contacto> auxiliarContacto = entidad.getContactos();
		Iterator<Contacto> it = auxiliarContacto.iterator();
		while (it.hasNext()) {
			Contacto contacto = (Contacto) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					contacto.getContactoId());
		}
		return entidad;
	}

	/**
	 * Deletes a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeEntidadContacto(Entidad entidad) {
		String query = "DELETE  FROM Y42B04T00 "
				+ " WHERE ENTIDAD_ID=? AND CONTACTO_ID=?";
		List<Contacto> auxiliarContacto = entidad.getContactos();
		Iterator<Contacto> it = auxiliarContacto.iterator();
		while (it.hasNext()) {
			Contacto contacto = (Contacto) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					contacto.getContactoId());
		}
	}

	/**
	 * Find a single row in the findEntidadContacto Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad findEntidadContacto(Entidad entidad, Contacto contacto,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.CONTACTO_ID = t2.CONTACTO_ID AND t1.ENTIDAD_ID=?");

		params.add(entidad.getEntidadId());

		if (contacto.getContactoId() != null) {
			where.append(" AND t2.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}
		if (contacto.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto.getCargo() != null) {
			where.append(" AND t2.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Contacto_id contactoId, t2.NOMBRE NOMBRE, t2.CARGO CARGO, t2.TELEFONO TELEFONO, t2.FAX FAX, t2.EMAIL EMAIL, t2.URL URL, t2.ISNACIONAL ISNACIONAL, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD, t2.nombre_Pais NOMBREPAIS, t2.nora_Provincia_Id NORAPROVINCIAID, t2.nombre_Provincia NOMBREPROVINCIA, t2.nora_Municipio_Id NORAMUNICIPIOID, t2.nombre_Municipio NOMBREMUNICIPIO, t2.nora_Localidad_Id NORALOCALIDADID, t2.nombre_Localidad NOMBRELOCALIDAD, t2.nora_Calle_Id NORACALLEID, t2.nombre_Calle NOMBRECALLE, t2.nora_Cp_Id NORACPID, t2.nombre_Cp NOMBRECP, t2.nora_Portal_Id NORAPORTALID, t2.nombre_Portal NOMBREPORTAL, t2.nora_Pais_Id NORAPAISID FROM Y42b04t00 t1,Y42B02T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Contacto> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Contacto>() {
					public Contacto mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Contacto(resultSet.getString("CONTACTOID"),
								resultSet.getString("NOMBRE"), resultSet
										.getString("CARGO"), resultSet
										.getString("TELEFONO"), resultSet
										.getString("FAX"), resultSet
										.getString("EMAIL"), resultSet
										.getString("URL"), resultSet
										.getString("ISNACIONAL"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), resultSet
										.getString("NOMBREPAIS"), resultSet
										.getString("NORAPROVINCIAID"),
								resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"),
								resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"),
								resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet
										.getString("NOMBRECALLE"), resultSet
										.getString("NORACPID"), resultSet
										.getString("NOMBRECP"), resultSet
										.getString("NORAPORTALID"), resultSet
										.getString("NOMBREPORTAL"), resultSet
										.getString("NORAPAISID"), null);
					}
				}, params.toArray());
		entidad.setContactos(listaHijo);
		return entidad;
	}

	/**
	 * Counts rows in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findEntidadContactoCount(Entidad entidad, Contacto contacto) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.CONTACTO_ID = t2.CONTACTO_ID ");

		if (entidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (contacto.getContactoId() != null) {
			where.append(" AND t2.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}
		if (contacto.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto.getCargo() != null) {
			where.append(" AND t2.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b04t00 t1,Y42B02T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupos
	 *            List<Grupo>
	 * @param etiquetas
	 *            List<Etiqueta>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Entidad> advancedSearchAll(Entidad entidad, List<Grupo> grupos,
			List<Etiqueta> etiquetas, Date fechaDesde, Date fechaHasta,
			Pagination pagination, String tipoRB) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.COD_ORG CODORG, t1.COMPLE_DIREC,t1.TIPOORGANISMO,t1.AMBITOGEOGRAFICO,t1.CIF "
						+ "FROM ENTIDAD t1 ");

		if (entidad != null) {
			if (entidad.getEntidadId() != null) {
				where.append(" AND t1.ENTIDAD_ID = ?");
				params.add(entidad.getEntidadId());
			}
			if (entidad.getNombreEs() != null) {
				where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			if (entidad.getNombreEu() != null) {
				where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
				params.add("%" + entidad.getNombreEu().toUpperCase() + "%");
			}
			if (entidad.getActiva() != null) {
				where.append(" AND t1.ACTIVA = ?");
				params.add(entidad.getActiva());
			}
			if (!(entidad.getIskontsumogest() != null
					&& "N".equals(entidad.getIskontsumogest())
					&& entidad.getIsofertaform() != null
					&& "N".equals(entidad.getIsofertaform())
					&& entidad.getIsofertaform() != null
					&& "N".equals(entidad.getIskontsumonet())
					&& entidad.getIsconsultasweb() != null && "N"
					.equals(entidad.getIsconsultasweb()))) {
				where.append(" AND (");
				if (entidad.getIskontsumogest() != null
						&& "S".equals(entidad.getIskontsumogest())) {
					where.append(" t1.ISKONTSUMOGEST = ?");
					params.add(entidad.getIskontsumogest());
				}
				if (entidad.getIskontsumonet() != null
						&& "S".equals(entidad.getIskontsumonet())) {
					if (entidad.getIskontsumogest() != null
							&& "S".equals(entidad.getIskontsumogest())) {
						if (tipoRB
								.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
							where.append(" OR t1.ISKONTSUMONET = ?");
						} else {
							where.append(" AND t1.ISKONTSUMONET = ?");
						}
						params.add(entidad.getIskontsumonet());
					} else {
						where.append(" t1.ISKONTSUMONET = ?");
						params.add(entidad.getIskontsumonet());
					}
				}
				if (entidad.getIsofertaform() != null
						&& "S".equals(entidad.getIsofertaform())) {
					if (entidad.getIskontsumogest() != null
							&& "S".equals(entidad.getIskontsumogest())) {

						if (tipoRB
								.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
							where.append(" OR t1.ISOFERTAFORM = ?");
						} else {
							where.append(" AND t1.ISOFERTAFORM = ?");
						}
						params.add(entidad.getIsofertaform());
					} else {
						if (entidad.getIskontsumonet() != null
								&& "S".equals(entidad.getIskontsumonet())) {

							if (tipoRB
									.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
								where.append(" OR t1.ISOFERTAFORM = ?");
							} else {
								where.append(" AND t1.ISOFERTAFORM = ?");
							}

							params.add(entidad.getIsofertaform());
						} else {
							where.append(" t1.ISOFERTAFORM = ?");
							params.add(entidad.getIsofertaform());
						}
					}
				}
				if (entidad.getIsconsultasweb() != null
						&& "S".equals(entidad.getIsconsultasweb())) {
					if (entidad.getIskontsumogest() != null
							&& "S".equals(entidad.getIskontsumogest())) {
						if (entidad.getIsofertaform() != null
								&& "S".equals(entidad.getIsofertaform())) {

							if (tipoRB
									.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
								where.append(" OR t1.ISCONSULTASWEB = ?");
							} else {
								where.append(" AND t1.ISCONSULTASWEB = ?");
							}

							params.add(entidad.getIsconsultasweb());
						}
					} else {
						if (entidad.getIskontsumonet() != null
								&& "S".equals(entidad.getIskontsumonet())) {
							if (tipoRB
									.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
								where.append(" OR t1.ISCONSULTASWEB = ?");
							} else {
								where.append(" AND t1.ISCONSULTASWEB = ?");
							}
							params.add(entidad.getIsconsultasweb());
						} else {
							if (entidad.getIsofertaform() != null
									&& "S".equals(entidad.getIsofertaform())) {

								if (tipoRB
										.equalsIgnoreCase(Y42bConstantesTbEntidades.TIPORB_CUALQUIERA)) {
									where.append(" OR t1.ISCONSULTASWEB = ?");
								} else {
									where.append(" AND t1.ISCONSULTASWEB = ?");
								}
								params.add(entidad.getIsconsultasweb());

							} else {
								where.append(" t1.ISCONSULTASWEB = ?");
								params.add(entidad.getIsconsultasweb());

							}
						}
					}
				}
				where.append(" )");
			}

			if (entidad.getObservaciones() != null) {
				where.append(" AND t1.OBSERVACIONES = ?");
				params.add(entidad.getObservaciones());
			}
			if (entidad.getTelefono() != null) {
				where.append(" AND t1.TELEFONO = ?");
				params.add(entidad.getTelefono());
			}
			if (entidad.getFax() != null) {
				where.append(" AND t1.FAX = ?");
				params.add(entidad.getFax());
			}
			if (entidad.getEmail() != null) {
				where.append(" AND t1.EMAIL = ?");
				params.add(entidad.getEmail());
			}
			if (entidad.getUrl() != null) {
				where.append(" AND t1.URL = ?");
				params.add(entidad.getUrl());
			}
			if (entidad.getUsuario() != null) {
				where.append(" AND t1.USUARIO = ?");
				params.add(entidad.getUsuario());
			}
			if (entidad.getPassword() != null) {
				where.append(" AND t1.PASSWORD = ?");
				params.add(entidad.getPassword());
			}
			if (entidad.getIsnacional() != null) {
				where.append(" AND t1.ISNACIONAL = ?");
				params.add(entidad.getIsnacional());
			}
			if (entidad.getNoraPaisId() != null) {
				where.append(" AND t1.NORA_PAIS_ID = ?");
				params.add(entidad.getNoraPaisId());
			}
			if (entidad.getNombrePais() != null) {
				where.append(" AND t1.NOMBRE_PAIS = ?");
				params.add(entidad.getNombrePais());
			}
			if (entidad.getNoraProvinciaId() != null) {
				where.append(" AND t1.NORA_PROVINCIA_ID = ?");
				params.add(entidad.getNoraProvinciaId());
			}
			if (entidad.getNombreProvincia() != null) {
				where.append(" AND t1.NOMBRE_PROVINCIA = ?");
				params.add(entidad.getNombreProvincia());
			}
			if (entidad.getNoraMunicipioId() != null) {
				where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
				params.add(entidad.getNoraMunicipioId());
			}
			if (entidad.getNombreMunicipio() != null) {
				where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
				params.add(entidad.getNombreMunicipio());
			}
			if (entidad.getNoraLocalidadId() != null) {
				where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
				params.add(entidad.getNoraLocalidadId());
			}
			if (entidad.getNombreLocalidad() != null) {
				where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
				params.add(entidad.getNombreLocalidad());
			}
			if (entidad.getNoraCalleId() != null) {
				where.append(" AND t1.NORA_CALLE_ID = ?");
				params.add(entidad.getNoraCalleId());
			}
			if (entidad.getNombreCalle() != null) {
				where.append(" AND t1.NOMBRE_CALLE = ?");
				params.add(entidad.getNombreCalle());
			}
			if (entidad.getNoraCpId() != null) {
				where.append(" AND t1.NORA_CP_ID = ?");
				params.add(entidad.getNoraCpId());
			}
			if (entidad.getNombreCp() != null) {
				where.append(" AND t1.NOMBRE_CP = ?");
				params.add(entidad.getNombreCp());
			}
			if (entidad.getNoraPortalId() != null) {
				where.append(" AND t1.NORA_PORTAL_ID = ?");
				params.add(entidad.getNoraPortalId());
			}
			if (entidad.getNombrePortal() != null) {
				where.append(" AND t1.NOMBRE_PORTAL = ?");
				params.add(entidad.getNombrePortal());
			}
			if (entidad.getUsuultmod() != null) {
				where.append(" AND t1.USUULTMOD = ?");
				params.add(entidad.getUsuultmod());
			}

			if (entidad.getCodOrg() != null) {
				where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
				params.add("%" + entidad.getCodOrg().toUpperCase() + "%");

			}

		}

		/*
		 * Fechas desde hasta del ultima modificación del registro.
		 */
		if (fechaDesde != null) {
			where.append(" AND t1.FECULTMOD >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null) {
			where.append(" AND t1.FECULTMOD <= ?");
			params.add(fechaHasta);
		}

		/*
		 * Colección de grupos a los que pueden pertenecer las entidades
		 */
		if (grupos != null && grupos.size() > 0) {

			where.append(" AND t1.ENTIDAD_ID IN (SELECT ENTIDAD_ID FROM GRUPO_ENTIDAD WHERE ");
			boolean firstElement = true;

			for (Grupo g : grupos) {

				if (firstElement) {

					where.append("GRUPO_ID = ?");
					params.add(g.getGrupoId());
					firstElement = false;

				} else {

					where.append(" OR GRUPO_ID = ?");
					params.add(g.getGrupoId());
				}
			}

			where.append(") ");
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las entidades
		 */
		if (etiquetas != null && etiquetas.size() > 0) {

			where.append(" AND t1.ENTIDAD_ID IN (SELECT ENTIDAD_ID FROM ETIQUETA_ENTIDAD WHERE ");
			boolean firstElement = true;

			for (Etiqueta e : etiquetas) {

				if (firstElement) {

					where.append("ETIQUETA_ID = ?");
					params.add(e.getEtiquetaId());
					firstElement = false;

				} else {

					where.append(" OR ETIQUETA_ID = ?");
					params.add(e.getEtiquetaId());
				}
			}

			where.append(") ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Deletes all rows from GrupoEntidad table whith certain entidad id.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeAllGruposEntidad(Entidad entidad) {
		String query = "DELETE FROM Y42B03T00 " + " WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getEntidadId());
	}

	/**
	 * Deletes all rows from EtiquetaEntidad table whith certain entidad id.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeAllEtiquetasEntidad(Entidad entidad) {
		String query = "DELETE FROM Y42B06T00 " + " WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getEntidadId());
	}

}
