package com.ejie.y42b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;
import com.ejie.y42b.model.Grupo;

/**
 * * EntidadDao  
 * 
 *  
 */

public interface EntidadDao {

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad add(Entidad entidad);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad update(Entidad entidad);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad find(Entidad entidad);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findSiguienteCodigoOrganismo(Entidad entidad);

	/**
	 * Deletes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void remove(Entidad entidad);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Entidad> findAll(Entidad entidad, Pagination pagination);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return List
	 */
	Long findAllCount(Entidad entidad);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return List
	 */
	Long findByNombreCount(Entidad entidad);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addEtiquetaEntidad(Entidad entidad);

	/**
	 * Deletes a single row in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void removeEtiquetaEntidad(Entidad entidad);

	/**
	 * Find a single row in the findEtiquetaEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findEtiquetaEntidad(Entidad entidad, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows rows in the EtiquetaEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	Long findEtiquetaEntidadCount(Entidad entidad, Etiqueta etiqueta);

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addGrupoEntidad(Entidad entidad);

	/**
	 * Deletes a single row in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void removeGrupoEntidad(Entidad entidad);

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findGrupoEntidad(Entidad entidad, Grupo grupo, Pagination pagination);

	/**
	 * Counts rows rows in the GrupoEntidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	Long findGrupoEntidadCount(Entidad entidad, Grupo grupo);

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad addEntidadContacto(Entidad entidad);

	/**
	 * Deletes a single row in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void removeEntidadContacto(Entidad entidad);

	/**
	 * Find a single row in the findEntidadContacto Many To Many relationship.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findEntidadContacto(Entidad entidad, Contacto contacto,
			Pagination pagination);

	/**
	 * Counts rows rows in the EntidadContacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	Long findEntidadContactoCount(Entidad entidad, Contacto contacto);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param grupos
	 *            List<Grupo>
	 * @param etiquetas
	 *            Lista<Label>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Entidad> advancedSearchAll(Entidad entidad, List<Grupo> grupos,
			List<Etiqueta> etiquetas, Date fechaDesde, Date fechaHasta,
			Pagination pagination, String tiporb);

	/**
	 * Deletes all rows in the GruposEntidad table for certain entidad.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeAllGruposEntidad(Entidad entidad);

	/**
	 * Deletes all rows in the EtiquetaEntidad table for certain entidad.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	public void removeAllEtiquetasEntidad(Entidad entidad);
}
