package com.ejie.y42b.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.DestComunicacion;

/**
 * * DestComunicacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DestComunicacionDaoImpl implements DestComunicacionDao {
	private static final Logger logger = LoggerFactory
			.getLogger(DestComunicacionDaoImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DestComunicacion table.
	 * 
	 * @param destcomunicacion
	 *            Pagination
	 * @return DestComunicacion
	 */
	public DestComunicacion add(DestComunicacion destcomunicacion) {

		String query = "INSERT INTO DEST_COMUNICACION( M5COOR,M5COCOMU,M5FELEIDO)"
				+ "VALUES (?,?,?)";

		Object getOrganismoCodOrgAux = null;
		if (destcomunicacion.getOrganismo() != null
				&& destcomunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = destcomunicacion.getOrganismo().getCodOrg();
		}

		Object ComunicacionM4cocomuAux = null;
		if (destcomunicacion.getComunicacion() != null
				&& destcomunicacion.getComunicacion().getM4cocomu() != null) {
			ComunicacionM4cocomuAux = destcomunicacion.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate.update(query, getOrganismoCodOrgAux,
				ComunicacionM4cocomuAux, destcomunicacion.getM5feleido());
		return destcomunicacion;
	}

}
