package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;

/**
 * * ContactoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ContactoDaoImpl implements ContactoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Contacto> rwMap = new RowMapper<Contacto>() {
		public Contacto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Contacto(resultSet.getString("CONTACTOID"),
					resultSet.getString("NOMBRE"),
					resultSet.getString("CARGO"),
					resultSet.getString("TELEFONO"),
					resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"),
					resultSet.getString("ISNACIONAL"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("COMPLE_DIREC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	public Contacto add(Contacto contacto) {

		String query = "INSERT INTO CONTACTO( CONTACTO_ID,NOMBRE,CARGO,TELEFONO,FAX,EMAIL,URL,ISNACIONAL,USUULTMOD,FECULTMOD,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,NORA_PAIS_ID,COMPLE_DIREC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, contacto.getContactoId(),
				contacto.getNombre(), contacto.getCargo(),
				contacto.getTelefono(), contacto.getFax(), contacto.getEmail(),
				contacto.getUrl(), contacto.getIsnacional(),
				contacto.getUsuultmod(), contacto.getFecultmod(),
				contacto.getNombrePais(), contacto.getNoraProvinciaId(),
				contacto.getNombreProvincia(), contacto.getNoraMunicipioId(),
				contacto.getNombreMunicipio(), contacto.getNoraLocalidadId(),
				contacto.getNombreLocalidad(), contacto.getNoraCalleId(),
				contacto.getNombreCalle(), contacto.getNoraCpId(),
				contacto.getNombreCp(), contacto.getNoraPortalId(),
				contacto.getNombrePortal(), contacto.getNoraPaisId(),
				contacto.getCompleDirec());
		return contacto;
	}

	/**
	 * Updates a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	public Contacto update(Contacto contacto) {
		String query = "UPDATE CONTACTO SET NOMBRE=?,CARGO=?,TELEFONO=?,FAX=?,EMAIL=?,URL=?,ISNACIONAL=?,USUULTMOD=?,FECULTMOD=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,NORA_PAIS_ID=?,COMPLE_DIREC=? WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getNombre(),
				contacto.getCargo(), contacto.getTelefono(), contacto.getFax(),
				contacto.getEmail(), contacto.getUrl(),
				contacto.getIsnacional(), contacto.getUsuultmod(),
				contacto.getFecultmod(), contacto.getNombrePais(),
				contacto.getNoraProvinciaId(), contacto.getNombreProvincia(),
				contacto.getNoraMunicipioId(), contacto.getNombreMunicipio(),
				contacto.getNoraLocalidadId(), contacto.getNombreLocalidad(),
				contacto.getNoraCalleId(), contacto.getNombreCalle(),
				contacto.getNoraCpId(), contacto.getNombreCp(),
				contacto.getNoraPortalId(), contacto.getNombrePortal(),
				contacto.getNoraPaisId(), contacto.getCompleDirec(),
				contacto.getContactoId());
		return contacto;
	}

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	@Transactional(readOnly = true)
	public Contacto find(Contacto contacto) {
		String query = "SELECT t1.CONTACTO_ID CONTACTOID, t1.NOMBRE NOMBRE, t1.CARGO CARGO, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.ISNACIONAL ISNACIONAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NORA_PAIS_ID NORAPAISID, t1.COMPLE_DIREC "
				+ "FROM CONTACTO t1  " + "WHERE t1.CONTACTO_ID = ?    ";
		return (Contacto) this.jdbcTemplate.queryForObject(query, this.rwMap,
				contacto.getContactoId());
	}

	/**
	 * Removes a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return
	 */
	public void remove(Contacto contacto) {
		String query = "DELETE  FROM CONTACTO WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getContactoId());
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> findAll(Contacto contacto, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NORA_PAIS_ID NORAPAISID, t1.COMPLE_DIREC "
						+ "FROM CONTACTO t1 ");

		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}

		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND t1.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Contacto contacto) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  CONTACTO t1  ");
		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}
		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND t1.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Contacto table using like.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> findAllLike(Contacto contacto, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NORA_PAIS_ID NORAPAISID, t1.COMPLE_DIREC "
						+ "FROM CONTACTO t1 ");

		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND UPPER(t1.CONTACTO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getContactoId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getContactoId().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTACTO_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND UPPER(t1.CARGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getCargo().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getCargo().toUpperCase() + "%");
			}
			where.append(" AND t1.CARGO IS NOT NULL");
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getFecultmod() + "%");
			} else {
				params.add("%" + contacto.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	public Contacto addEntidadContacto(Contacto contacto) {
		String query = "INSERT INTO Y42B04T00 " + "(ENTIDAD_ID, CONTACTO_ID) "
				+ " values (?, ?)";

		List<Entidad> auxiliarEntidad = contacto.getEntidads();
		Iterator<Entidad> it = auxiliarEntidad.iterator();
		while (it.hasNext()) {
			Entidad entidad = (Entidad) it.next();
			this.jdbcTemplate.update(query, entidad.getEntidadId(),
					contacto.getContactoId());
		}
		return contacto;
	}

	/**
	 * Deletes a single row in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	public void removeEntidadContacto(Contacto contacto) {
		/*
		 * String query = "DELETE  FROM Y42B04T00 " +
		 * " WHERE CONTACTO_ID=? AND ENTIDAD_ID=?"; List<Entidad>
		 * auxiliarEntidad = contacto.getEntidads(); Iterator<Entidad> it =
		 * auxiliarEntidad.iterator(); while (it.hasNext()) { Entidad entidad =
		 * (Entidad) it.next(); this.jdbcTemplate.update(query,
		 * contacto.getContactoId(), entidad.getEntidadId()); }
		 */

		String query = "DELETE  FROM Y42B04T00 WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getContactoId());
	}

	/**
	 * Find a single row in the findEntidadContacto Many To Many relationship.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Contacto
	 */
	@Transactional(readOnly = true)
	public Contacto findEntidadContacto(Contacto contacto, Entidad entidad,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.CONTACTO_ID=?");

		params.add(contacto.getContactoId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Entidad_id entidadId, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.ACTIVA ACTIVA, t2.ISKONTSUMOGEST ISKONTSUMOGEST, t2.ISKONTSUMONET ISKONTSUMONET, t2.ISOFERTAFORM ISOFERTAFORM, t2.ISCONSULTASWEB ISCONSULTASWEB, t2.COD_ORG CODORG, t2.ISNACIONAL ISNACIONAL, t2.OBSERVACIONES OBSERVACIONES, t2.TELEFONO TELEFONO, t2.FAX FAX, t2.EMAIL EMAIL, t2.URL URL, t2.USUARIO USUARIO, t2.PASSWORD PASSWORD, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD, t2.COMPLE_DIREC COMPLE_DIREC, t2.nora_Pais_Id NORAPAISID, t2.nombre_Pais NOMBREPAIS, t2.nora_Provincia_Id NORAPROVINCIAID, t2.nombre_Provincia NOMBREPROVINCIA, t2.nora_Municipio_Id NORAMUNICIPIOID, t2.nombre_Municipio NOMBREMUNICIPIO, t2.nora_Localidad_Id NORALOCALIDADID, t2.nombre_Localidad NOMBRELOCALIDAD, t2.nora_Calle_Id NORACALLEID, t2.nombre_Calle NOMBRECALLE, t2.nora_Cp_Id NORACPID, t2.nombre_Cp NOMBRECP, t2.nora_Portal_Id NORAPORTALID, t2.nombre_Portal NOMBREPORTAL FROM Y42b04t00 t1,Y42B01T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Entidad> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Entidad>() {
					public Entidad mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						// public Entidad(String entidadId, String nombreEs,
						// String nombreEu, String activa,
						// String iskontsumogest, String iskontsumonet, String
						// isofertaform, String isconsultasweb,
						// String isnacional, String observaciones, String
						// telefono, String fax, String email,
						// String url, String usuario, String password,
						// String usuultmod, Date fecultmod, String noraPaisId,
						// String nombrePais,
						// String noraProvinciaId, String nombreProvincia,
						// String noraMunicipioId, String nombreMunicipio,
						// String noraLocalidadId,
						// String nombreLocalidad, String noraCalleId, String
						// nombreCalle, String noraCpId, String nombreCp,
						// String noraPortalId, String nombrePortal, String
						// codOrg, List<Etiqueta> etiquetas, List<Grupo> grupos,
						// List<Contacto> contactos) {

						return new Entidad(resultSet.getString("ENTIDADID"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("ACTIVA"), resultSet
										.getString("ISKONTSUMOGEST"), resultSet
										.getString("ISKONTSUMONET"), resultSet
										.getString("ISOFERTAFORM"), resultSet
										.getString("ISCONSULTASWEB"), resultSet
										.getString("ISNACIONAL"), resultSet
										.getString("OBSERVACIONES"), resultSet
										.getString("TELEFONO"), resultSet
										.getString("FAX"), resultSet
										.getString("EMAIL"), resultSet
										.getString("URL"), resultSet
										.getString("USUARIO"), resultSet
										.getString("PASSWORD"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), resultSet
										.getString("NORAPAISID"), resultSet
										.getString("NOMBREPAIS"), resultSet
										.getString("NORAPROVINCIAID"),
								resultSet.getString("NOMBREPROVINCIA"),
								resultSet.getString("NORAMUNICIPIOID"),
								resultSet.getString("NOMBREMUNICIPIO"),
								resultSet.getString("NORALOCALIDADID"),
								resultSet.getString("NOMBRELOCALIDAD"),
								resultSet.getString("NORACALLEID"), resultSet
										.getString("NOMBRECALLE"), resultSet
										.getString("NORACPID"), resultSet
										.getString("NOMBRECP"), resultSet
										.getString("NORAPORTALID"), resultSet
										.getString("NOMBREPORTAL"), resultSet
										.getString("CODORG"), resultSet
										.getString("COMPLE_DIREC"), null, null,
								null);
					}
				}, params.toArray());
		contacto.setEntidads(listaHijo);
		return contacto;
	}

	/**
	 * Counts rows in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findEntidadContactoCount(Contacto contacto, Entidad entidad) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t1.CONTACTO_ID=?");

		params.add(contacto.getContactoId());

		if (entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad.getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad.getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad.getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad.getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad.getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad.getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad.getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad.getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad.getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad.getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad.getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad.getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad.getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad.getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad.getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad.getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad.getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad.getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad.getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad.getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad.getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad.getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad.getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad.getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad.getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad.getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b04t00 t1,Y42B01T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param entidades
	 *            Entidad
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> advancedSearch(Contacto contacto,
			List<Entidad> entidades, List<Etiqueta> etiquetas, Date fechaDesde,
			Date fechaHasta, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD, t1.COMPLE_DIREC "
						+ "FROM CONTACTO t1 ");

		if (contacto != null) {
			if (contacto.getContactoId() != null) {
				where.append(" AND t1.CONTACTO_ID = ?");
				params.add(contacto.getContactoId());
			}
			if (contacto.getNombre() != null) {
				where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
				params.add("%" + contacto.getNombre().toUpperCase() + "%");
			}
			if (contacto.getCargo() != null) {
				where.append(" AND t1.CARGO = ?");
				params.add(contacto.getCargo());
			}
			if (contacto.getTelefono() != null) {
				where.append(" AND t1.TELEFONO = ?");
				params.add(contacto.getTelefono());
			}
			if (contacto.getFax() != null) {
				where.append(" AND t1.FAX = ?");
				params.add(contacto.getFax());
			}
			if (contacto.getEmail() != null) {
				where.append(" AND t1.EMAIL = ?");
				params.add(contacto.getEmail());
			}
			if (contacto.getUrl() != null) {
				where.append(" AND t1.URL = ?");
				params.add(contacto.getUrl());
			}
			if (contacto.getIsnacional() != null) {
				where.append(" AND t1.ISNACIONAL = ?");
				params.add(contacto.getIsnacional());
			}
			if (contacto.getNoraPaisId() != null) {
				where.append(" AND t1.NORA_PAIS_ID = ?");
				params.add(contacto.getNoraPaisId());
			}
			if (contacto.getNombrePais() != null) {
				where.append(" AND t1.NOMBRE_PAIS = ?");
				params.add(contacto.getNombrePais());
			}
			if (contacto.getNoraProvinciaId() != null) {
				where.append(" AND t1.NORA_PROVINCIA_ID = ?");
				params.add(contacto.getNoraProvinciaId());
			}
			if (contacto.getNombreProvincia() != null) {
				where.append(" AND t1.NOMBRE_PROVINCIA = ?");
				params.add(contacto.getNombreProvincia());
			}
			if (contacto.getNoraMunicipioId() != null) {
				where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
				params.add(contacto.getNoraMunicipioId());
			}
			if (contacto.getNombreMunicipio() != null) {
				where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
				params.add(contacto.getNombreMunicipio());
			}
			if (contacto.getNoraLocalidadId() != null) {
				where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
				params.add(contacto.getNoraLocalidadId());
			}
			if (contacto.getNombreLocalidad() != null) {
				where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
				params.add("%" + contacto.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			if (contacto.getNoraCalleId() != null) {
				where.append(" AND t1.NORA_CALLE_ID = ?");
				params.add(contacto.getNoraCalleId());
			}
			if (contacto.getNombreCalle() != null) {
				where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
				params.add("%" + contacto.getNombreCalle().toUpperCase() + "%");
			}
			if (contacto.getNoraCpId() != null) {
				where.append(" AND t1.NORA_CP_ID = ?");
				params.add(contacto.getNoraCpId());
			}
			if (contacto.getNombreCp() != null) {
				where.append(" AND t1.NOMBRE_CP = ?");
				params.add(contacto.getNombreCp());
			}
			if (contacto.getNoraPortalId() != null) {
				where.append(" AND t1.NORA_PORTAL_ID = ?");
				params.add(contacto.getNoraPortalId());
			}
			if (contacto.getNombrePortal() != null) {
				where.append(" AND t1.NOMBRE_PORTAL = ?");
				params.add(contacto.getNombrePortal());
			}
			if (contacto.getUsuultmod() != null) {
				where.append(" AND t1.USUULTMOD = ?");
				params.add(contacto.getUsuultmod());
			}
			if (contacto.getFecultmod() != null) {
				where.append(" AND t1.FECULTMOD = ?");
				params.add(contacto.getFecultmod());
			}
		}
		/*
		 * Fechas desde hasta del ultima modificaciÃ³n del registro.
		 */
		if (fechaDesde != null) {
			where.append(" AND t1.FECULTMOD >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null) {
			where.append(" AND t1.FECULTMOD <= ?");
			params.add(fechaHasta);
		}
		/*
		 * ColecciÃ³n de entidades a los que pueden pertenecer los contactos
		 */
		if (entidades != null && entidades.size() > 0) {

			where.append(" AND t1.CONTACTO_ID IN (SELECT CONTACTO_ID FROM ENTIDAD_CONTACTO WHERE ");
			boolean firstElement = true;

			for (Entidad e : entidades) {

				if (firstElement) {

					where.append("ENTIDAD_ID = ?");
					params.add(e.getEntidadId());
					firstElement = false;

				} else {

					where.append(" OR ENTIDAD_ID = ?");
					params.add(e.getEntidadId());
				}
			}

			where.append(") ");
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las entidades
		 */
		if (etiquetas != null && etiquetas.size() > 0) {

			where.append(" AND t1.CONTACTO_ID IN (SELECT CONTACTO_ID FROM ETIQUETA_CONTACTO WHERE ");
			boolean firstElement = true;

			for (Etiqueta e : etiquetas) {

				if (firstElement) {

					where.append("ETIQUETA_ID = ?");
					params.add(e.getEtiquetaId());
					firstElement = false;

				} else {

					where.append(" OR ETIQUETA_ID = ?");
					params.add(e.getEtiquetaId());
				}
			}

			where.append(") ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Find a single row in the findEtiquetaContacto Many To Many relationship.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Contacto
	 */
	@Transactional(readOnly = true)
	public Contacto findEtiquetaContacto(Contacto contacto, Etiqueta etiqueta,
			Pagination pagination) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ETIQUETA_ID = t2.ETIQUETA_ID AND t1.CONTACTO_ID=?");

		params.add(contacto.getContactoId());

		if (etiqueta.getEtiquetaId() != null) {
			where.append(" AND t2.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuilder query = new StringBuilder(
				"SELECT t2.Etiqueta_id etiquetaId, t2.NOMBRE NOMBRE FROM Y42b10t00 t1,Y42B05T00 t2  ");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		List<Etiqueta> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Etiqueta>() {
					public Etiqueta mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Etiqueta(resultSet.getString("ETIQUETAID"),
								resultSet.getString("NOMBRE"), null, null);
					}
				}, params.toArray());
		contacto.setEtiquetas(listaHijo);
		return contacto;
	}

	/**
	 * Counts rows in the EtiquetaEntidad table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findEtiquetaContactoCount(Contacto contacto, Etiqueta etiqueta) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ETIQUETA_ID = t2.ETIQUETA_ID AND t1.CONTACTO_ID=?");

		params.add(contacto.getContactoId());

		if (etiqueta.getEtiquetaId() != null) {
			where.append(" AND t2.ETIQUETA_ID = ?");
			params.add(etiqueta.getEtiquetaId());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuilder query = new StringBuilder(
				"SELECT count(1) FROM Y42b10t00 t1,Y42B05T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	public Contacto addEtiquetaContacto(Contacto contacto) {
		String query = "INSERT INTO Y42B10T00 " + "( CONTACTO_ID,ETIQUETA_ID) "
				+ " values (?, ?)";

		List<Etiqueta> auxiliarEtiqueta = contacto.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, contacto.getContactoId(),
					etiqueta.getEtiquetaId());
		}
		return contacto;
	}

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	public void removeEtiquetaContacto(Contacto contacto) {
		String query = "DELETE  FROM Y42B10T00 "
				+ " WHERE CONTACTO_ID=? AND ETIQUETA_ID=?";
		List<Etiqueta> auxiliarEtiqueta = contacto.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, contacto.getContactoId(),
					etiqueta.getEtiquetaId());
		}
	}

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	public void removeAllEtiquetasContacto(Contacto contacto) {
		String query = "DELETE  FROM Y42B10T00 " + " WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getContactoId());
	}

}
