package com.ejie.y42b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Contacto;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.Etiqueta;

/**
 * * ContactoDao  
 * 
 *  
 */

public interface ContactoDao {

	/**
	 * Inserts a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto add(Contacto contacto);

	/**
	 * Updates a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto update(Contacto contacto);

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto find(Contacto contacto);

	/**
	 * Deletes a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	void remove(Contacto contacto);

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Contacto> findAll(Contacto contacto, Pagination pagination);

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return List
	 */
	Long findAllCount(Contacto contacto);

	/**
	 * Finds rows in the Contacto table using like.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Contacto> findAllLike(Contacto contacto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto addEntidadContacto(Contacto contacto);

	/**
	 * Deletes a single row in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	void removeEntidadContacto(Contacto contacto);

	/**
	 * Find a single row in the findEntidadContacto Many To Many relationship.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return Contacto
	 */
	Contacto findEntidadContacto(Contacto contacto, Entidad entidad,
			Pagination pagination);

	/**
	 * Counts rows rows in the EntidadContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findEntidadContactoCount(Contacto contacto, Entidad entidad);

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param entidades
	 *            List<Entidad>
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List Contactos
	 */
	public List<Contacto> advancedSearch(Contacto contacto,
			List<Entidad> entidades, List<Etiqueta> etiquetas, Date fechaDesde,
			Date fechaHasta, Pagination pagination);

	/**
	 * Find a single row in the findEtiquetaContacto Many To Many relationship.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Contacto
	 */
	Contacto findEtiquetaContacto(Contacto contacto, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows rows in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	Long findEtiquetaContactoCount(Contacto contacto, Etiqueta etiqueta);

	/**
	 * Inserts a single row in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto addEtiquetaContacto(Contacto contacto);

	/**
	 * Deletes a single row in the EtiquetaContacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	void removeEtiquetaContacto(Contacto contacto);

	/**
	 * Delete every row in the EtiquetaContacto table for that contactoId.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	void removeAllEtiquetasContacto(Contacto contacto);

}
