package com.ejie.y42b.dao;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y42b.model.ComunicacionFile;
import com.ejie.y42b.utils.jdbc.Y42bJdbcUtils;

/**
 * * ComunicacionFileDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionFileDaoImpl implements ComunicacionFileDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private DataSource dataSource;

	// private static final Logger logger = LoggerFactory
	// .getLogger(ComunicacionFileDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
		this.dataSource = dataSource;
	}

	/**
	 * Inserts a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return ComunicacionFile
	 */
	public ComunicacionFile add(ComunicacionFile comunicacionfile) {

		String query = "INSERT INTO COMUNICACION_FILE( M3COFILE,M3COCOMU,M3NOFILE,M3DATAFILE,M3SIZEFILE,M3TEDESFILE,M3CONTENTTYPEFILE)"
				+ "VALUES (?,?,?,?,?,?,?)";

		Object getComunicacionM4cocomuAux = null;
		if (comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			getComunicacionM4cocomuAux = comunicacionfile.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate.update(query, comunicacionfile.getM3cofile(),
				getComunicacionM4cocomuAux, comunicacionfile.getM3nofile(),
				Y42bJdbcUtils.ConvertBlobToByte(comunicacionfile
						.getM3datafile()), comunicacionfile.getM3sizefile(),
				comunicacionfile.getM3tedesfile(), comunicacionfile
						.getM3contenttypefile());
		return comunicacionfile;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21M3T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
