package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.Comunicacion;
import com.ejie.y42b.model.Entidad;
import com.ejie.y42b.model.TipoComunicacion;

/**
 * * ComunicacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionDaoImpl implements ComunicacionDao {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionDaoImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;

	private RowMapper<Comunicacion> rwMapDetalle = new RowMapper<Comunicacion>() {
		public Comunicacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Comunicacion(resultSet.getLong("M4COCOMU"), new Entidad(
					resultSet.getString("OrganismoENTIDADID"),
					resultSet.getString("OrganismoCODORG")),
					resultSet.getDate("M4FEENV"), resultSet.getDate("M4FECAD"),
					resultSet.getString("M4NOREMI"),
					resultSet.getString("M4TESUBJECT"),
					resultSet.getString("M4TECOMU"),
					resultSet.getLong("M4NUDEST"),
					resultSet.getLong("M4NUFILADJ"),
					resultSet.getInt("M4INCOMACT"),
					resultSet.getInt("M4INCOMBL"),
					resultSet.getString("M4ENVIOID"), new TipoComunicacion(
							resultSet.getInt("TipoComunicacionM6CODIGO"),
							resultSet.getString("TipoComunicacionM6NOTIPO"),
							resultSet.getString("TipoComunicacionM6TETIPO"),
							resultSet.getString("TipoComunicacionM6NOTIPOE"),
							resultSet.getString("TipoComunicacionM6NOTIPOI"),
							resultSet.getString("TipoComunicacionM6NOTIPOF"),
							resultSet.getString("TipoComunicacionM6NOTIPOA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return Comunicacion
	 */
	public Comunicacion add(Comunicacion comunicacion) {

		String query = "INSERT INTO COMUNICACION( M4COCOMU,M4COTIPO,M4COCOOR,M4FEENV,M4FECAD,M4NOREMI,M4TESUBJECT,M4TECOMU,M4NUDEST,M4NUFILADJ,M4INCOMACT,M4INCOMBL,M4ENVIOID)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTipoComunicacionM6codigoAux = null;
		if (comunicacion.getTipoComunicacion() != null
				&& comunicacion.getTipoComunicacion().getM6codigo() != null) {
			getTipoComunicacionM6codigoAux = comunicacion.getTipoComunicacion()
					.getM6codigo();
		}

		Object getOrganismoCodOrgAux = null;
		if (comunicacion.getOrganismo() != null
				&& comunicacion.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = comunicacion.getOrganismo().getCodOrg();
		}

		this.jdbcTemplate.update(query, comunicacion.getM4cocomu(),
				getTipoComunicacionM6codigoAux, getOrganismoCodOrgAux,
				comunicacion.getM4feenv(), comunicacion.getM4fecad(),
				comunicacion.getM4noremi(), comunicacion.getM4tesubject(),
				comunicacion.getM4tecomu(), comunicacion.getM4nudest(),
				comunicacion.getM4nufiladj(), comunicacion.getM4incomact(),
				comunicacion.getM4incombl(), comunicacion.getM4envioid());

		return comunicacion;
	}

	/**
	 * Finds a single row in the Comunicacion table.
	 * 
	 * @param comunicacion
	 *            Pagination
	 * @return Comunicacion
	 */
	@Transactional(readOnly = true)
	public Comunicacion findByEnvioId(Comunicacion comunicacion) {
		String query = "SELECT t1.M4COCOMU M4COCOMU, t1.M4COCOOR M4COCOOR, t1.M4FEENV M4FEENV, t1.M4FECAD M4FECAD, t1.M4NOREMI M4NOREMI, t1.M4TESUBJECT M4TESUBJECT, t1.M4TECOMU M4TECOMU, t1.M4NUDEST M4NUDEST, t1.M4NUFILADJ M4NUFILADJ, t1.M4INCOMACT M4INCOMACT, t1.M4INCOMBL M4INCOMBL, t1.M4ENVIOID M4ENVIOID, t2.M6CODIGO TIPOCOMUNICACIONM6CODIGO, t2.M6NOTIPO TIPOCOMUNICACIONM6NOTIPO, t2.M6TETIPO TIPOCOMUNICACIONM6TETIPO, t2.M6NOTIPOE TIPOCOMUNICACIONM6NOTIPOE, t2.M6NOTIPOI TIPOCOMUNICACIONM6NOTIPOI, t2.M6NOTIPOF TIPOCOMUNICACIONM6NOTIPOF, t2.M6NOTIPOA TIPOCOMUNICACIONM6NOTIPOA, t3.COD_ORG ORGANISMOCODORG, t3.ENTIDAD_ID ORGANISMOENTIDADID, t3.NOMBRE_ES ORGANISMONOMBREES, t3.NOMBRE_EU ORGANISMONOMBREEU, t3.ACTIVA ORGANISMOACTIVA, t3.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t3.ISKONTSUMONET ORGANISMOISKONTSUMONET, t3.ISOFERTAFORM ORGANISMOISOFERTAFORM, t3.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t3.ISNACIONAL ORGANISMOISNACIONAL, t3.OBSERVACIONES ORGANISMOOBSERVACIONES, t3.TELEFONO ORGANISMOTELEFONO, t3.FAX ORGANISMOFAX, t3.EMAIL ORGANISMOEMAIL, t3.URL ORGANISMOURL, t3.USUARIO ORGANISMOUSUARIO, t3.PASSWORD ORGANISMOPASSWORD, t3.NORA_PAIS_ID ORGANISMONORAPAISID, t3.NOMBRE_PAIS ORGANISMONOMBREPAIS, t3.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t3.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t3.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t3.NORA_CALLE_ID ORGANISMONORACALLEID, t3.NOMBRE_CALLE ORGANISMONOMBRECALLE, t3.NORA_CP_ID ORGANISMONORACPID, t3.NOMBRE_CP ORGANISMONOMBRECP, t3.NORA_PORTAL_ID ORGANISMONORAPORTALID, t3.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t3.USUULTMOD ORGANISMOUSUULTMOD, t3.FECULTMOD ORGANISMOFECULTMOD "
				+ "FROM COMUNICACION t1 , TIPO_COMUNICACION t2, ORGANISMO t3  "
				+ "WHERE t1.M4ENVIOID = ?   AND t1.M4COTIPO= t2.M6CODIGO(+)  AND t1.M4COCOOR= t3.COD_ORG(+)  ";
		return (Comunicacion) this.jdbcTemplate.queryForObject(query,
				rwMapDetalle, comunicacion.getM4envioid());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21M4T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
