package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.model.AmbitoGeografico;

/**
 * * AmbitoGeograficoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AmbitoGeograficoDaoImpl implements AmbitoGeograficoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<AmbitoGeografico> rwMap = new RowMapper<AmbitoGeografico>() {
		public AmbitoGeografico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AmbitoGeografico(resultSet.getString("TAGCODIGO"),
					resultSet.getString("TAGNOMBRE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            Pagination
	 * @return AmbitoGeografico
	 */
	public AmbitoGeografico add(AmbitoGeografico ambitoGeografico) {

		String query = "INSERT INTO AMBITO_GEOGRAFICO( TAGCODIGO,TAGNOMBRE)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, ambitoGeografico.getTagcodigo(),
				ambitoGeografico.getTagnombre());
		return ambitoGeografico;
	}

	/**
	 * Updates a single row in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            Pagination
	 * @return AmbitoGeografico
	 */
	public AmbitoGeografico update(AmbitoGeografico ambitoGeografico) {
		String query = "UPDATE AMBITO_GEOGRAFICO SET TAGNOMBRE=? WHERE TAGCODIGO=?";
		this.jdbcTemplate.update(query, ambitoGeografico.getTagnombre(),
				ambitoGeografico.getTagcodigo());
		return ambitoGeografico;
	}

	/**
	 * Finds a single row in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            Pagination
	 * @return AmbitoGeografico
	 */
	@Transactional(readOnly = true)
	public AmbitoGeografico find(AmbitoGeografico ambitoGeografico) {
		String query = "SELECT t1.TAGCODIGO TAGCODIGO, t1.TAGNOMBRE TAGNOMBRE "
				+ "FROM AMBITO_GEOGRAFICO t1  " + "WHERE t1.TAGCODIGO = ?    ";
		return (AmbitoGeografico) this.jdbcTemplate.queryForObject(query,
				rwMap, ambitoGeografico.getTagcodigo());
	}

	/**
	 * Removes a single row in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            Pagination
	 * @return
	 */
	public void remove(AmbitoGeografico ambitoGeografico) {
		String query = "DELETE  FROM AMBITO_GEOGRAFICO WHERE TAGCODIGO=?";
		this.jdbcTemplate.update(query, ambitoGeografico.getTagcodigo());
	}

	/**
	 * Finds a List of rows in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            AmbitoGeografico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AmbitoGeografico> findAll(AmbitoGeografico ambitoGeografico,
			Pagination pagination) {
		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TAGCODIGO TAGCODIGO,t1.TAGNOMBRE TAGNOMBRE "
						+ "FROM AMBITO_GEOGRAFICO t1 ");

		if (ambitoGeografico != null && ambitoGeografico.getTagcodigo() != null) {
			where.append(" AND t1.TAGCODIGO = ?");
			params.add(ambitoGeografico.getTagcodigo());
		}
		if (ambitoGeografico != null && ambitoGeografico.getTagnombre() != null) {
			where.append(" AND t1.TAGNOMBRE = ?");
			params.add(ambitoGeografico.getTagnombre());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<AmbitoGeografico>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AmbitoGeografico table.
	 * 
	 * @param ambitoGeografico
	 *            AmbitoGeografico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AmbitoGeografico ambitoGeografico) {

		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  AMBITO_GEOGRAFICO t1  ");
		if (ambitoGeografico != null && ambitoGeografico.getTagcodigo() != null) {
			where.append(" AND t1.TAGCODIGO = ?");
			params.add(ambitoGeografico.getTagcodigo());
		}
		if (ambitoGeografico != null && ambitoGeografico.getTagnombre() != null) {
			where.append(" AND t1.TAGNOMBRE = ?");
			params.add(ambitoGeografico.getTagnombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AmbitoGeografico table using like.
	 * 
	 * @param ambitoGeografico
	 *            AmbitoGeografico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AmbitoGeografico> findAllLike(
			AmbitoGeografico ambitoGeografico, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.TAGCODIGO TAGCODIGO,t1.TAGNOMBRE TAGNOMBRE "
						+ "FROM AMBITO_GEOGRAFICO t1 ");

		if (ambitoGeografico != null && ambitoGeografico.getTagcodigo() != null) {
			where.append(" AND UPPER(t1.TAGCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ambitoGeografico.getTagcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + ambitoGeografico.getTagcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TAGCODIGO IS NOT NULL");
		}
		if (ambitoGeografico != null && ambitoGeografico.getTagnombre() != null) {
			where.append(" AND UPPER(t1.TAGNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ambitoGeografico.getTagnombre().toUpperCase() + "%");
			} else {
				params.add("%" + ambitoGeografico.getTagnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TAGNOMBRE IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<AmbitoGeografico>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
