package com.ejie.y42b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y42b.model.AmbitoGeografico;

/**
 *  * AmbitoGeograficoDao  
 *  
 */

public interface AmbitoGeograficoDao {
    
    /**
     * Inserts a single row in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @return AmbitoGeografico
     */
    AmbitoGeografico add(AmbitoGeografico ambitoGeografico);

    /**
     * Updates a single row in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @return AmbitoGeografico
     */
    AmbitoGeografico update(AmbitoGeografico ambitoGeografico);

    /**
     * Finds a single row in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @return AmbitoGeografico
     */
    AmbitoGeografico find(AmbitoGeografico ambitoGeografico);

    /**
     * Deletes a single row in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @return 
     */
    void remove(AmbitoGeografico ambitoGeografico);

    /**
     * Finds a List of rows in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @param pagination Pagination
     * @return List
     */
    List<AmbitoGeografico> findAll(AmbitoGeografico ambitoGeografico, Pagination pagination);

    /**
     * Counts rows in the AmbitoGeografico table.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @return List
     */
    Long findAllCount(AmbitoGeografico ambitoGeografico);
	
	/**
     * Finds rows in the AmbitoGeografico table using like.
     *
     * @param ambitoGeografico AmbitoGeografico
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<AmbitoGeografico> findAllLike(AmbitoGeografico ambitoGeografico, Pagination pagination, Boolean startsWith);
}

