package com.ejie.y42b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y42b.constantes.Y42bAgendaConstantes;
import com.ejie.y42b.model.Adjunto;
import com.ejie.y42b.model.Envio;

/**
 * * AdjuntoDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class AdjuntoDaoImpl implements AdjuntoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Adjunto> rwMap = new RowMapper<Adjunto>() {
		public Adjunto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Adjunto(resultSet.getString("ADJUNTOID"), new Envio(
					resultSet.getString("ENVIOID"), null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null), resultSet.getString("NOMBRE"),
					resultSet.getBlob("ADJUNTO"),
					resultSet.getString("CONTENTTYPE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Pagination
	 * @return Adjunto
	 */
	public Adjunto add(Adjunto adjunto) {

		String query = "INSERT INTO ADJUNTO( ADJUNTO_ID,ENVIO_ID,NOMBRE,ADJUNTO,CONTENT_TYPE)"
				+ "VALUES (?,?,?,?,?)"; // empty_blob()

		Object EnvioEnvioIdAux = null;
		if (adjunto.getEnvio() != null
				&& adjunto.getEnvio().getEnvioId() != null) {
			EnvioEnvioIdAux = adjunto.getEnvio().getEnvioId();
		}

		byte[] raw = null;

		try {

			raw = adjunto.getAdjunto().getBytes(1,
					(int) adjunto.getAdjunto().length());

		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		this.jdbcTemplate.update(query, adjunto.getAdjuntoId(),
				EnvioEnvioIdAux, adjunto.getNombre(), raw,
				adjunto.getContentType());
		return adjunto;
	}

	/**
	 * Updates a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Pagination
	 * @return Adjunto
	 */
	public Adjunto update(Adjunto adjunto) {
		String query = "UPDATE ADJUNTO SET NOMBRE=?,ADJUNTO=?,CONTENT_TYPE=? WHERE ADJUNTO_ID=? AND ENVIO_ID=?";
		Object EnvioEnvioIdAux = null;
		if (adjunto.getEnvio() != null
				&& adjunto.getEnvio().getEnvioId() != null) {
			EnvioEnvioIdAux = adjunto.getEnvio().getEnvioId();
		}
		this.jdbcTemplate.update(query, adjunto.getNombre(),
				adjunto.getAdjunto(), adjunto.getContentType(),
				adjunto.getAdjuntoId(), EnvioEnvioIdAux);
		return adjunto;
	}

	/**
	 * Finds a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Pagination
	 * @return Adjunto
	 */
	@Transactional(readOnly = true)
	public Adjunto find(Adjunto adjunto) {
		String query = "SELECT t1.ADJUNTO_ID ADJUNTOID, t1.ENVIO_ID ENVIOID, t1.NOMBRE NOMBRE, t1.ADJUNTO ADJUNTO, t1.CONTENT_TYPE CONTENTTYPE "
				+ "FROM ADJUNTO t1  "
				+ "WHERE t1.ADJUNTO_ID = ?   AND t1.ENVIO_ID = ?    ";
		return (Adjunto) this.jdbcTemplate.queryForObject(query, this.rwMap,
				adjunto.getAdjuntoId(), adjunto.getEnvio().getEnvioId());
	}

	/**
	 * Removes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Pagination
	 * @return
	 */
	public void remove(Adjunto adjunto) {
		String query = "DELETE  FROM ADJUNTO WHERE ADJUNTO_ID=? AND ENVIO_ID=?";
		this.jdbcTemplate.update(query, adjunto.getAdjuntoId(), adjunto
				.getEnvio().getEnvioId());
	}

	/**
	 * Removes a single row in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Pagination
	 * @return
	 */
	public void removeAdjunto(Adjunto adjunto) {
		String query = "DELETE  FROM ADJUNTO WHERE ENVIO_ID=?";
		this.jdbcTemplate.update(query, adjunto.getEnvio().getEnvioId());
	}

	/**
	 * Finds a List of rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjunto> findAll(Adjunto adjunto, Pagination pagination) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADJUNTO_ID ADJUNTOID,t1.ENVIO_ID ENVIOID,t1.NOMBRE NOMBRE,t1.ADJUNTO ADJUNTO,t1.CONTENT_TYPE CONTENTTYPE FROM ADJUNTO t1 ");

		if (adjunto != null && adjunto.getAdjuntoId() != null) {
			where.append(" AND t1.ADJUNTO_ID = ?");
			params.add(adjunto.getAdjuntoId());
		}
		if (adjunto != null && adjunto.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(adjunto.getEnvio().getEnvioId());
		}
		if (adjunto != null && adjunto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(adjunto.getNombre());
		}
		if (adjunto != null && adjunto.getContentType() != null) {
			where.append(" AND t1.CONTENT_TYPE = ?");
			params.add(adjunto.getContentType());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Adjunto>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Adjunto table.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Adjunto adjunto) {

		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM  ADJUNTO t1  ");
		if (adjunto != null && adjunto.getAdjuntoId() != null) {
			where.append(" AND t1.ADJUNTO_ID = ?");
			params.add(adjunto.getAdjuntoId());
		}
		if (adjunto != null && adjunto.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(adjunto.getEnvio().getEnvioId());
		}
		if (adjunto != null && adjunto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(adjunto.getNombre());
		}
		if (adjunto != null && adjunto.getContentType() != null) {
			where.append(" AND t1.CONTENT_TYPE = ?");
			params.add(adjunto.getContentType());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Adjunto table using like.
	 * 
	 * @param adjunto
	 *            Adjunto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjunto> findAllLike(Adjunto adjunto, Pagination pagination,
			Boolean startsWith) {
		StringBuilder where = new StringBuilder(Y42bAgendaConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADJUNTO_ID ADJUNTOID,t1.ENVIO_ID ENVIOID,t1.NOMBRE NOMBRE,t1.ADJUNTO ADJUNTO,t1.CONTENT_TYPE CONTENTTYPE "
						+ "FROM ADJUNTO t1 ");

		if (adjunto != null && adjunto.getAdjuntoId() != null) {
			where.append(" AND UPPER(t1.ADJUNTO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunto.getAdjuntoId().toUpperCase() + "%");
			} else {
				params.add("%" + adjunto.getAdjuntoId().toUpperCase() + "%");
			}
			where.append(" AND t1.ADJUNTO_ID IS NOT NULL");
		}
		if (adjunto != null && adjunto.getEnvio().getEnvioId() != null) {
			where.append(" AND UPPER(t1.ENVIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunto.getEnvio().getEnvioId().toUpperCase() + "%");
			} else {
				params.add("%" + adjunto.getEnvio().getEnvioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENVIO_ID IS NOT NULL");
		}
		if (adjunto != null && adjunto.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunto.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + adjunto.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (adjunto != null && adjunto.getContentType() != null) {
			where.append(" AND UPPER(t1.CONTENT_TYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjunto.getContentType().toUpperCase() + "%");
			} else {
				params.add("%" + adjunto.getContentType().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTENT_TYPE IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Adjunto>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
}
