jQuery(document).ready(function(){
	

	
	
	var $tabs = $('#mantenimiento_tabs').tabs();
	$tabs.tabs('enable', 0);
	$tabs.tabs('select', 0);
	$tabs.tabs('disable', 1);
	$tabs.tabs('disable', 2);
	
	var props={
			type:"ok",
			delay:800,
			goTop:false,
			block:false,
			closeLink:true
	};

	$("#grupos_avisos").rup_feedback(props);
	
	var grupoId = $("#grupo_grupoId").val();
	
	$("#bt_cancelar_grupo").click(function () {
	    	loadGrupoSession();
	});
	
	$("#bt_nuevo_grupo").click(function () {
		y42bVarBotonNuevoClickado = true;
		var url="/y42bVistaWar/grupos/mant_nuevo";
		$('#tab_grupo').load(url);
	});
	
	
	$("#bt_nuevo_entidad").click(function () {
		y42bNuevaEntidad = true;
		var url="/y42bVistaWar/entidad/nuevo?grupoId=" + grupoId;
		$('#tab_entidad').load(url);
		$('#tab_grupo').empty();
		$tabs.tabs('enable', 1);
		$tabs.tabs('select', 1);
		$tabs.tabs('disable', 0);
		$tabs.tabs('disable', 2);
		
	});
	
	$("#bt_guardar_grupo").click(function () {
		var url = "../grupos/guardar";
		var codGrupoPadre = $("#y42bGruposGrupoPadreId").val();
		
		
		if (codGrupoPadre=="ROOT"){
			$("#grupos_avisos").rup_feedback("option", "delay",1600);
			$("#grupos_avisos").rup_feedback("set", $("#y42bGruposGrupoPadreDesc").val() + " "+ $.rup.i18n.app.msg.singrupoasignado, "ok");
			
		}else{
			//Para evitar que se puedan crear grupos bajo el ROOT
			
			if (codGrupoPadre=="ROOT" || codGrupoPadre=="" ){
				codGrupoPadre=0;
			}

			var codGrupoSeleccionado = $("#grupo_grupoId").val(); 
			var coincidencia = false;
			//comprobar si el padre es parte de la subjerarquia  
			//para que no se pueda poner como padre a si mismo  o a un nodo de su subjerarquia al intentar moverlo
			if (codGrupoPadre!=0){
				
				var miNodo = $("#tree_ajaxlive").dynatree("getTree").getNodeByKey("G_"+codGrupoSeleccionado);
				var nodoPadre = $("#tree_ajaxlive").dynatree("getTree").getNodeByKey("G_"+codGrupoPadre); 
				if (nodoPadre.isDescendantOf(miNodo) || codGrupoPadre.toString() == codGrupoSeleccionado.toString()){
					coincidencia = true;
				} 
			}
					
			if (coincidencia){
				$("#grupos_avisos").rup_feedback("option", "delay",null);
				$("#grupos_avisos").rup_feedback("set", $.rup.i18n.app.msg.superiorErroneo, "error");
				
			}else{
				//Copiar valores
				//Al grabar se escapan los 2 literales por si llevan caracteres especiales que rompan el JSON 
				$("#nombreEs").val(htmlEncode($("#grupo_nombreEs").val()));
				$("#nombreEu").val(htmlEncode($("#grupo_nombreEu").val()));
				//Hay que desescaparlos en el java para que se graben correctamente

				$("#padreId").val(codGrupoPadre);
				$("#grupoId").val(codGrupoSeleccionado);

				var grupo = form2object("editarGrupo", ".", false);
				var bValidarDatos=validateBean("Y42bGrupo", grupo, "","grupos_avisos");
			 	grupo = form2object("editarGrupo", ".", true);
			 	
			 	if (bValidarDatos){
			 		var jqxhr = $.ajax({
					type : 'POST',
					url : "../grupos/guardar",
					data : $("#editarGrupo").serialize(),
					error: function (jqXHR, textStatus, errorThrown){
						switch(jqXHR.status){
						
						case 406:
							$("#grupos_avisos").rup_feedback("option", "delay",null);
							$("#grupos_avisos").rup_feedback("set",jqXHR.responseText, "error");
							break;
						//case 500:	
						default:
							$("#grupos_avisos").rup_feedback("option", "delay",null);
							$("#grupos_avisos").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
							break;
						}
					},
					success : function(data) {
								
								$("#grupos_avisos").rup_feedback("option", "delay",800);
								$("#grupos_avisos").rup_feedback("set", "ok", "ok");
								y42bLoadTabGrupos(data);
								y42bVarBotonRefrescarPulsado = true;
					}
				});
			 	}
			}	
		}
	});
	y42bVarGrupoPadreId = $("#grupo_parentId").val();
	$("#y42bGruposGrupoPadreId").val($("#grupo_parentId").val());
	
	
	
	if (y42bGrupos_UsuarioTipoAcceso != $("#y42bGrupos_CteTipoAcceso_Administrador").val()){
		 y42bGruposSoloConsulta();
	}
});

$("#bt_eliminar_grupo").click(function(){
	var codigo = $("#grupo_grupoId").val();
	$.ajax({
		type : "GET",
		url : "/y42bVistaWar/grupos/comprobarHijos/"+ codigo,
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#grupos_avisos").rup_feedback("option", "delay", null);
			$("#grupos_avisos").rup_feedback("set", textStatus + ": error", "error");
		},
		success : function(data, textStatus, jqXHR) {
			if (data != null){
				var numero = parseInt(data);
			
				if (numero>0){
					//tiene hijos grupo (alerta)
					$("#grupos_avisos").rup_feedback("option", "delay", null);
					$("#grupos_avisos").rup_feedback("set", $.rup.i18n.app.msg.errorGrupotieneGruposHijo, "alert");
					
				}else{
					//sin hijos grupo
					$.rup_messages("msgConfirm",{
						   title:$.rup.i18n.app.msg.confirmacion,
						   message: $.rup.i18n.app.msg.confirmacioneliminar,
						   OKFunction : function () {
							 //Se llamara después de asignar a un grupo diferente
							 //eliminarGrupo(codigo);
							 loadArbolGruposDialog();
							 
							}
					});	
				}
			}
		}
	});
	
});


function loadArbolGruposDialog(){
//	if ($("#numEntidadesActivas").val()==0){
//		eliminarGrupo($("#grupo_grupoId").val());
//	}else{
//		console.log("Antes de abrir la modal");
		var url = "../grupos/loadArbolGrupos/" + $("#grupo_grupoId").val();
		$("#eliminacionActionDialog").rup_dialog("destroy");
		$("#eliminacionActionDialog").rup_dialog({
		      modal: true,
		      resizable: false,        
		      height: "auto",
		      width: 700,
		      url: url,
		      title: $.rup.i18n.app.search_dialog.removeGroupAction,
		      type:$.rup.dialog.AJAX,
		      autoOpen: true
//		      ,close: function(event, ui) {
//		    	  //debugger;
//		    	  if ($("#resultadoMassiveActionDialog").val()=="ACEPTAR"){
//		    		  eliminarGrupo($("#grupo_grupoId").val());  
//		    	  }
//		    	  
//		      } 
		});
	
//	}
}

function eliminarGrupo(codigo) {
	
	var url = "../grupos/" + codigo;
		$.ajax({
		url: url,
		type: "DELETE",
		cache: false,
		success: function(html){
			document.location.href = "#grupos_avisos";
			y42bLoadTabGruposARoot();
			
		},
		statusCode: {
			404: function() {
				alert('Page not found');
			},
			200: function() {
				// Muestra un success en pantalla
				$("#grupos_avisos").rup_feedback("option", "delay",800);
				$("#grupos_avisos").rup_feedback("set", "ok", "ok");
				var url="/y42bVistaWar/grupos/mant?nodeId=G_ROOT";
			  	$('#tab_grupo').load(url);
			},  
			406: function() {
				$("#grupos_avisos").rup_feedback("option", "delay",800);
				$("#grupos_avisos").rup_feedback("set", $.rup.i18n.app.msg.errorGrupotieneGruposHijo, "error");
		    }
	  	}
	});
}

function loadGrupoSession(){
	var url="/y42bVistaWar/grupos/mant?nodeId=G_ROOT";
	$('#tab_entidad').html("");
	$('#tab_grupo').load(url);
	var $tabs = $('#mantenimiento_tabs').tabs();
	$tabs.tabs('enable', 0);
	$tabs.tabs('select', 0); 
	$tabs.tabs('disable', 1);
	$tabs.tabs('disable', 2);
}

//ONCLICK LUPA GRUPO PADRE
$("#y42bGruposGrupoPadreLupa").click(function(){
	$("#y42bDivGruposModalPadres").rup_dialog({
		title: $.rup.i18n.app.title.seleccionGrupoPadre,
		modal: true,
		autoOpen: true,
		resizable: false,
		width: "450",
		height: "400",
		url: "/y42bVistaWar/grupos/maintModal",
		type:$.rup.dialog.AJAX,
		close:function(event, ui){
			y42bDestruirArbolModalSeleccionPadre();
			$("#y42bDivGruposModalPadres").rup_dialog("destroy");
		}
	});	
});


//ONCLICK PAPELERA
$("#y42bGruposGrupoPadrePapelera").click(function(){
	$("#y42bGruposGrupoPadreId").val("0");
	$("#y42bGruposGrupoPadreDesc").val("");
});


$(function(){
	if(y42bVarBotonNuevoClickado){
		y42bVarNodoSeleccionadoId = y42bFunEliminarPrefijo(y42bVarNodoSeleccionadoId);
		
		if (y42bVarNodoSeleccionadoId == "ROOT"){
			y42bVarNodoSeleccionadoDesc = y42bEliminarHref(y42bVarNodoSeleccionadoDesc);
		}
		$("#y42bGruposGrupoPadreId").val(y42bVarNodoSeleccionadoId);
		$("#y42bGruposGrupoPadreDesc").val(htmlDecode(y42bVarNodoSeleccionadoDesc));	
	}else{
		if ($("#y42bGruposGrupoPadreId").val()!="" && $("#y42bGruposGrupoPadreId").val()!=undefined){
			y42bFunObtenerDescripcionPadre();
		}
	}
	y42bVarBotonNuevoClickado = false;
});


function y42bFunObtenerDescripcionPadre(){
	if ($("#y42bGruposGrupoPadreId").val()!="0" && $("#y42bGruposGrupoPadreId").val()!=""){
		$.ajax({
			type : "GET",
			url : "/y42bVistaWar/grupos/byGrupoId/" + $("#y42bGruposGrupoPadreId").val(), 
			dataType : "json",
			error : function(jqXHR, textStatus, errorThrown) {
				$("#grupos_avisos").rup_feedback("option", "delay", 800);
				$("#grupos_avisos").rup_feedback("set", textStatus + ": error", "error");
			},
			success : function(data, textStatus, jqXHR) {
				var descripcion = "";
				if ("es"==$.rup_utils.get("language")){
					descripcion = data.nombreEs;
				}else if("eu"==$.rup_utils.get("language")){
					descripcion = data.nombreEu;
				}
				$("#y42bGruposGrupoPadreDesc").val(descripcion);
			}
		});
	}
}

function y42bReloadArbolGrupos(){
	$("#tree_ajaxlive").remove();
	$('<div id="tree_contenedor"><div id="tree_ajaxlive"></div></div>').replaceAll("#tree_contenedor");

	var urlTree="/y42bVistaWar/arbol/ajaxTree?mostrarNoActivas=0";
	loadTreeUtilidades(urlTree);
}

function y42bLoadTabGrupos(data){
	var url="/y42bVistaWar/grupos/mant?nodeId=G_" + htmlEscape(data.grupoId);
	$('#tab_grupo').load(url);
	y42bRefrescarArbol();
}


function y42bDestruirArbolModalSeleccionPadre(){
	$("#y42bArbolGruposPadre").dynatree("destroy");
}

function y42bLoadTabGruposARoot(){
	var url="/y42bVistaWar/grupos/mant?nodeId=G_ROOT" ;
	$('#tab_grupo').load(url);
	y42bRefrescarArbol();
}


function y42bGruposSoloConsulta(){
	$("#bt_nuevo_grupo").hide();
	$("#bt_nuevo_entidad").hide();
	$("#y42bGruposGrupoPadreLupa").hide();
	$("#y42bGruposGrupoPadrePapelera").hide();
	$("#grupo_nombreEs").attr("readonly", "readonly");
	$("#grupo_nombreEs").css({'background-color':'#EBE8E9','border-color':'#EBE8E9','border-style':'solid'});
	$("#grupo_nombreEu").attr("readonly", "readonly");
	$("#grupo_nombreEu").css({'background-color':'#EBE8E9','border-color':'#EBE8E9','border-style':'solid'});
	$("#numEntidadesActivas").attr("readonly", "readonly");
	$("#numEntidadesActivas").css({'background-color':'#EBE8E9','border-color':'#EBE8E9','border-style':'solid'});
	$("#bt_eliminar_grupo").hide();
	$("#bt_guardar_grupo").hide();
	
	$("#y42bVistaWar_menu-2").hide();
	
}
