package com.ejie.y41a.validation;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.StackTraceManager;

/**
 * 
 *  
 * 
 */
public class Y41aValidationServlet implements HttpRequestHandler {

	private Y41aValidationManager validationManager;
	private CookieLocaleResolver localeResolver;

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(Y41aValidationServlet.class);

	@Override
	public void handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		logger.info("The request is a validation. Validation begins.");

		try {
			int language = localeResolver.getCookieName().length() + 1;
			int languageIndex = request.getHeader("Cookie").indexOf(
					localeResolver.getCookieName())
					+ language;
			Locale locale = new Locale(request.getHeader("Cookie").substring(
					languageIndex, languageIndex + 2));// (request.getHeader("Cookie").indexOf(";"))));

			String data = "";
			String bean = "";
			String group = "";
			Enumeration e = request.getParameterNames();
			while (e.hasMoreElements()) {
				String param = e.nextElement().toString();

				if (param.equals("bean")) {
					bean = request.getParameter(param);
				} else if (param.equals("group")) {
					group = request.getParameter(param);
				} else if (param.equals("data")) {
					data = request.getParameter(param);
				}
			}

			String result = null;
			if ("".equals(group) || group == null) {
				result = validationManager.validateObject(bean, data, locale);
			} else {
				result = validationManager.validateObjectGroup(bean, data,
						group, locale);
			}

			response.setContentType("text/javascript;charset=UTF-8");
			response.setHeader("Cache-Control", "no-cache");
			response.setHeader("Expires", DateTimeManager.getHttpExpiredDate());

			if (result == null) {
				response.setStatus(HttpServletResponse.SC_OK);
			} else if (result != null && !result.equals("error!")) {
				response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
				response.getWriter().write(result);
			} else {
				throw new RuntimeException("error!");

			}
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(StackTraceManager.getStackTrace(e));
			response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			response.getWriter()
					.write("Error in the validate. The structure or morphology of the data is incorrect, review the data sent.");
		}

		logger.debug("Exit from the Validation Servlet.");
	}

	// Getters & Setters
	public Y41aValidationManager getValidationManager() {
		return validationManager;
	}

	public void setValidationManager(Y41aValidationManager validationManager) {
		this.validationManager = validationManager;
	}

	public void setLocaleResolver(CookieLocaleResolver localeResolver) {
		this.localeResolver = localeResolver;
	}
}
