package com.ejie.y41a.validation;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.util.StringUtils;

import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.StaticsContainer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 *  
 * 
 */
public class Y41aValidationManager {

	@Resource
	ReloadableResourceBundleMessageSource messageSource;

	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(Y41aValidationManager.class);
	private ValidatorFactory validatorFactory;
	private Validator validator;
	private MappingJsonFactory jsonFactory;

	@PostConstruct
	public void init() {

		validatorFactory = Validation.buildDefaultValidatorFactory();
		validator = validatorFactory.getValidator();

		jsonFactory = new MappingJsonFactory();
		messageSource.setFallbackToSystemLocale(false);
	}

	public String validateObject(String bean, String data, Locale locale) {
		try {
			Class<?> clazz = Class.forName(StaticsContainer.modelPackageName
					+ bean);
			ObjectMapper mapper = new ObjectMapper();
			Object instance = mapper.readValue(data, clazz);

			Set<ConstraintViolation<Object>> constraintViolations = validator
					.validate(instance);

			return summary(constraintViolations, bean, locale);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(StackTraceManager.getStackTrace(e));
			return "error!";
		}
	}

	public String validateObjectGroup(String bean, String data, String group,
			Locale locale) {
		try {
			Class<?> clazz = Class.forName(StaticsContainer.modelPackageName
					+ bean);
			ObjectMapper mapper = new ObjectMapper();
			Object instance = mapper.readValue(data, clazz);

			Class<?> clazzGroup = Class
					.forName(StaticsContainer.modelPackageName + group);

			Set<ConstraintViolation<Object>> constraintViolations = validator
					.validate(instance, Default.class, clazzGroup);

			return summary(constraintViolations, bean, locale);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(StackTraceManager.getStackTrace(e));
			return "error!";
		}
	}

	public String validateProperty(String bean, String property, String value,
			Locale locale) {
		try {

			String capitalicedProperty = StringUtils.capitalize(property);
			String capitalicedBean = StringUtils.capitalize(bean);

			Class<?> clazz = Class.forName(StaticsContainer.modelPackageName
					+ capitalicedBean);
			Constructor<?> cons = clazz.getConstructor();
			Object obj = cons.newInstance((Object[]) null);

			Method getter = clazz.getMethod("get" + capitalicedProperty,
					new Class[] {});
			Method meth = clazz.getMethod("set" + capitalicedProperty,
					getter.getReturnType());
			Object res = ObjectConversionManager.convert(value,
					getter.getReturnType());
			meth.invoke(obj, res);

			Set<ConstraintViolation<Object>> constraintViolations = validator
					.validateProperty(obj, property);
			return summary(constraintViolations, bean, locale);
		} catch (Exception e) {
			logger.error(StackTraceManager.getStackTrace(e));
			return "error!";
		}
	}

	private String summary(
			Set<ConstraintViolation<Object>> constraintViolations, String bean,
			Locale locale) {
		Iterator<ConstraintViolation<Object>> ite = constraintViolations
				.iterator();
		HashMap<String, List<Map<String, String>>> errors = new HashMap<String, List<Map<String, String>>>();
		String propertyKey = "";
		List<Map<String, String>> propertyErrors;
		while (ite.hasNext()) {
			ConstraintViolation<Object> constraintViolation = ite.next();
			propertyKey = constraintViolation.getMessageTemplate();

			if (errors.containsKey(propertyKey)) {
				propertyErrors = errors.get(propertyKey);
			} else {
				propertyErrors = new ArrayList<Map<String, String>>();
			}
			Map<String, String> node = new HashMap<String, String>();
			String interpolatedMessage;
			// Try to get the interpolated Message in this order: 1- War, 2-
			// EAR, 3- Hibernate's Default
			try {
				interpolatedMessage = messageSource.getMessage(
						devuelveCodigo(constraintViolation.getMessage()), null,
						locale);
			} catch (NoSuchMessageException e) {
				interpolatedMessage = devuelveCodigo(constraintViolation
						.getMessage());
			}
			if (interpolatedMessage != null && !interpolatedMessage.equals("")) {
				node.put(propertyKey, interpolatedMessage);
			} else {
				node.put(constraintViolation.getConstraintDescriptor()
						.getAnnotation().annotationType().getSimpleName(),
						"message not found");
				logger.error("Validation message for key "
						+ constraintViolation.getConstraintDescriptor()
								.getAnnotation().annotationType()
								.getSimpleName() + " not found");
			}

			propertyErrors.add(node);
			errors.put(propertyKey, propertyErrors);
		}
		if (!errors.isEmpty()) {
			Map<String, String> title = new HashMap<String, String>();
			title.put("key", bean);
			String header = serialize(title);
			String body = serialize(ordenarMapaErrores(errors));
			String[] result = { header, body };
			String summary = serialize(result);
			return summary;
		} else {
			return null;
		}
	}

	private String serialize(Object result) {
		StringWriter sw;
		try {
			sw = new StringWriter();
			ObjectMapper mapper = new ObjectMapper();
			JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(sw);
			mapper.writeValue(jsonGenerator, result);
			sw.close();
		} catch (IOException e) {
			logger.error(StackTraceManager.getStackTrace(e));
			return "error!";
		}
		return sw.getBuffer().toString();
	}

	// Getters & Setters
	public void setMessageSource(
			ReloadableResourceBundleMessageSource messageSource) {
		this.messageSource = messageSource;
	}

	private static HashMap<String, List<Map<String, String>>> ordenarMapaErrores(
			HashMap<String, List<Map<String, String>>> hmTemp) {

		HashMap<String, List<Map<String, String>>> errorsOrden = new HashMap<String, List<Map<String, String>>>();
		Iterator<Entry<String, List<Map<String, String>>>> it = hmTemp
				.entrySet().iterator();
		String id = "";
		ArrayList<String> arList = new ArrayList<String>();
		while (it.hasNext()) {
			id = (String) it.next().getKey();
			arList.add(id);
		}
		arList = ordenarArrayList(arList);
		for (int i = 0; i < arList.size(); i++) {
			errorsOrden.put(String.valueOf(i),
					(List<Map<String, String>>) hmTemp.get(arList.get(i)));
		}

		return errorsOrden;
	}

	/**
	 * 
	 * @param errorCodigo
	 *            errorCodigo
	 * @return errorCodigo quitado errorXX.
	 */
	private static String devuelveCodigo(String errorCodigo) {

		String codigoVuelta = errorCodigo;
		Pattern patron = Pattern.compile("error(\\d{2}).");
		Matcher matcher = patron.matcher(errorCodigo);
		if (matcher.find() && matcher.start() == 0) {
			codigoVuelta = errorCodigo.substring(errorCodigo.indexOf(".") + 1,
					errorCodigo.length());
		}

		return codigoVuelta;
	}

	/**
	 * Recibe un ArrayList de Inspecciones y las ordena (Metodo de la burbuja).
	 * 
	 * @param listaAOrdenar
	 *            List
	 * @return List
	 */
	public static ArrayList<String> ordenarArrayList(
			ArrayList<String> listaAOrdenar) {
		if (listaAOrdenar != null && listaAOrdenar.size() > 1) {
			String temp = null;
			for (int i = 1; i < listaAOrdenar.size(); i++) {
				for (int j = 0; j < (listaAOrdenar.size() - i); j++) {
					String aj = (String) listaAOrdenar.get(j);
					String aj1 = (String) listaAOrdenar.get(j + 1);
					String keyAJ = "0";
					String keyAJ1 = "0";
					if (null != aj && !"".equals(aj)) {
						keyAJ = aj;
					}
					if (null != aj1 && !"".equals(aj1)) {
						keyAJ1 = aj1;
					}
					if (0 < keyAJ.compareTo(keyAJ1)) {
						temp = aj;
						listaAOrdenar.set(j, aj1);
						listaAOrdenar.set(j + 1, temp);
					}
				}
			}
		}
		return listaAOrdenar;
	}
}