package com.ejie.y41a.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.Traslado;
import com.ejie.y41a.model.TrasladoBusqueda;
import com.ejie.y41a.service.TrasladoService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * TrasladoController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/traslado")
public class TrasladoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TrasladoController.class);

	@Autowired()
	private TrasladoService trasladoService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            request
	 * @return String
	 */
	@RequestMapping(value = "envios", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnvios(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		TrasladoBusqueda auxTraslado = new TrasladoBusqueda();
		model.addAttribute("traslado", auxTraslado);
		model.addAttribute("censoMonitor", censoMonitor);

		return new ModelAndView("traslado_envios", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param ihcodigo
	 *            ihcodigo
	 * @param recepcionar
	 *            boolean "S" "N"
	 * @param request
	 *            request
	 * @return String
	 */
	@RequestMapping(value = "enviosDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnviosDetalle(
			Model model,
			@RequestParam(value = "ihcodigo", required = false) String ihcodigo,
			@RequestParam(value = "recepcionar", required = false) String recepcionar,
			HttpServletRequest request) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		TrasladoBusqueda traslado = new TrasladoBusqueda();
		traslado.setIhcodigo(ihcodigo);

		// List<TrasladoBusqueda> aux = this.trasladoService.findAllTraslado(
		// traslado, null);

		TrasladoBusqueda aux = this.trasladoService.findTraslado(traslado);
		if (Y41aConstantes.SI.equals(recepcionar)) {
			recepcionar = ((aux.getIhfereen() != null) ? Y41aConstantes.NO
					: Y41aConstantes.SI);
		} else {
			recepcionar = Y41aConstantes.NO;
		}

		model.addAttribute("traslado", aux);
		model.addAttribute("censoMonitor", censoMonitor);
		model.addAttribute("mostrarRecepcionar", recepcionar);

		return new ModelAndView("traslado_envios_detalle", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "recepciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormRecepciones(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("traslado_recepciones", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ihcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{ihcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Traslado getById(@PathVariable() String ihcodigo) {
		try {
			Traslado traslado = new Traslado();
			traslado.setIhcodigo(ihcodigo);
			traslado = this.trasladoService.find(traslado);
			if (traslado == null) {
				throw new Exception(ihcodigo.toString());
			}
			return traslado;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ihcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param ihcodigo
	 *            String
	 * @param decisionHechoHccodigo
	 *            String
	 * @param ihcoortr
	 *            String
	 * @param ihnrortr
	 *            BigDecimal
	 * @param ihnrantr
	 *            BigDecimal
	 * @param ihcoor
	 *            String
	 * @param ihnror
	 *            BigDecimal
	 * @param ihnran
	 *            BigDecimal
	 * @param ihinintr
	 *            String
	 * @param ihfereen
	 *            Date
	 * @param ihtereor
	 *            String
	 * @param ihfereor
	 *            Date
	 * @param ihcooror
	 *            String
	 * @param ihcoordt
	 *            String
	 * @param ihtedoad
	 *            String
	 * @param ihcoad
	 *            String
	 * @param ihcoorac
	 *            String
	 * @param ihnrorac
	 *            String
	 * @param ihnranac
	 *            BigDecimal
	 * @param ihnrorat
	 *            BigDecimal
	 * @param ihcocpde
	 *            String
	 * @param ihcoorde
	 *            String
	 * @param ihnrande
	 *            BigDecimal
	 * @param ihnrorde
	 *            BigDecimal
	 * @param ihnrorhd
	 *            BigDecimal
	 * @param ihfeacre
	 *            Date
	 * @param ihfecdoi
	 *            Date
	 * @param ihfecdin
	 *            Date
	 * @param ihferesa
	 *            Date
	 * @param ihterard
	 *            String
	 * @param ihcottdd
	 *            String
	 * @param ihcaptmd
	 *            BigDecimal
	 * @param ihfecodd
	 *            Date
	 * @param ihcoord2
	 *            String
	 * @param ihfeset1
	 *            Date
	 * @param ihfeset2
	 *            Date
	 * @param ihfeset3
	 *            Date
	 * @param ihfeset4
	 *            Date
	 * @param ihfecdd1
	 *            Date
	 * @param ihindrec
	 *            String
	 * @param ihcohcds
	 *            String
	 * @param ihcoadds
	 *            String
	 * @param ihcoeh
	 *            String
	 * @param ihnrrgen
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "ihcodigo", required = false) String ihcodigo,
			@RequestParam(value = "decisionHechoHccodigo", required = false) String decisionHechoHccodigo,
			@RequestParam(value = "ihcoortr", required = false) String ihcoortr,
			@RequestParam(value = "ihnrortr", required = false) BigDecimal ihnrortr,
			@RequestParam(value = "ihnrantr", required = false) BigDecimal ihnrantr,
			@RequestParam(value = "ihcoor", required = false) String ihcoor,
			@RequestParam(value = "ihnror", required = false) BigDecimal ihnror,
			@RequestParam(value = "ihnran", required = false) BigDecimal ihnran,
			@RequestParam(value = "ihinintr", required = false) String ihinintr,
			@RequestParam(value = "ihfereen", required = false) Date ihfereen,
			@RequestParam(value = "ihtereor", required = false) String ihtereor,
			@RequestParam(value = "ihfereor", required = false) Date ihfereor,
			@RequestParam(value = "ihcooror", required = false) String ihcooror,
			@RequestParam(value = "ihcoordt", required = false) String ihcoordt,
			@RequestParam(value = "ihtedoad", required = false) String ihtedoad,
			@RequestParam(value = "ihcoad", required = false) String ihcoad,
			@RequestParam(value = "ihcoorac", required = false) String ihcoorac,
			@RequestParam(value = "ihnrorac", required = false) String ihnrorac,
			@RequestParam(value = "ihnranac", required = false) BigDecimal ihnranac,
			@RequestParam(value = "ihnrorat", required = false) BigDecimal ihnrorat,
			@RequestParam(value = "ihcocpde", required = false) String ihcocpde,
			@RequestParam(value = "ihcoorde", required = false) String ihcoorde,
			@RequestParam(value = "ihnrande", required = false) BigDecimal ihnrande,
			@RequestParam(value = "ihnrorde", required = false) BigDecimal ihnrorde,
			@RequestParam(value = "ihnrorhd", required = false) BigDecimal ihnrorhd,
			@RequestParam(value = "ihfeacre", required = false) Date ihfeacre,
			@RequestParam(value = "ihfecdoi", required = false) Date ihfecdoi,
			@RequestParam(value = "ihfecdin", required = false) Date ihfecdin,
			@RequestParam(value = "ihferesa", required = false) Date ihferesa,
			@RequestParam(value = "ihterard", required = false) String ihterard,
			@RequestParam(value = "ihcottdd", required = false) String ihcottdd,
			@RequestParam(value = "ihcaptmd", required = false) BigDecimal ihcaptmd,
			@RequestParam(value = "ihfecodd", required = false) Date ihfecodd,
			@RequestParam(value = "ihcoord2", required = false) String ihcoord2,
			@RequestParam(value = "ihfeset1", required = false) Date ihfeset1,
			@RequestParam(value = "ihfeset2", required = false) Date ihfeset2,
			@RequestParam(value = "ihfeset3", required = false) Date ihfeset3,
			@RequestParam(value = "ihfeset4", required = false) Date ihfeset4,
			@RequestParam(value = "ihfecdd1", required = false) Date ihfecdd1,
			@RequestParam(value = "ihindrec", required = false) String ihindrec,
			@RequestParam(value = "ihcohcds", required = false) String ihcohcds,
			@RequestParam(value = "ihcoadds", required = false) String ihcoadds,
			@RequestParam(value = "ihcoeh", required = false) String ihcoeh,
			@RequestParam(value = "ihnrrgen", required = false) String ihnrrgen,
			HttpServletRequest request) {
		try {
			Traslado filterTraslado = new Traslado(ihcodigo, ihcoortr,
					ihnrortr, ihnrantr, ihcoor, ihnror, ihnran, ihinintr,
					ihfereen, ihtereor, ihfereor, ihcooror, ihcoordt, ihtedoad,
					ihcoad, ihcoorac, ihnrorac, ihnranac, ihnrorat, ihcocpde,
					ihcoorde, ihnrande, ihnrorde, ihnrorhd, ihfeacre, ihfecdoi,
					ihfecdin, ihferesa, ihterard, ihcottdd, ihcaptmd, ihfecodd,
					ihcoord2, ihfeset1, ihfeset2, ihfeset3, ihfeset4, ihfecdd1,
					ihindrec, ihcohcds, ihcoadds, ihcoeh, ihnrrgen,
					new DecisionHecho(decisionHechoHccodigo, null, null, null,
							null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Traslado> traslados = this.trasladoService.findAll(
						filterTraslado, pagination);

				if (traslados == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTraslado, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(traslados);
				return data;
			} else {
				List<Traslado> traslados = this.trasladoService.findAll(
						filterTraslado, pagination);
				if (traslados == null) {
					throw new Exception("No data Found.");
				}
				return traslados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Busca los envíos realizado desde la delegación según los criterios
	 * introducidos. Sólo se mostrarán los traslados cuyo destino sea un
	 * organismo de los que pueden crear solicitudes.
	 * 
	 * @param y41aTrasladosCodA_
	 *            String
	 * @param y41aTrasladosCodB_
	 *            String
	 * @param y41aTrasladosCodC_
	 *            String
	 * @param y41aTrasladosOrigenOrganismoCode_
	 *            String
	 * @param y41aTrasladosDestinoOrganismoCode_
	 *            String
	 * @param fecEnvioDesde
	 *            String
	 * @param fecEnvioHasta
	 *            String
	 * @param y41aTrasladoSinRecepcionar_
	 *            String
	 * @param request
	 *            request petición HTTP
	 * @return object
	 */
	@RequestMapping(value = "searchEnvios", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllEnvios(
			@RequestParam(value = "y41aTrasladosCodA_", required = false) String y41aTrasladosCodA_,
			@RequestParam(value = "y41aTrasladosCodB_", required = false) String y41aTrasladosCodB_,
			@RequestParam(value = "y41aTrasladosCodC_", required = false) String y41aTrasladosCodC_,
			@RequestParam(value = "y41aTrasladosOrigenOrganismoCode_", required = false) String y41aTrasladosOrigenOrganismoCode_,
			@RequestParam(value = "y41aTrasladosDestinoOrganismoCode_", required = false) String y41aTrasladosDestinoOrganismoCode_,
			@RequestParam(value = "fechaDesde_", required = false) String fecEnvioDesde,
			@RequestParam(value = "fechaHasta_", required = false) String fecEnvioHasta,
			@RequestParam(value = "y41aTrasladoSinRecepcionar_", required = false) String y41aTrasladoSinRecepcionar_,
			HttpServletRequest request) {

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		String orgOrigen = censoMonitor.getOrganismo().getCodOrg();

		String ihcoortr = null;
		if (y41aTrasladosCodA_ != null && !"".equals(y41aTrasladosCodA_)) {
			ihcoortr = y41aTrasladosCodA_; // y41aTrasladosCodA_;
		}

		BigDecimal ihnrortr = null;
		if (y41aTrasladosCodB_ != null && !"".equals(y41aTrasladosCodB_)) {

			ihnrortr = new BigDecimal(y41aTrasladosCodB_); // y41aTrasladosCodB_;
		}

		BigDecimal ihnrantr = null;
		if (y41aTrasladosCodC_ != null && !"".equals(y41aTrasladosCodC_)) {

			ihnrantr = new BigDecimal(y41aTrasladosCodC_); // y41aTrasladosCodC_;
		}
		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();

		try {

			TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda();
			trasladoBusqueda.setIhcoortr(ihcoortr);
			trasladoBusqueda.setIhnrortr(ihnrortr);
			trasladoBusqueda.setIhnrantr(ihnrantr);

			trasladoBusqueda.setIhcooror(Y41aUtils.normalizarNulo(orgOrigen));
			trasladoBusqueda.setIhcoordt(Y41aUtils
					.normalizarNulo(y41aTrasladosDestinoOrganismoCode_));

			Date fechaEnvioDesde = Y41aUtils.parseDate(fecEnvioDesde, locale);

			Date fechaEnvioHasta = Y41aUtils.parseDate(fecEnvioHasta, locale);

			trasladoBusqueda.setEhfechaDesde(fechaEnvioDesde);
			trasladoBusqueda.setEhfechaHasta(fechaEnvioHasta);
			if ("S".equals(y41aTrasladoSinRecepcionar_)) {
				trasladoBusqueda
						.setSinRecepcionarDestino(y41aTrasladoSinRecepcionar_);
			}

			trasladoBusqueda.setIhcooror(orgOrigen);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TrasladoBusqueda> traslados = this.trasladoService
						.findAllTraslado(trasladoBusqueda, pagination);

				if (traslados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.trasladoService
						.findAllTrasladoCount(trasladoBusqueda);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(traslados);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("EHFECHA");
				pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);

				List<TrasladoBusqueda> traslados = this.trasladoService
						.findAllTraslado(trasladoBusqueda, pagination);
				if (traslados == null) {
					throw new Exception("No data Found.");
				}
				return traslados;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTraslado
	 *            Traslado
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "traslado", required = false) Traslado filterTraslado,
			HttpServletRequest request) {
		try {
			return this.trasladoService
					.findAllCount(filterTraslado != null ? filterTraslado
							: new Traslado());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * 
	 * @param y41aTrasladosCodA_
	 *            String
	 * @param y41aTrasladosCodB_
	 *            String
	 * @param y41aTrasladosCodC_
	 *            String
	 * @param y41aTrasladosOrigenOrganismoCode_
	 *            String
	 * @param fecRegistroDesde
	 *            String
	 * @param fecRegistroHasta
	 *            String
	 * @param fecEnvioDesde
	 *            String
	 * @param fecEnvioHasta
	 *            String
	 * @param y41aTrasladoPendientesRecepcionar_
	 *            String
	 * @param request
	 *            request
	 * @return object
	 */
	@RequestMapping(value = "searchRecepciones", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllRecepciones(
			@RequestParam(value = "y41aTrasladosCodA_", required = false) String y41aTrasladosCodA_,
			@RequestParam(value = "y41aTrasladosCodB_", required = false) String y41aTrasladosCodB_,
			@RequestParam(value = "y41aTrasladosCodC_", required = false) String y41aTrasladosCodC_,
			@RequestParam(value = "y41aTrasladosOrigenOrganismoCode_", required = false) String y41aTrasladosOrigenOrganismoCode_,
			@RequestParam(value = "fechaEnvioRegistroDesde_", required = false) String fecRegistroDesde,
			@RequestParam(value = "fechaEnvioRegistroHasta_", required = false) String fecRegistroHasta,
			@RequestParam(value = "fechaEnvioDesde_", required = false) String fecEnvioDesde,
			@RequestParam(value = "fechaEnvioHasta_", required = false) String fecEnvioHasta,
			@RequestParam(value = "y41aTrasladoPendientesRecepcionar_", required = false) String y41aTrasladoPendientesRecepcionar_,
			HttpServletRequest request) {

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		String orgDestino = censoMonitor.getOrganismo().getCodOrg();

		String ihcoortr = null;
		if (y41aTrasladosCodA_ != null && !"".equals(y41aTrasladosCodA_)) {
			ihcoortr = y41aTrasladosCodA_; // y41aTrasladosCodA_;
		}

		BigDecimal ihnrortr = null;
		if (y41aTrasladosCodB_ != null && !"".equals(y41aTrasladosCodB_)) {

			ihnrortr = new BigDecimal(y41aTrasladosCodB_); // y41aTrasladosCodB_;
		}

		BigDecimal ihnrantr = null;
		if (y41aTrasladosCodC_ != null && !"".equals(y41aTrasladosCodC_)) {

			ihnrantr = new BigDecimal(y41aTrasladosCodC_); // y41aTrasladosCodC_;
		}
		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();

		try {

			TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda();
			trasladoBusqueda.setIhcoortr(ihcoortr);
			trasladoBusqueda.setIhnrortr(ihnrortr);
			trasladoBusqueda.setIhnrantr(ihnrantr);

			if (y41aTrasladosOrigenOrganismoCode_ != null
					&& !"".equals(y41aTrasladosOrigenOrganismoCode_)) {
				trasladoBusqueda.setIhcooror(y41aTrasladosOrigenOrganismoCode_);
			}

			if ("S".equals(y41aTrasladoPendientesRecepcionar_)) {
				trasladoBusqueda
						.setSinRecepcionarDestino(y41aTrasladoPendientesRecepcionar_);
			}

			Date fechaRegistroDesde = Y41aUtils.parseDate(fecRegistroDesde,
					locale);

			Date fechaRegistroHasta = Y41aUtils.parseDate(fecRegistroHasta,
					locale);

			Date fechaEnvioDesde = Y41aUtils.parseDate(fecEnvioDesde, locale);

			Date fechaEnvioHasta = Y41aUtils.parseDate(fecEnvioHasta, locale);

			trasladoBusqueda.setIhfereenDesde(fechaRegistroDesde);
			trasladoBusqueda.setIhfereenHasta(fechaRegistroHasta);

			trasladoBusqueda.setEhfechaDesde(fechaEnvioDesde);
			trasladoBusqueda.setEhfechaHasta(fechaEnvioHasta);

			trasladoBusqueda.setIhcoordt(orgDestino);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TrasladoBusqueda> traslados = this.trasladoService
						.findAllTraslado(trasladoBusqueda, pagination);

				if (traslados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.trasladoService
						.findAllTrasladoCount(trasladoBusqueda);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(traslados);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("EHFECHA");
				pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);

				List<TrasladoBusqueda> traslados = this.trasladoService
						.findAllTraslado(trasladoBusqueda, pagination);
				if (traslados == null) {
					throw new Exception("No data Found.");
				}
				return traslados;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param response
	 *            HttpServletResponse
	 * @return Traslado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Traslado edit(@RequestBody() Traslado traslado, HttpServletResponse response) {
		try {
			Traslado trasladoAux = this.trasladoService.update(traslado);
			logger.info("Entity correctly inserted!");
			return trasladoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Traslado add(@RequestBody() Traslado traslado) {
		try {
			Traslado trasladoAux = this.trasladoService.add(traslado);
			logger.info("Entity correctly inserted!");
			return trasladoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'recepcionar'.
	 * 
	 * @param ihcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/recepcionar/{ihcodigo}", method = RequestMethod.GET)
	public void recepcionar(@PathVariable() String ihcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TrasladoBusqueda trasladoBusqueda = new TrasladoBusqueda();
			trasladoBusqueda.setIhcodigo(ihcodigo);
			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);
			trasladoBusqueda.setIhfereen(todayWithZeroTime);
			this.trasladoService.updateTraslado(trasladoBusqueda);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Unable to recepccionar " + ihcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ihcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ihcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String ihcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Traslado traslado = new Traslado();
			traslado.setIhcodigo(ihcodigo);
			this.trasladoService.remove(traslado);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ihcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param trasladoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> trasladoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Traslado> trasladoList = new ArrayList<Traslado>();
		try {
			for (ArrayList<String> trasladoId : trasladoIds) {
				Iterator<String> iterator = trasladoId.iterator();
				Traslado traslado = new Traslado();
				traslado.setIhcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				trasladoList.add(traslado);
			}
			this.trasladoService.removeMultiple(trasladoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTrasladoService'.
	 * 
	 * @return TrasladoService
	 */
	protected TrasladoService getTrasladoService() {
		return this.trasladoService;
	}

	/**
	 * Method 'setTrasladoService'.
	 * 
	 * @param trasladoService
	 *            TrasladoService
	 * @return
	 */
	public void setTrasladoService(TrasladoService trasladoService) {
		this.trasladoService = trasladoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
