package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Tramite;
import com.ejie.y41a.service.TramiteHechoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TramiteHecho;

/**
 * * TramiteHechoController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramitehecho")
public class TramiteHechoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteHechoController.class);

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tramitehecho", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TramiteHecho getById(@PathVariable String ehcodigo) {
		try {
			TramiteHecho tramiteHecho = new TramiteHecho();
			tramiteHecho.setEhcodigo(ehcodigo);
			tramiteHecho = this.tramiteHechoService.find(tramiteHecho);
			if (tramiteHecho == null) {
				throw new Exception(ehcodigo.toString());
			}
			return tramiteHecho;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ehcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param tramiteTrcodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param hechoDenunciadoHdcodigo
	 *            String
	 * @param ehfecha
	 *            Date
	 * @param ehhora
	 *            String
	 * @param ehcodpor
	 *            String
	 * @param ehcodpde
	 *            String
	 * @param ehtexto
	 *            String
	 * @param ehcozs
	 *            String
	 * @param ehcivihe
	 *            BigDecimal
	 * @param ehacuse
	 *            Date
	 * @param ehenviomail
	 *            String
	 * @param ehdiremail
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "ehcodigo", required = false) String ehcodigo,
			@RequestParam(value = "tramiteTrcodigo", required = false) String tramiteTrcodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "hechoDenunciadoHdcodigo", required = false) String hechoDenunciadoHdcodigo,
			@RequestParam(value = "ehfecha", required = false) Date ehfecha,
			@RequestParam(value = "ehhora", required = false) String ehhora,
			@RequestParam(value = "ehcodpor", required = false) String ehcodpor,
			@RequestParam(value = "ehcodpde", required = false) String ehcodpde,
			@RequestParam(value = "ehtexto", required = false) String ehtexto,
			@RequestParam(value = "ehcozs", required = false) String ehcozs,
			@RequestParam(value = "ehcivihe", required = false) BigDecimal ehcivihe,
			@RequestParam(value = "ehacuse", required = false) Date ehacuse,
			@RequestParam(value = "ehenviomail", required = false) String ehenviomail,
			@RequestParam(value = "ehdiremail", required = false) String ehdiremail,
			HttpServletRequest request) {
		try {
			TramiteHecho filterTramiteHecho = new TramiteHecho(ehcodigo,
					ehfecha, ehhora, ehcodpor, ehcodpde, ehtexto, ehcozs,
					ehcivihe, ehacuse, ehenviomail, ehdiremail, null, null,
					new Tramite(tramiteTrcodigo, null, null, null, null),
					new CensoMonitor(censoMonitorMocodigo, null, null, null,
							null, null, null, null, null, null, null, null),
					new HechoDenunciado(hechoDenunciadoHdcodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TramiteHecho> tramiteHechos = this.tramiteHechoService
						.findAll(filterTramiteHecho, pagination);

				if (tramiteHechos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTramiteHecho, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramiteHechos);
				return data;
			} else {
				List<TramiteHecho> tramiteHechos = this.tramiteHechoService
						.findAll(filterTramiteHecho, pagination);
				if (tramiteHechos == null) {
					throw new Exception("No data Found.");
				}
				return tramiteHechos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTramiteHecho
	 *            TramiteHecho
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tramiteHecho", required = false) TramiteHecho filterTramiteHecho,
			HttpServletRequest request) {
		try {
			return tramiteHechoService
					.findAllCount(filterTramiteHecho != null ? filterTramiteHecho
							: new TramiteHecho());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param response
	 *            HttpServletResponse
	 * @return TramiteHecho
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TramiteHecho edit(@RequestBody TramiteHecho tramiteHecho,
			HttpServletResponse response) {
		try {
			TramiteHecho tramiteHechoAux = this.tramiteHechoService
					.update(tramiteHecho);
			logger.info("Entity correctly inserted!");
			return tramiteHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TramiteHecho add(@RequestBody TramiteHecho tramiteHecho) {
		try {
			TramiteHecho tramiteHechoAux = this.tramiteHechoService
					.add(tramiteHecho);
			logger.info("Entity correctly inserted!");
			return tramiteHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ehcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ehcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TramiteHecho tramiteHecho = new TramiteHecho();
			tramiteHecho.setEhcodigo(ehcodigo);
			this.tramiteHechoService.remove(tramiteHecho);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ehcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tramiteHechoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tramiteHechoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TramiteHecho> tramiteHechoList = new ArrayList<TramiteHecho>();
		try {
			for (ArrayList<String> tramiteHechoId : tramiteHechoIds) {
				Iterator<String> iterator = tramiteHechoId.iterator();
				TramiteHecho tramiteHecho = new TramiteHecho();
				tramiteHecho.setEhcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tramiteHechoList.add(tramiteHecho);
			}
			this.tramiteHechoService.removeMultiple(tramiteHechoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTramiteHechoService'.
	 * 
	 * @return TramiteHechoService
	 */
	protected TramiteHechoService getTramiteHechoService() {
		return this.tramiteHechoService;
	}

	/**
	 * Method 'setTramiteHechoService'.
	 * 
	 * @param tramiteHechoService
	 *            TramiteHechoService
	 * @return
	 */
	public void setTramiteHechoService(TramiteHechoService tramiteHechoService) {
		this.tramiteHechoService = tramiteHechoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
