package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TramiteService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Tramite;

/**
 * * TramiteController generated by UDA, 05-mar-2012 9:11:48.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tramite")
public class TramiteController {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteController.class);

	@Autowired
	private TramiteService tramiteService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tramite", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "altaTramite", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("altaTramite", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Tramite getById(@PathVariable String trcodigo) {
		try {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(trcodigo);
			tramite = this.tramiteService.find(tramite);
			if (tramite == null) {
				throw new Exception(trcodigo.toString());
			}
			return tramite;
		} catch (Exception e) {
			throw new ResourceNotFoundException(trcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			@RequestParam(value = "trnombre", required = false) String trnombre,
			@RequestParam(value = "trnombree", required = false) String trnombree,
			@RequestParam(value = "trbaja", required = false) Date trbaja,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite(trcodigo, trnombre, trnombree,
					trbaja);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tramite> tramites = this.tramiteService.findAll(
						filterTramite, pagination);

				if (tramites == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTramite, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramites);
				return data;
			} else {
				List<Tramite> tramites = this.tramiteService.findAll(
						filterTramite, pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}
				return tramites;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getTramitesAlta'. Obtiene todos los tramites que se pueden añadir
	 * en la pestaña de tramitación de una solicitud
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "allTramitesAlta", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllTramitesAlta(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			@RequestParam(value = "trnombre", required = false) String trnombre,
			@RequestParam(value = "trnombree", required = false) String trnombree,
			@RequestParam(value = "trbaja", required = false) Date trbaja,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite(trcodigo, trnombre, trnombree,
					trbaja);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tramite> tramites = this.tramiteService.findAll(
						filterTramite, pagination);

				if (tramites == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTramite, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramites);
				return data;
			} else {
				List<Tramite> tramites = this.tramiteService
						.findAllTramitesAlta(filterTramite, pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}
				return tramites;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param trnombre
	 *            String
	 * @param trnombree
	 *            String
	 * @param trbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/alltramites", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllTramites(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			@RequestParam(value = "trnombre", required = false) String trnombre,
			@RequestParam(value = "trnombree", required = false) String trnombree,
			@RequestParam(value = "trbaja", required = false) Date trbaja,
			HttpServletRequest request) {
		try {
			Tramite filterTramite = new Tramite(trcodigo, trnombre, trnombree,
					trbaja);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tramite> tramites = this.tramiteService.findAllTramites(
						filterTramite, pagination);

				if (tramites == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.tramiteService
						.findAllTramitesCount(filterTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramites);
				return data;
			} else {
				List<Tramite> tramites = this.tramiteService.findAllTramites(
						filterTramite, pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}
				return tramites;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTramite
	 *            Tramite
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tramite", required = false) Tramite filterTramite,
			HttpServletRequest request) {
		try {
			return tramiteService
					.findAllCount(filterTramite != null ? filterTramite
							: new Tramite());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return Tramite
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tramite edit(
			@RequestParam(value = "trcodigo", required = true) String trcodigo) {
		try {

			Tramite tramite = new Tramite();
			tramite.setTrcodigo(trcodigo);
			tramite.setTrbaja(new Date());

			Tramite tramiteAux = this.tramiteService.updateFecha(tramite);
			logger.info("Entity correctly inserted!");
			return tramiteAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tramite add(@RequestBody Tramite tramite) {
		try {
			Tramite tramiteAux = this.tramiteService.add(tramite);
			logger.info("Entity correctly inserted!");
			return tramiteAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addTramite'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */

	@RequestMapping(value = "addTramite", method = RequestMethod.POST)
	public @ResponseBody
	Tramite addTramite(@RequestBody Tramite tramite) {
		try {
			Tramite tramiteAux = this.tramiteService.addTramite(tramite);
			logger.info("Entity correctly inserted!");
			return tramiteAux;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String trcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(trcodigo);
			this.tramiteService.remove(tramite);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + trcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tramiteIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tramiteIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Tramite> tramiteList = new ArrayList<Tramite>();
		try {
			for (ArrayList<String> tramiteId : tramiteIds) {
				Iterator<String> iterator = tramiteId.iterator();
				Tramite tramite = new Tramite();
				tramite.setTrcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tramiteList.add(tramite);
			}
			this.tramiteService.removeMultiple(tramiteList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTramiteService'.
	 * 
	 * @return TramiteService
	 */
	protected TramiteService getTramiteService() {
		return this.tramiteService;
	}

	/**
	 * Method 'setTramiteService'.
	 * 
	 * @param tramiteService
	 *            TramiteService
	 * @return
	 */
	public void setTramiteService(TramiteService tramiteService) {
		this.tramiteService = tramiteService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
