package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipodocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Tipodoc;

/**
 *  * TipodocController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipodoc")

public class TipodocController  {

	private static final Logger logger = LoggerFactory.getLogger(TipodocController.class);

	@Autowired
	private TipodocService tipodocService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipodoc", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tdcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tdcodigo}", method = RequestMethod.GET)
	public @ResponseBody Tipodoc getById(@PathVariable String tdcodigo) {
		try{
            Tipodoc tipodoc = new Tipodoc();
			tipodoc.setTdcodigo(tdcodigo);
            tipodoc = this.tipodocService.find(tipodoc);
            if (tipodoc == null) {
                throw new Exception(tdcodigo.toString());
            }
            return tipodoc;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tdcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tdcodigo String
	 *@param	  tdnombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tdcodigo", required = false) String tdcodigo,
	@RequestParam(value = "tdnombre", required = false) String tdnombre,
			HttpServletRequest request) {
			try{
				Tipodoc filterTipodoc = new Tipodoc(tdcodigo, tdnombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Tipodoc> tipodocs =  this.tipodocService.findAll(filterTipodoc, pagination);

     			    if (tipodocs == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipodoc, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipodocs);
				    return data;
				}else{
				    List<Tipodoc> tipodocs =  this.tipodocService.findAll(filterTipodoc, pagination);
					if (tipodocs == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipodocs;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipodoc Tipodoc 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipodoc", required = false) Tipodoc  filterTipodoc, HttpServletRequest request) {
	    try {
			return tipodocService
					.findAllCount(filterTipodoc != null ? filterTipodoc
							: new Tipodoc ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipodoc Tipodoc 
	 * @param response HttpServletResponse
	 * @return Tipodoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tipodoc edit(@RequestBody Tipodoc tipodoc, HttpServletResponse response) {		
		try {
            Tipodoc tipodocAux  = this.tipodocService.update(tipodoc);
			logger.info("Entity correctly inserted!");
            return tipodocAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipodoc Tipodoc 
	 * @return Tipodoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tipodoc add(@RequestBody Tipodoc tipodoc) {		
        try {
            Tipodoc tipodocAux = this.tipodocService.add(tipodoc);
            logger.info("Entity correctly inserted!");
        	return tipodocAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tdcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tdcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tdcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Tipodoc tipodoc = new Tipodoc();
            tipodoc.setTdcodigo(tdcodigo);
            this.tipodocService.remove(tipodoc);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tdcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipodocIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipodocIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Tipodoc> tipodocList = new ArrayList<Tipodoc>();
        try{		    
            for (ArrayList<String> tipodocId:tipodocIds) {
			    Iterator<String> iterator = tipodocId.iterator();
				    Tipodoc tipodoc = new Tipodoc();
			        tipodoc.setTdcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipodocList.add(tipodoc);
		    }
            this.tipodocService.removeMultiple(tipodocList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipodocService'.
	 *
	 * @return TipodocService
	 */
	protected TipodocService getTipodocService() {
		return this.tipodocService;
	}

	/**
	 * Method 'setTipodocService'.
	 *
	 * @param tipodocService  TipodocService
	 * @return
	 */
	public void setTipodocService(TipodocService tipodocService) {
		this.tipodocService = tipodocService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
