package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipoRespuestaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipoRespuesta;

/**
 *  * TipoRespuestaController generated by UDA, 01-feb-2012 17:10:42.
 *  
 */
 
@Controller
@RequestMapping (value = "/tiporespuesta")

public class TipoRespuestaController  {

	private static final Logger logger = LoggerFactory.getLogger(TipoRespuestaController.class);

	@Autowired
	private TipoRespuestaService tipoRespuestaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tiporespuesta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  p8codigo String
	 * @return String
	 */
	@RequestMapping(value = "/{p8codigo}", method = RequestMethod.GET)
	public @ResponseBody TipoRespuesta getById(@PathVariable String p8codigo) {
		try{
            TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(p8codigo);
            tipoRespuesta = this.tipoRespuestaService.find(tipoRespuesta);
            if (tipoRespuesta == null) {
                throw new Exception(p8codigo.toString());
            }
            return tipoRespuesta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(p8codigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  p8codigo String
	 *@param	  p8nombre String
	 *@param	  p8nombree String
	 *@param	  p8tedes String
	 *@param	  p8tedese String
	 *@param	  p8teico String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "p8codigo", required = false) String p8codigo,
	@RequestParam(value = "p8nombre", required = false) String p8nombre,
	@RequestParam(value = "p8nombree", required = false) String p8nombree,
	@RequestParam(value = "p8tedes", required = false) String p8tedes,
	@RequestParam(value = "p8tedese", required = false) String p8tedese,
	@RequestParam(value = "p8teico", required = false) String p8teico,
			HttpServletRequest request) {
			try{
				TipoRespuesta filterTipoRespuesta = new TipoRespuesta(p8codigo, p8nombre, p8nombree, p8tedes, p8tedese, p8teico);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipoRespuesta> tipoRespuestas =  this.tipoRespuestaService.findAll(filterTipoRespuesta, pagination);

     			    if (tipoRespuestas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipoRespuesta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipoRespuestas);
				    return data;
				}else{
				    List<TipoRespuesta> tipoRespuestas =  this.tipoRespuestaService.findAll(filterTipoRespuesta, pagination);
					if (tipoRespuestas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipoRespuestas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipoRespuesta TipoRespuesta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipoRespuesta", required = false) TipoRespuesta  filterTipoRespuesta, HttpServletRequest request) {
	    try {
			return tipoRespuestaService
					.findAllCount(filterTipoRespuesta != null ? filterTipoRespuesta
							: new TipoRespuesta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipoRespuesta TipoRespuesta 
	 * @param response HttpServletResponse
	 * @return TipoRespuesta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipoRespuesta edit(@RequestBody TipoRespuesta tipoRespuesta, HttpServletResponse response) {		
		try {
            TipoRespuesta tipoRespuestaAux  = this.tipoRespuestaService.update(tipoRespuesta);
			logger.info("Entity correctly inserted!");
            return tipoRespuestaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipoRespuesta TipoRespuesta 
	 * @return TipoRespuesta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoRespuesta add(@RequestBody TipoRespuesta tipoRespuesta) {		
        try {
            TipoRespuesta tipoRespuestaAux = this.tipoRespuestaService.add(tipoRespuesta);
            logger.info("Entity correctly inserted!");
        	return tipoRespuestaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  p8codigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{p8codigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String p8codigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipoRespuesta tipoRespuesta = new TipoRespuesta();
            tipoRespuesta.setP8codigo(p8codigo);
            this.tipoRespuestaService.remove(tipoRespuesta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  p8codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipoRespuestaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipoRespuestaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipoRespuesta> tipoRespuestaList = new ArrayList<TipoRespuesta>();
        try{		    
            for (ArrayList<String> tipoRespuestaId:tipoRespuestaIds) {
			    Iterator<String> iterator = tipoRespuestaId.iterator();
				    TipoRespuesta tipoRespuesta = new TipoRespuesta();
			        tipoRespuesta.setP8codigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipoRespuestaList.add(tipoRespuesta);
		    }
            this.tipoRespuestaService.removeMultiple(tipoRespuestaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipoRespuestaService'.
	 *
	 * @return TipoRespuestaService
	 */
	protected TipoRespuestaService getTipoRespuestaService() {
		return this.tipoRespuestaService;
	}

	/**
	 * Method 'setTipoRespuestaService'.
	 *
	 * @param tipoRespuestaService  TipoRespuestaService
	 * @return
	 */
	public void setTipoRespuestaService(TipoRespuestaService tipoRespuestaService) {
		this.tipoRespuestaService = tipoRespuestaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
