package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipoComunicacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipoComunicacion;

/**
 * * TipoComunicacionController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/tipocomunicacion")
public class TipoComunicacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoComunicacionController.class);

	@Autowired()
	private TipoComunicacionService tipoComunicacionService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipocomunicacion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param m6codigo
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/{m6codigo}", method = RequestMethod.GET)
	public @ResponseBody()
	TipoComunicacion getById(@PathVariable() Integer m6codigo) {
		try {
			TipoComunicacion tipoComunicacion = new TipoComunicacion();
			tipoComunicacion.setM6codigo(m6codigo);
			tipoComunicacion = this.tipoComunicacionService
					.find(tipoComunicacion);
			if (tipoComunicacion == null) {
				throw new Exception(m6codigo.toString());
			}
			return tipoComunicacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(m6codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param m6codigo
	 *            Integer
	 * @param m6notipo
	 *            String
	 * @param m6tetipo
	 *            String
	 * @param m6notipoe
	 *            String
	 * @param m6notipoi
	 *            String
	 * @param m6notipof
	 *            String
	 * @param m6notipoa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "m6codigo", required = false) Integer m6codigo,
			@RequestParam(value = "m6notipo", required = false) String m6notipo,
			@RequestParam(value = "m6tetipo", required = false) String m6tetipo,
			@RequestParam(value = "m6notipoe", required = false) String m6notipoe,
			@RequestParam(value = "m6notipoi", required = false) String m6notipoi,
			@RequestParam(value = "m6notipof", required = false) String m6notipof,
			@RequestParam(value = "m6notipoa", required = false) String m6notipoa,
			HttpServletRequest request) {
		try {
			TipoComunicacion filterTipoComunicacion = new TipoComunicacion(
					m6codigo, m6notipo, m6tetipo, m6notipoe, m6notipoi,
					m6notipof, m6notipoa);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoComunicacion> tipoComunicacions = this.tipoComunicacionService
						.findAll(filterTipoComunicacion, pagination);

				if (tipoComunicacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipoComunicacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipoComunicacions);
				return data;
			} else {
				List<TipoComunicacion> tipoComunicacions = this.tipoComunicacionService
						.findAll(filterTipoComunicacion, pagination);
				if (tipoComunicacions == null) {
					throw new Exception("No data Found.");
				}
				return tipoComunicacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipoComunicacion
	 *            TipoComunicacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "tipoComunicacion", required = false) TipoComunicacion filterTipoComunicacion,
			HttpServletRequest request) {
		try {
			return tipoComunicacionService
					.findAllCount(filterTipoComunicacion != null ? filterTipoComunicacion
							: new TipoComunicacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipoComunicacion
	 *            TipoComunicacion
	 * @param response
	 *            HttpServletResponse
	 * @return TipoComunicacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	TipoComunicacion edit(@RequestBody() TipoComunicacion tipoComunicacion,
			HttpServletResponse response) {
		try {
			TipoComunicacion tipoComunicacionAux = this.tipoComunicacionService
					.update(tipoComunicacion);
			logger.info("Entity correctly inserted!");
			return tipoComunicacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipoComunicacion
	 *            TipoComunicacion
	 * @return TipoComunicacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	TipoComunicacion add(@RequestBody() TipoComunicacion tipoComunicacion) {
		try {
			TipoComunicacion tipoComunicacionAux = this.tipoComunicacionService
					.add(tipoComunicacion);
			logger.info("Entity correctly inserted!");
			return tipoComunicacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param m6codigo
	 *            Integer
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{m6codigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() Integer m6codigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipoComunicacion tipoComunicacion = new TipoComunicacion();
			tipoComunicacion.setM6codigo(m6codigo);
			this.tipoComunicacionService.remove(tipoComunicacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + m6codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipoComunicacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> tipoComunicacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipoComunicacion> tipoComunicacionList = new ArrayList<TipoComunicacion>();
		try {
			for (ArrayList<String> tipoComunicacionId : tipoComunicacionIds) {
				Iterator<String> iterator = tipoComunicacionId.iterator();
				TipoComunicacion tipoComunicacion = new TipoComunicacion();
				tipoComunicacion.setM6codigo(ObjectConversionManager.convert(
						iterator.next(), Integer.class));
				tipoComunicacionList.add(tipoComunicacion);
			}
			this.tipoComunicacionService.removeMultiple(tipoComunicacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipoComunicacionService'.
	 * 
	 * @return TipoComunicacionService
	 */
	protected TipoComunicacionService getTipoComunicacionService() {
		return this.tipoComunicacionService;
	}

	/**
	 * Method 'setTipoComunicacionService'.
	 * 
	 * @param tipoComunicacionService
	 *            TipoComunicacionService
	 * @return
	 */
	public void setTipoComunicacionService(
			TipoComunicacionService tipoComunicacionService) {
		this.tipoComunicacionService = tipoComunicacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
