package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipmotActuacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipmotActuacion;

/**
 *  * TipmotActuacionController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipmotactuacion")

public class TipmotActuacionController  {

	private static final Logger logger = LoggerFactory.getLogger(TipmotActuacionController.class);

	@Autowired
	private TipmotActuacionService tipmotActuacionService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipmotactuacion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tmacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tmacodigo}", method = RequestMethod.GET)
	public @ResponseBody TipmotActuacion getById(@PathVariable String tmacodigo) {
		try{
            TipmotActuacion tipmotActuacion = new TipmotActuacion();
			tipmotActuacion.setTmacodigo(tmacodigo);
            tipmotActuacion = this.tipmotActuacionService.find(tipmotActuacion);
            if (tipmotActuacion == null) {
                throw new Exception(tmacodigo.toString());
            }
            return tipmotActuacion;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tmacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tmacodigo String
	 *@param	  tmanombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tmacodigo", required = false) String tmacodigo,
	@RequestParam(value = "tmanombre", required = false) String tmanombre,
			HttpServletRequest request) {
			try{
				TipmotActuacion filterTipmotActuacion = new TipmotActuacion(tmacodigo, tmanombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipmotActuacion> tipmotActuacions =  this.tipmotActuacionService.findAll(filterTipmotActuacion, pagination);

     			    if (tipmotActuacions == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipmotActuacion, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipmotActuacions);
				    return data;
				}else{
				    List<TipmotActuacion> tipmotActuacions =  this.tipmotActuacionService.findAll(filterTipmotActuacion, pagination);
					if (tipmotActuacions == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipmotActuacions;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipmotActuacion TipmotActuacion 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipmotActuacion", required = false) TipmotActuacion  filterTipmotActuacion, HttpServletRequest request) {
	    try {
			return tipmotActuacionService
					.findAllCount(filterTipmotActuacion != null ? filterTipmotActuacion
							: new TipmotActuacion ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipmotActuacion TipmotActuacion 
	 * @param response HttpServletResponse
	 * @return TipmotActuacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipmotActuacion edit(@RequestBody TipmotActuacion tipmotActuacion, HttpServletResponse response) {		
		try {
            TipmotActuacion tipmotActuacionAux  = this.tipmotActuacionService.update(tipmotActuacion);
			logger.info("Entity correctly inserted!");
            return tipmotActuacionAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipmotActuacion TipmotActuacion 
	 * @return TipmotActuacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipmotActuacion add(@RequestBody TipmotActuacion tipmotActuacion) {		
        try {
            TipmotActuacion tipmotActuacionAux = this.tipmotActuacionService.add(tipmotActuacion);
            logger.info("Entity correctly inserted!");
        	return tipmotActuacionAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tmacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tmacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tmacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipmotActuacion tipmotActuacion = new TipmotActuacion();
            tipmotActuacion.setTmacodigo(tmacodigo);
            this.tipmotActuacionService.remove(tipmotActuacion);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tmacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipmotActuacionIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipmotActuacionIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipmotActuacion> tipmotActuacionList = new ArrayList<TipmotActuacion>();
        try{		    
            for (ArrayList<String> tipmotActuacionId:tipmotActuacionIds) {
			    Iterator<String> iterator = tipmotActuacionId.iterator();
				    TipmotActuacion tipmotActuacion = new TipmotActuacion();
			        tipmotActuacion.setTmacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipmotActuacionList.add(tipmotActuacion);
		    }
            this.tipmotActuacionService.removeMultiple(tipmotActuacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipmotActuacionService'.
	 *
	 * @return TipmotActuacionService
	 */
	protected TipmotActuacionService getTipmotActuacionService() {
		return this.tipmotActuacionService;
	}

	/**
	 * Method 'setTipmotActuacionService'.
	 *
	 * @param tipmotActuacionService  TipmotActuacionService
	 * @return
	 */
	public void setTipmotActuacionService(TipmotActuacionService tipmotActuacionService) {
		this.tipmotActuacionService = tipmotActuacionService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
