package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipReqNormativoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipReqNormativo;

/**
 * * TipReqNormativoController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipreqnormativo")
public class TipReqNormativoController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipReqNormativoController.class);

	@Autowired
	private TipReqNormativoService tipReqNormativoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipreqnormativo", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipreqnormativoModal", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tticodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tticodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipReqNormativo getById(@PathVariable String tticodigo) {
		try {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(tticodigo);
			tipReqNormativo = this.tipReqNormativoService.find(tipReqNormativo);
			if (tipReqNormativo == null) {
				throw new Exception(tticodigo.toString());
			}
			return tipReqNormativo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tticodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param ttinombre
	 *            String
	 * @param ttinoco
	 *            String
	 * @param ttitede
	 *            String
	 * @param tticose
	 *            String
	 * @param ttinoco2
	 *            String
	 * @param ttiinsel1
	 *            String
	 * @param tticol4
	 *            String
	 * @param ttinombree
	 *            String
	 * @param ttinombrei
	 *            String
	 * @param ttinombref
	 *            String
	 * @param ttinocoe
	 *            String
	 * @param ttinocoi
	 *            String
	 * @param ttinocof
	 *            String
	 * @param ttitedee
	 *            String
	 * @param ttitedei
	 *            String
	 * @param ttitedef
	 *            String
	 * @param tticodgrupo
	 *            String
	 * @param ttinombrea
	 *            String
	 * @param ttinocoa
	 *            String
	 * @param ttitedea
	 *            String
	 * @param tticoe7
	 *            String
	 * @param tticoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tticodigo", required = false) String tticodigo,
			@RequestParam(value = "ttinombre", required = false) String ttinombre,
			@RequestParam(value = "ttinoco", required = false) String ttinoco,
			@RequestParam(value = "ttitede", required = false) String ttitede,
			@RequestParam(value = "tticose", required = false) String tticose,
			@RequestParam(value = "ttinoco2", required = false) String ttinoco2,
			@RequestParam(value = "ttiinsel1", required = false) String ttiinsel1,
			@RequestParam(value = "tticol4", required = false) String tticol4,
			@RequestParam(value = "ttinombree", required = false) String ttinombree,
			@RequestParam(value = "ttinombrei", required = false) String ttinombrei,
			@RequestParam(value = "ttinombref", required = false) String ttinombref,
			@RequestParam(value = "ttinocoe", required = false) String ttinocoe,
			@RequestParam(value = "ttinocoi", required = false) String ttinocoi,
			@RequestParam(value = "ttinocof", required = false) String ttinocof,
			@RequestParam(value = "ttitedee", required = false) String ttitedee,
			@RequestParam(value = "ttitedei", required = false) String ttitedei,
			@RequestParam(value = "ttitedef", required = false) String ttitedef,
			@RequestParam(value = "tticodgrupo", required = false) String tticodgrupo,
			@RequestParam(value = "ttinombrea", required = false) String ttinombrea,
			@RequestParam(value = "ttinocoa", required = false) String ttinocoa,
			@RequestParam(value = "ttitedea", required = false) String ttitedea,
			@RequestParam(value = "tticoe7", required = false) String tticoe7,
			@RequestParam(value = "tticoinc", required = false) String tticoinc,
			HttpServletRequest request) {
		try {
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo(
					tticodigo, ttinombre, ttinoco, ttitede, tticose, ttinoco2,
					ttiinsel1, tticol4, ttinombree, ttinombrei, ttinombref,
					ttinocoe, ttinocoi, ttinocof, ttitedee, ttitedei, ttitedef,
					tticodgrupo, ttinombrea, ttinocoa, ttitedea, tticoe7,
					tticoinc);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAll(filterTipReqNormativo, pagination);

				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipReqNormativo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipReqNormativos);
				return data;
			} else {
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAll(filterTipReqNormativo, pagination);
				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}
				return tipReqNormativos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tipReqNormativo", required = false) TipReqNormativo filterTipReqNormativo,
			HttpServletRequest request) {
		try {
			return tipReqNormativoService
					.findAllCount(filterTipReqNormativo != null ? filterTipReqNormativo
							: new TipReqNormativo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param ttinombre
	 *            String
	 * @param ttinoco
	 *            String
	 * @param ttitede
	 *            String
	 * @param tticose
	 *            String
	 * @param ttinoco2
	 *            String
	 * @param ttiinsel1_
	 *            String
	 * @param tticol4
	 *            String
	 * @param ttinombree
	 *            String
	 * @param ttinombrei
	 *            String
	 * @param ttinombref
	 *            String
	 * @param ttinocoe
	 *            String
	 * @param ttinocoi
	 *            String
	 * @param ttinocof
	 *            String
	 * @param ttitedee
	 *            String
	 * @param ttitedei
	 *            String
	 * @param ttitedef
	 *            String
	 * @param tticodgrupo
	 *            String
	 * @param ttinombrea
	 *            String
	 * @param ttinocoa
	 *            String
	 * @param ttitedea
	 *            String
	 * @param tticoe7
	 *            String
	 * @param tticoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllInfracciones", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllInfracciones(
			@RequestParam(value = "tticodigo", required = false) String tticodigo,
			@RequestParam(value = "ttinombre", required = false) String ttinombre,
			@RequestParam(value = "ttinoco", required = false) String ttinoco,
			@RequestParam(value = "ttitede", required = false) String ttitede,
			@RequestParam(value = "tticose", required = false) String tticose,
			@RequestParam(value = "ttinoco2", required = false) String ttinoco2,
			@RequestParam(value = "ttiinsel1", required = false) String ttiinsel1_,
			@RequestParam(value = "tticol4", required = false) String tticol4,
			@RequestParam(value = "ttinombree", required = false) String ttinombree,
			@RequestParam(value = "ttinombrei", required = false) String ttinombrei,
			@RequestParam(value = "ttinombref", required = false) String ttinombref,
			@RequestParam(value = "ttinocoe", required = false) String ttinocoe,
			@RequestParam(value = "ttinocoi", required = false) String ttinocoi,
			@RequestParam(value = "ttinocof", required = false) String ttinocof,
			@RequestParam(value = "ttitedee", required = false) String ttitedee,
			@RequestParam(value = "ttitedei", required = false) String ttitedei,
			@RequestParam(value = "ttitedef", required = false) String ttitedef,
			@RequestParam(value = "tticodgrupo", required = false) String tticodgrupo,
			@RequestParam(value = "ttinombrea", required = false) String ttinombrea,
			@RequestParam(value = "ttinocoa", required = false) String ttinocoa,
			@RequestParam(value = "ttitedea", required = false) String ttitedea,
			@RequestParam(value = "tticoe7", required = false) String tticoe7,
			@RequestParam(value = "tticoinc", required = false) String tticoinc,
			HttpServletRequest request) {
		try {
			String ttiinsel1 = ("".equals(ttiinsel1_)) ? null : ttiinsel1_;
			TipReqNormativo filterTipReqNormativo = new TipReqNormativo(
					tticodigo, ttinombre, ttinoco, ttitede, tticose, ttinoco2,
					ttiinsel1, tticol4, ttinombree, ttinombrei, ttinombref,
					ttinocoe, ttinocoi, ttinocof, ttitedee, ttitedei, ttitedef,
					tticodgrupo, ttinombrea, ttinocoa, ttitedea, tticoe7,
					tticoinc);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAllLikeReqNormativo(filterTipReqNormativo,
								pagination, false);

				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountInfracciones(filterTipReqNormativo,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipReqNormativos);
				return data;
			} else {
				List<TipReqNormativo> tipReqNormativos = this.tipReqNormativoService
						.findAllLikeReqNormativo(filterTipReqNormativo,
								pagination, false);
				if (tipReqNormativos == null) {
					throw new Exception("No data Found.");
				}
				return tipReqNormativos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountInfracciones(
			@RequestParam(value = "tipReqNormativo", required = false) TipReqNormativo filterTipReqNormativo,
			HttpServletRequest request) {
		try {
			return tipReqNormativoService.findAllLikeReqNormativoCount(
					filterTipReqNormativo != null ? filterTipReqNormativo
							: new TipReqNormativo(), false);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param response
	 *            HttpServletResponse
	 * @return TipReqNormativo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipReqNormativo edit(@RequestBody TipReqNormativo tipReqNormativo,
			HttpServletResponse response) {
		try {
			TipReqNormativo tipReqNormativoAux = this.tipReqNormativoService
					.update(tipReqNormativo);
			logger.info("Entity correctly inserted!");
			return tipReqNormativoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipReqNormativo add(@RequestBody TipReqNormativo tipReqNormativo) {
		try {
			TipReqNormativo tipReqNormativoAux = this.tipReqNormativoService
					.add(tipReqNormativo);
			logger.info("Entity correctly inserted!");
			return tipReqNormativoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tticodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tticodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tticodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipReqNormativo tipReqNormativo = new TipReqNormativo();
			tipReqNormativo.setTticodigo(tticodigo);
			this.tipReqNormativoService.remove(tipReqNormativo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + tticodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipReqNormativoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tipReqNormativoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipReqNormativo> tipReqNormativoList = new ArrayList<TipReqNormativo>();
		try {
			for (ArrayList<String> tipReqNormativoId : tipReqNormativoIds) {
				Iterator<String> iterator = tipReqNormativoId.iterator();
				TipReqNormativo tipReqNormativo = new TipReqNormativo();
				tipReqNormativo.setTticodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tipReqNormativoList.add(tipReqNormativo);
			}
			this.tipReqNormativoService.removeMultiple(tipReqNormativoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipReqNormativoService'.
	 * 
	 * @return TipReqNormativoService
	 */
	protected TipReqNormativoService getTipReqNormativoService() {
		return this.tipReqNormativoService;
	}

	/**
	 * Method 'setTipReqNormativoService'.
	 * 
	 * @param tipReqNormativoService
	 *            TipReqNormativoService
	 * @return
	 */
	public void setTipReqNormativoService(
			TipReqNormativoService tipReqNormativoService) {
		this.tipReqNormativoService = tipReqNormativoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
