package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.service.TipProtocoloService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipProtocolo;

/**
 * * TipProtocoloController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipprotocolo")
public class TipProtocoloController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipProtocoloController.class);

	@Autowired
	private TipProtocoloService tipProtocoloService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipprotocolo", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tpcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipProtocolo getById(@PathVariable String tpcodigo) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(tpcodigo);
			tipProtocolo = this.tipProtocoloService.find(tipProtocolo);
			if (tipProtocolo == null) {
				throw new Exception(tpcodigo.toString());
			}
			return tipProtocolo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tpcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @param campanhaCmcodigo
	 *            String
	 * @param tpnombre
	 *            String
	 * @param tpcotmo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tpcodigo", required = false) String tpcodigo,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo,
			@RequestParam(value = "tpnombre", required = false) String tpnombre,
			@RequestParam(value = "tpcotmo", required = false) String tpcotmo,
			HttpServletRequest request) {
		try {
			TipProtocolo filterTipProtocolo = new TipProtocolo(tpcodigo,
					tpnombre, tpcotmo, new Campanha(campanhaCmcodigo, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipProtocolo> tipProtocolos = this.tipProtocoloService
						.findAll(filterTipProtocolo, pagination);

				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipProtocolo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipProtocolos);
				return data;
			} else {
				List<TipProtocolo> tipProtocolos = this.tipProtocoloService
						.findAll(filterTipProtocolo, pagination);
				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}
				return tipProtocolos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProtocolos'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/buscarProtocolos", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProtocolos(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo,
			HttpServletRequest request) {
		try {
			TipProtocolo filterTipProtocolo = new TipProtocolo();
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			filterTipProtocolo.setCampanha(campanha);
			Pagination pagination = null;

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {

				List<TipProtocolo> tipProtocolos = this.tipProtocoloService
						.findAll(filterTipProtocolo, pagination);

				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();

				data.setRows(tipProtocolos);
				return data;
			} else {
				List<TipProtocolo> tipProtocolos = this.tipProtocoloService
						.findAll(filterTipProtocolo, pagination);
				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}
				return tipProtocolos;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipProtocolo
	 *            TipProtocolo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tipProtocolo", required = false) TipProtocolo filterTipProtocolo,
			HttpServletRequest request) {
		try {
			return tipProtocoloService
					.findAllCount(filterTipProtocolo != null ? filterTipProtocolo
							: new TipProtocolo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param response
	 *            HttpServletResponse
	 * @return TipProtocolo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipProtocolo edit(@RequestBody TipProtocolo tipProtocolo,
			HttpServletResponse response) {
		try {
			TipProtocolo tipProtocoloAux = this.tipProtocoloService
					.update(tipProtocolo);
			logger.info("Entity correctly inserted!");
			return tipProtocoloAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipProtocolo add(@RequestBody TipProtocolo tipProtocolo) {
		try {
			TipProtocolo tipProtocoloAux = this.tipProtocoloService
					.add(tipProtocolo);
			logger.info("Entity correctly inserted!");
			return tipProtocoloAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tpcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tpcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tpcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(tpcodigo);
			this.tipProtocoloService.remove(tipProtocolo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + tpcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipProtocoloIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tipProtocoloIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipProtocolo> tipProtocoloList = new ArrayList<TipProtocolo>();
		try {
			for (ArrayList<String> tipProtocoloId : tipProtocoloIds) {
				Iterator<String> iterator = tipProtocoloId.iterator();
				TipProtocolo tipProtocolo = new TipProtocolo();
				tipProtocolo.setTpcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tipProtocoloList.add(tipProtocolo);
			}
			this.tipProtocoloService.removeMultiple(tipProtocoloList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipProtocoloService'.
	 * 
	 * @return TipProtocoloService
	 */
	protected TipProtocoloService getTipProtocoloService() {
		return this.tipProtocoloService;
	}

	/**
	 * Method 'setTipProtocoloService'.
	 * 
	 * @param tipProtocoloService
	 *            TipProtocoloService
	 * @return
	 */
	public void setTipProtocoloService(TipProtocoloService tipProtocoloService) {
		this.tipProtocoloService = tipProtocoloService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
