package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.service.TipPregProtocService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipPregProtoc;

/**
 * * TipPregProtocController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tippregprotoc")
public class TipPregProtocController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipPregProtocController.class);

	@Autowired
	private TipPregProtocService tipPregProtocService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tippregprotoc", "model", model);
	}

	/**
	 * Method 'getCreateFormProtocolo'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "tippregprotocConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormProtocolo(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tippregprotocConsulta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	TipPregProtoc getById(@PathVariable String trcodigo) {
		try {
			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTrcodigo(trcodigo);
			tipPregProtoc = this.tipPregProtocService.find(tipPregProtoc);
			if (tipPregProtoc == null) {
				throw new Exception(trcodigo.toString());
			}
			return tipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(trcodigo.toString());
		}
	}

	/**
	 * Method 'getByIdProtocoloOrdenado'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloOrdenado", method = RequestMethod.GET)
	public @ResponseBody
	Object getByIdProtocoloOrdenado(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			HttpServletRequest request) {
		try {
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(trcodigo);

			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTipProtocolo(tipProtocolo);

			List<TipPregProtoc> listTipPregProtoc = this.tipPregProtocService
					.findAllProtocoloOrdenado(tipPregProtoc);

			return listTipPregProtoc;
		} catch (Exception e) {
			throw new ResourceNotFoundException(trcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param tipProtocoloTpcodigo
	 *            String
	 * @param tipReqNormativoTticodigo
	 *            String
	 * @param trnrtipp
	 *            Long
	 * @param trcotipp
	 *            String
	 * @param trdetipp
	 *            String
	 * @param trinti
	 *            String
	 * @param trinre
	 *            String
	 * @param trrees
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			@RequestParam(value = "tipProtocoloTpcodigo", required = false) String tipProtocoloTpcodigo,
			@RequestParam(value = "tipReqNormativoTticodigo", required = false) String tipReqNormativoTticodigo,
			@RequestParam(value = "trnrtipp", required = false) Long trnrtipp,
			@RequestParam(value = "trcotipp", required = false) String trcotipp,
			@RequestParam(value = "trdetipp", required = false) String trdetipp,
			@RequestParam(value = "trinti", required = false) String trinti,
			@RequestParam(value = "trinre", required = false) String trinre,
			@RequestParam(value = "trrees", required = false) String trrees,
			HttpServletRequest request) {
		try {
			TipPregProtoc filterTipPregProtoc = new TipPregProtoc(trcodigo,
					trnrtipp, trcotipp, trdetipp, trinti, trinre, trrees,
					new TipProtocolo(tipProtocoloTpcodigo, null, null, null,
							null, null), new TipReqNormativo(
							tipReqNormativoTticodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipPregProtoc> tipPregProtocs = this.tipPregProtocService
						.findAll(filterTipPregProtoc, pagination);

				if (tipPregProtocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterTipPregProtoc, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipPregProtocs);
				return data;
			} else {
				List<TipPregProtoc> tipPregProtocs = this.tipPregProtocService
						.findAll(filterTipPregProtoc, pagination);
				if (tipPregProtocs == null) {
					throw new Exception("No data Found.");
				}
				return tipPregProtocs;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterTipPregProtoc
	 *            TipPregProtoc
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "tipPregProtoc", required = false) TipPregProtoc filterTipPregProtoc,
			HttpServletRequest request) {
		try {
			return tipPregProtocService
					.findAllCount(filterTipPregProtoc != null ? filterTipPregProtoc
							: new TipPregProtoc());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param response
	 *            HttpServletResponse
	 * @return TipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TipPregProtoc edit(@RequestBody TipPregProtoc tipPregProtoc,
			HttpServletResponse response) {
		try {
			TipPregProtoc tipPregProtocAux = this.tipPregProtocService
					.update(tipPregProtoc);
			logger.info("Entity correctly inserted!");
			return tipPregProtocAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TipPregProtoc add(@RequestBody TipPregProtoc tipPregProtoc) {
		try {
			TipPregProtoc tipPregProtocAux = this.tipPregProtocService
					.add(tipPregProtoc);
			logger.info("Entity correctly inserted!");
			return tipPregProtocAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{trcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String trcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipPregProtoc tipPregProtoc = new TipPregProtoc();
			tipPregProtoc.setTrcodigo(trcodigo);
			this.tipPregProtocService.remove(tipPregProtoc);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + trcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tipPregProtocIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> tipPregProtocIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<TipPregProtoc> tipPregProtocList = new ArrayList<TipPregProtoc>();
		try {
			for (ArrayList<String> tipPregProtocId : tipPregProtocIds) {
				Iterator<String> iterator = tipPregProtocId.iterator();
				TipPregProtoc tipPregProtoc = new TipPregProtoc();
				tipPregProtoc.setTrcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				tipPregProtocList.add(tipPregProtoc);
			}
			this.tipPregProtocService.removeMultiple(tipPregProtocList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipPregProtocService'.
	 * 
	 * @return TipPregProtocService
	 */
	protected TipPregProtocService getTipPregProtocService() {
		return this.tipPregProtocService;
	}

	/**
	 * Method 'setTipPregProtocService'.
	 * 
	 * @param tipPregProtocService
	 *            TipPregProtocService
	 * @return
	 */
	public void setTipPregProtocService(
			TipPregProtocService tipPregProtocService) {
		this.tipPregProtocService = tipPregProtocService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
